/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/05/16, 12:59
!  AUTHOR(S): KOGA, Junichiro
!  File : TSpaceRotComboListener.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

import org.apache.log4j.Logger;

/**
 * TSPACEe[up̃ANVXi[
 * 
 * @author
 */
class TSpaceRotComboListener implements ActionListener {
    private Logger logger = Logger.getLogger(TSpaceRotComboListener.class
            .getName());
    private JTable tspaceTable;

    TSpaceRotComboListener(JTable tspaceTable) {
        this.tspaceTable = tspaceTable;
        logger.debug("registered listener.");
    }

    public void actionPerformed(ActionEvent ae) {
        logger.debug("doing action");
        int rot = ((JComboBox) ae.getSource()).getSelectedIndex();
        TableModelListener[] listeners = ((AbstractTableModel) tspaceTable
                .getModel()).getTableModelListeners();
        for (int i = 0; i < listeners.length; i++) {
            ((AbstractTableModel) tspaceTable.getModel())
                    .removeTableModelListener(listeners[i]);
        }
        int row = tspaceTable.getSelectedRow();
        if (row < 0) {
            for (int i = 0; i < listeners.length; i++) {
                ((AbstractTableModel) tspaceTable.getModel())
                        .addTableModelListener(listeners[i]);
            }
            tspaceTable.revalidate();
            tspaceTable.repaint();
            return;
        }
        if (rot == 0) {
            for (int i = 0; i < tspaceTable.getColumnCount(); i++) {
                tspaceTable.setValueAt("", row, i);
            }
        } else {
            for (int i = 1; i < tspaceTable.getColumnCount(); i++) {
                if (tspaceTable.getValueAt(row, i) == null
                        || tspaceTable.getValueAt(row, i).toString().trim()
                                .length() == 0) {
                    tspaceTable.setValueAt("0", row, i);
                }
            }
        }
        for (int i = 0; i < listeners.length; i++) {
            ((AbstractTableModel) tspaceTable.getModel())
                    .addTableModelListener(listeners[i]);
        }
        tspaceTable.revalidate();
        tspaceTable.repaint();
    }
}
