/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/16, 11:50
!  AUTHOR(S): KOGA, Junichiro
!  File : GeneralPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import java.awt.Color;
import java.awt.GridLayout;

import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.TemplateCopier;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileChangeEvent;
import ciss.phase_viewer.file.FileChangeListener;
import ciss.phase_viewer.file.FileNameEditPanel;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.ElemPanel;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

//import ciss.phase_viewer.projectbrowser.fileinfo.*;

/**
 * 
 * @author KOGA, Junichiro
 */
public class GeneralPanel extends ProjectManipulator implements
        FileChangeListener {
    private Logger logger = Logger.getLogger(GeneralPanel.class.getName());

    /** Creates a new instance of GeneralPanel */
    public GeneralPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void init() {
        initComponents();
        ProjectBrowserUtils
                .setHtmlToEditorPane(
                        jEditorPane1,
                        getClass()
                                .getResource(
                                        "/ciss/phase_viewer/plugins/projectmanipulator/phase/preparationpanel/basic.html"));
        logger.debug("projectInfo: " + projectInfo);
        ChaseFile[] finp = projectInfo.getChaseFileManager().getFiles("F_INP");
        finp[0].addFileChangeListener(this);

        // FINP.addFileInfoChangeListener(this);
        inputFileName.setHorizontalAlignment(JTextField.CENTER);
        inputFileName.setBackground(Color.WHITE);
        // inputFileName.setText(projectInfo.getFileInfoParser().getFileInfo("F_INP").getName());
        inputFileName.setText(finp[0].getFileName());
    }

    public void fileChanged(ChaseFileChangeEvent e) {
        ChaseFile newchfile = e.getFile();
        inputFileName.setText(newchfile.getFileName());
        projectInfo.getInputInterface().saveTo(
                new java.io.File(projectInfo.getProjectDirectory()
                        + System.getProperty("file.separator")
                        + newchfile.getFileName()));
    }

    public void initializeProject() {
    }

    private void initComponents() {
        jPanel5 = new javax.swing.JPanel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jPanel6 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        editFileNamesData = new javax.swing.JButton();
        editFileNamesDataEditor = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        inputFileName = new javax.swing.JTextField(10);
        templateCopy = new javax.swing.JButton();
        viewByEditor = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jEditorPane1 = new javax.swing.JEditorPane();

        // jPanel1.setLayout(new GridLayout(2,1));
        jPanel1.setLayout(new BoxLayout(jPanel1, BoxLayout.Y_AXIS));

        // jPanel3.setLayout(new BoxLayout(jPanel3,BoxLayout.X_AXIS));
        jPanel3.setBorder(new javax.swing.border.TitledBorder("input file"));

        inputFileName.setEditable(false);
        inputFileName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                inputFileNameActionPerformed(evt);
            }
        });

        // JPanel pinputFile = new JPanel();
        // pinputFile.setLayout(new GridLayout(1,1));
        // // pinputFile.setBorder(new TitledBorder("file name"));
        // pinputFile.add(inputFileName);
        jPanel3.add(inputFileName);
        // inputFileName.setPreferredSize(new Dimension(50, 25));

        templateCopy.setText("template");
        templateCopy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                templateCopyActionPerformed(evt);
            }
        });
        jPanel3.add(templateCopy);

        viewByEditor.setText("editor");
        viewByEditor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                viewByEditorActionPerformed(evt);
            }
        });
        // jPanel3.add(viewByEditor);

        jPanel6.add(jPanel3);

        // jPanel4.setLayout(new BoxLayout(jPanel4,BoxLayout.X_AXIS));
        jPanel4.setBorder(new javax.swing.border.TitledBorder("edit file names"));
        editFileNamesData.setText("edit file names");
        editFileNamesData
                .addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        editFileNamesDataActionPerformed(evt);
                    }
                });
        jPanel4.add(editFileNamesData);

        editFileNamesDataEditor.setText("edit file names using editor");
        editFileNamesDataEditor
                .addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        editFileNamesDataEditorActionPerformed(evt);
                    }
                });
        jPanel4.add(editFileNamesDataEditor);

        jPanel6.setLayout(new BoxLayout(jPanel6, BoxLayout.X_AXIS));
        jPanel6.add(jPanel4);

        jPanel1.add(jPanel6);

        //
        // jPanel2.setBorder(new
        // javax.swing.border.TitledBorder("description"));
        // jPanel2.setLayout(new GridLayout(1,1));
        // jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        // jScrollPane1.setViewportView(jEditorPane1);
        //
        // jPanel2.add(jScrollPane1);

        // ElemPanel ePanel = new ElemPanel(projectInfo);
        JComponent ePanel = (JComponent) projectInfo.getGUI(ElemPanel.class);
        JPanel ppPanel = new JPanel();
        ppPanel.setLayout(new GridLayout());
        ppPanel.setBorder(new TitledBorder("pseudopotential file(s)"));
        ppPanel.add(ePanel);
        jPanel1.add(ppPanel);
        // jPanel1.add(jPanel2);

        this.setLayout(new GridLayout());
        add(jPanel1);

    }

    private void viewByEditorActionPerformed(java.awt.event.ActionEvent evt) {
        // TODO add your handling code here:
        String nfinp = projectInfo.getProjectDirectory()
                + System.getProperty("file.separator")
                + projectInfo.getChaseFileManager().getFile("F_INP")
                        .getFileName();
        ProjectBrowserUtils.bootTextViewer(nfinp);
    }

    private void editFileNamesDataEditorActionPerformed(
            java.awt.event.ActionEvent evt) {
        // TODO add your handling code here:

        String fnames = projectInfo.getProjectDirectory()
                + System.getProperty("file.separator")
                + projectInfo.getChaseFileManager().getFile("FFILENAMES")
                        .getFileName();

        ProjectBrowserUtils.bootTextViewer(fnames);
    }

    private void inputFileNameActionPerformed(java.awt.event.ActionEvent evt) {
        // TODO add your handling code here:
    }

    private void editFileNamesDataActionPerformed(java.awt.event.ActionEvent evt) {
        // TODO add your handling code here:
        // PhaseFileInfoEditPanel editpanel = new
        // PhaseFileInfoEditPanel(projectInfo.getFileInfoParser());
        FileNameEditPanel editPanel = new FileNameEditPanel(
                projectInfo.getChaseFileManager());
    }

    private void templateCopyActionPerformed(java.awt.event.ActionEvent evt) {
        // TODO add your handling code here:
        bootTemplateCopierInpFile();
    }

    private GlobalProperties pm = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_PVIEWER);

    private void bootTemplateCopierInpFile() {
        String nfinp = projectInfo.getProjectDirectory()
                + System.getProperty("file.separator")
                + projectInfo.getChaseFileManager().getFile("F_INP")
                        .getFileName();

        String definp = System.getProperty("pviewer.home")
                + System.getProperty("file.separator")
                + pm.getProperty("inpdir");

        TemplateCopier copier = new TemplateCopier(this, nfinp);
        copier.setTemplatePath(definp);
        if (!copier.copyTemplate()) {
            logger.info("operation canceled/failed.");
            return;
        }
    }

    // Variables declaration - do not modify
    private javax.swing.JPanel AccuracyPanel;
    private javax.swing.JPanel ControlPanel;
    private javax.swing.JPanel PostProcessPanel;
    private javax.swing.JPanel SolverPanel;
    private javax.swing.JPanel StructurePanel;
    private javax.swing.JButton editFileNamesData;
    private javax.swing.JButton editFileNamesDataEditor;
    private javax.swing.JTextField inputFileName;
    private javax.swing.JEditorPane jEditorPane1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JButton templateCopy;
    private javax.swing.JButton viewByEditor;
    // End of variables declaration
}
