/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : JTextAreaAppender.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.logger;

import javax.swing.JTextArea;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class JTextAreaAppender extends AppenderSkeleton {
    private static JTextArea textarea;
    private static JTextAreaAppender appender;

    public JTextAreaAppender() {
        textarea = new JTextArea(5, 30);
        textarea.setEditable(false);
        layout = new PatternLayout("%-5p - %m%n");
        // layout = new PatternLayout();
    }

    protected void append(LoggingEvent event) {
        textarea.append(layout.format(event));
        textarea.setCaretPosition(textarea.getDocument().getLength());
    }

    //
    // class Append implements Runnable {
    // private LoggingEvent event;
    // Append(LoggingEvent event) {
    // this.event = event;
    // }
    // public void run() {
    // textarea.append(layout.format(event));
    // textarea.setCaretPosition(textarea.getDocument().getLength());
    // }
    // }
    public boolean requiresLayout() {
        return false;
    }

    public void close() {
        if (closed)
            return;
        closed = true;
        if (layout != null) {
            textarea.append(layout.getFooter());
        }
    }

    public static JTextAreaAppender getAppender() {
        if (appender == null) {
            // appender = new JTextAreaAppender(new
            // PatternLayout("%-5p %6.10r[%t]%x(%F:%L) - %m%n"));
            appender = new JTextAreaAppender();
        }
        return appender;
    }

    public static JTextArea getTextArea() {
        if (textarea == null) {
            textarea = new JTextArea(5, 30);
            textarea.setEditable(false);
        }
        return textarea;
    }

}
