/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : InputInterfacePrimitiveEntry.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.inputinterface;

import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;

import org.apache.log4j.Logger;

public class InputInterfacePrimitiveEntry extends InputInterfaceEntry implements
        Serializable {
    private Logger logger = Logger.getLogger(InputInterfacePrimitiveEntry.class
            .getName());
    private String value = "";
    private String unit = "";

    private Vector listeners = new Vector();
    private boolean isDoubleQuoted = false;

    public InputInterfacePrimitiveEntry() {
    }

    public InputInterfacePrimitiveEntry(String name, String value, String unit) {
        super(name);
        this.value = value;
        this.unit = unit;
    }

    /**
     * value_uNH[głׂȏꍇ͐^Zbg(Ƃ'chargetitle')
     * 
     * @param isDoubleQuoted
     *            o, value_uNH[gŊ肽ꍇtrue
     */
    public void setDoubleQuoted(boolean isDoubleQuoted) {
        this.isDoubleQuoted = isDoubleQuoted;
    }

    /**
     * l_uNH[gŊׂۂԂ
     * 
     * @return l_uNH[głׂȂtrue(ftHgfalse)
     */
    public boolean isDoubleQuoted() {
        return this.isDoubleQuoted;
    }

    public String getValue() {
        if (this.value == null) {
            return "";
        }
        return this.value.trim();
    }

    /**
     * f~^[̃ftHg':'.
     * 
     * @return ~l
     */
    public String getValueDelimitedBy() {
        return getValueDelimitedBy(":");
    }

    /**
     * Ƃf~^[ŋ؂ꂽvaluȇvfԂ.
     * 
     * @param f~^[
     * @return ~l
     */
    public String getValueDelimitedBy(String delimiter) {
        String[] array = value.split(delimiter);
        if (array == null || array.length == 0 || array[0] == null) {
            return value.trim();
        }
        return array[0].trim();
    }

    public String getUnit() {
        return this.unit.trim();
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean isValueSet() {
        return value.trim().length() != 0;
    }

    public int getEntryType() {
        return super.PRIMITIVE;
    }

    public String toString() {
        return "name: " + name + " value: " + value + " unit: " + unit
                + " isDQ? " + String.valueOf(isDoubleQuoted);
    }

    public InputInterfaceEntry getCopy() {
        return new InputInterfacePrimitiveEntry(new String(name), new String(
                value), new String(unit));
    }

    public boolean equals(InputInterfaceEntry entry) {
        if (!(entry instanceof InputInterfacePrimitiveEntry)) {
            return false;
        }
        InputInterfacePrimitiveEntry pentry = (InputInterfacePrimitiveEntry) entry;
        return pentry.getName().equals(name) && pentry.getValue().equals(value)
                && pentry.getUnit().equals(unit);
    }

    public void saveState() {
        logger.debug("saving state: name, value, and unit" + name + " " + value
                + " " + unit);
        InputInterfacePrimitiveEntry buff = new InputInterfacePrimitiveEntry(
                new String(name), new String(value), new String(unit));
        undoStack.push(buff);
    }

    public void undo() {
        InputInterfacePrimitiveEntry old = doIt(undoStack);
        if (old != null) {
            redoStack.push(old);
        }
    }

    public void redo() {
        InputInterfacePrimitiveEntry old = doIt(redoStack);
        if (old != null) {
            undoStack.push(old);
        }
    }

    private InputInterfacePrimitiveEntry doIt(Stack stack) {
        if (stack.empty()) {
            logger.info("stack empty.");
            return null;
        }

        InputInterfacePrimitiveEntry old = (InputInterfacePrimitiveEntry) stack
                .pop();

        if (old == null) {
            return null;
        }

        this.name = old.getName();
        this.value = old.getValue();
        this.unit = old.getUnit();

        return old;
    }

}
