/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : InputInterfaceDefaults.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.inputinterface;

import java.util.HashMap;

public class InputInterfaceDefaults extends InputInterfaceEntry {

    private String value = new String();
    private String[] defaults;

    public InputInterfaceDefaults() {
    }

    public InputInterfaceDefaults(String name, String value) {
        super(name);
        this.value = value;
    }

    public InputInterfaceDefaults(String name, String[] defaults) {
        super(name);
        this.defaults = defaults;
    }

    public void setDefaults(String[] defaults) {
        this.defaults = defaults;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String[] getDefaults() {
        return this.defaults;
    }

    /**
     * ftHgHashMapɊi[ĕԂ.
     * 
     * @return ftHgi[HashMap
     */
    public HashMap getDefaultValues() {
        if (defaults == null)
            return null;
        HashMap map = new HashMap();
        for (int i = 0; i < defaults.length; i++) {
            String[] de = defaults[i].split("=");
            map.put(de[0].trim(), de[1].trim());
        }
        return map;
    }

    public int getEntryType() {
        return super.DEFAULTS;
    }

    public InputInterfaceEntry getCopy() {
        return this;
    }

    public boolean equals(InputInterfaceEntry entry) {
        if (!(entry instanceof InputInterfaceDefaults)) {
            return false;
        }

        return true;
    }

    public void saveState() {
    }

    public void undo() {

    }

    public void redo() {

    }

}
