/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : MyThread.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.io.BufferedReader;
import java.io.File;

import org.apache.log4j.Logger;

/**
 * OvO, ʃXbhœ鎞ɗpĂȂNX. 債Ƃ͂Ȃ.
 * CX^XuԃRXgN^[ɓnsvO ̂, new MyThread(...)Ƃ邾ł悢.
 */
public class MyThread extends Thread {
    private static Logger logger = Logger.getLogger(MyThread.class.getName());
    private String exeString;
    private String print = "";
    private File dir;
    private String[] envp = null;

    /**
     * @param exeString
     *            svO.
     */
    public MyThread(String exeString) {
        this.exeString = exeString;
        start();
    }

    /**
     * @param exeString
     *            svO.
     * @param print
     *            Iloggerɏo͂镶
     */
    public MyThread(String exeString, String print) {
        this.exeString = exeString;
        this.print = print;
        start();
    }

    /**
     * @param exeString
     *            svO
     * @param print
     *            Iloggerɏo͂镶
     * @param dir
     *            ƃfBNg[
     */
    public MyThread(String exeString, String print, File dir) {
        this.exeString = exeString;
        this.print = print;
        this.dir = dir;
        start();
    }

    public MyThread(String exeString, String print, File dir, String[] envp) {
        this.exeString = exeString;
        this.print = print;
        this.dir = dir;
        this.envp = envp;
        start();
    }

    private MyThreadListener listener;

    /**
     * @param exeString
     *            svO
     * @param print
     *            Iloggerɏo͂镶
     * @param listener
     *            I, ̂ƂĂ炢Xi[
     * @param dir
     *            ƃfBNg[
     */
    public MyThread(String exeString, MyThreadListener listener, File dir) {
        this.exeString = exeString;
        this.listener = listener;
        this.dir = dir;
        start();
    }

    /**
     * @param exeString
     *            svO
     * @param print
     *            Iloggerɏo͂镶
     * @param listener
     *            I, ̂ƂĂ炢Xi[
     * @param dir
     *            ƃfBNg[
     */
    public MyThread(String exeString, MyThreadListener listener, File dir,
            String[] envp) {
        this.exeString = exeString;
        this.listener = listener;
        this.dir = dir;
        this.envp = envp;
        start();
    }

    public void run() {
        try {
            BufferedReader[] reader = null;
            if (dir == null) {
                reader = ExternalProgramExecuter.executeGetBR(exeString);
            } else if (envp == null) {
                reader = ExternalProgramExecuter.executeGetBR(exeString, dir);
            } else {
                reader = ExternalProgramExecuter.executeGetBR(exeString, dir,
                        envp);
            }
            String line = "";
            if (reader[0] != null) {
                while ((line = reader[0].readLine()) != null) {
                    logger.info(line);
                }
            }
            if (reader[1] != null) {
                while ((line = reader[1].readLine()) != null) {
                    logger.error(line);
                    logger.error(exeString);
                }
            }
            if (print != null && print.trim().length() != 0)
                logger.info(print);
            if (listener != null)
                listener.done();

            reader[0].close();
            reader[1].close();
        } catch (Exception exception) {
            exception.printStackTrace();
            // logger.error("failed execution of: "+exeString);
        }
    }

}
