/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : CoordsViewerBooter.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.settings.PropertiesManager;

public class CoordsViewerBooter {
    public static int BIOSTATION_VIEWER = 1;
    public static int INTERNAL_VIEWER = 0;
    private static Logger logger = Logger.getLogger(CoordsViewerBooter.class
            .getName());
    private Vector frames;

    private AtomCoords coords;

    private int choice = INTERNAL_VIEWER;
    private String parentDir;

    private ACVData acvdata;

    public CoordsViewerBooter() {

    }

    public CoordsViewerBooter(ACVData acvdata) {
        this.frames = acvdata.getFrames();
        this.parentDir = acvdata.getParentDir();
        this.acvdata = acvdata;
        this.choice = choice;
    }

    public CoordsViewerBooter(ACVData acvdata, int choice) {
        this.frames = acvdata.getFrames();
        this.parentDir = acvdata.getParentDir();
        this.acvdata = acvdata;
        this.choice = choice;
    }

    public CoordsViewerBooter(Vector frames, String parentDir, int choice) {
        this.frames = frames;
        this.parentDir = parentDir;
        this.choice = choice;
    }

    public void boot() {
        if (choice == 0) {
            bootACViewer();
        } else if (choice == 1) {
            bootBSViewer();
        }

    }

    private void bootACViewer() {
        CoordsViewerInterface mPanel = new MainPanel(acvdata);
        try {
            mPanel.display3D();
        } catch (Exception exception) {
            logger.warn("failed to show atomic configuration");
            exception.printStackTrace();
        }
    }

    private void bootBSViewer() {
        double[][] Dpos;
        Dpos = coords.getPosDouble();
        if (Dpos == null) {
            logger.warn("atom coordinates == null!");
            return;
        }
        String dir = new String();
        if (parentDir != null) {
            dir = parentDir;
        } else {
            dir = System.getProperty("user.dir");
        }
        String xyzFile = dir + System.getProperty("file.separator")
                + "AtomicConfig.xyz";
        logger.debug("xyzFile: " + xyzFile);

        PrintWriter writer = null;
        try {
            writer = new PrintWriter(
                    new BufferedWriter(new FileWriter(xyzFile)));
            int NumAt = coords.getNumAt();
            AtomList list = coords.getAtomList();
            writer.println(NumAt);
            writer.println("xyz-file");

            logger.debug("atom coords ...");
            for (int i = 0; i < NumAt; i++) {
                String element = list.getAtomAt(i).getElementName();
                writer.println(element + " " + Dpos[i][0] + " " + Dpos[i][1]
                        + " " + Dpos[i][2]);
                logger.debug(element + " " + Dpos[i][0] + " " + Dpos[i][1]
                        + " " + Dpos[i][2]);
            }
        } catch (IOException ie) {
            logger.error("failed to create temporary xyz-file");
            return;
        } finally {
            writer.close();
        }

        String bsviewer = System.getProperty("pviewer.home")
                + System.getProperty("file.separator")
                + PropertiesManager.getGlobalProperties(
                        PropertiesManager.PROPERTIES_PVIEWER).getProperty(
                        "BioStationViewer");
        logger.debug("bsvpath: " + bsviewer);
        if (bsviewer == null) {
            logger.warn("couldn't find BioStationViewer");
            return;
        } else if (!((new File(bsviewer)).exists())) {
            logger.warn("could not find BioStationViewer");
            return;
        }

        String bsvexe = Utils.getPathDQ(ConstParameters.getJavaPath())
                + " -jar " + Utils.getPathDQ(bsviewer) + " -f "
                + Utils.getPathDQ(xyzFile);
        MyThread mt = new MyThread(bsvexe);
    }

}
