package ciss.phase_viewer.atomcoord.pmodel;

class Generator {
    private String HM;
    private String[][] generator; // [choice][oparator]

    /*
     * Generator (char notUsed, String str, String[][] al) { HM = str; generator
     * = al; }
     */

    Generator(String str, String[][] al) {
        HM = str;
        generator = al;
    }

    int getNumOfChoice() {
        return generator.length;
    }

    private int getNumOfGenerator() {
        return generator[0].length;
    }

    String getHM() {
        return HM;
    }

    String[] getGenerator(int choice) {
        return generator[choice];
    }

    public String toString() {
        String str;

        str = "new Generator(" + '"' + HM + '"' + ", new String[][]";

        int numChoice = this.getNumOfChoice();
        int numGene = this.getNumOfGenerator();

        str = str + "{";
        for (int i = 0; i < numChoice; ++i) {
            if (i != 0)
                str = str + ",\n\t\t";
            str = str + "{";
            for (int j = 0; j < numGene; ++j) {
                if (j != 0)
                    str = str + ",";
                str = str + '"' + generator[i][j] + '"';
            }
            str = str + "}";
        }
        str = str + "})";

        return str;
    }
}
