/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2007/01/04 11:42:52
!  AUTHOR(S): KOGA, Junichiro
!  File : ImportFileChooser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.atomcoord.io;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

import javax.swing.JFileChooser;

import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.main.PluginLoader;

public class ImportFileChooser extends ChaseFileChooser implements
        PropertyChangeListener {
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(ImportFileChooser.class.getName());
    private Importable caller;
    private Importer[] importers;
    private Component parent;

    public ImportFileChooser(Importable caller, Component parent) {
        super(ChaseFileChooser.atom, true);
        this.caller = caller;
        this.parent = parent;
        setDialogTitle("select atomic configuration file");
        setFileSelectionMode(JFileChooser.FILES_ONLY);
        setAcceptAllFileFilterUsed(false);
        init();
    }

    private String atomCoordsFile;

    private void init() {
        createImporters();
        for (int i = 0; i < importers.length; i++) {
            javax.swing.filechooser.FileFilter filter = importers[i]
                    .getFileFilter();
            addChoosableFileFilter(filter);
        }
        setFileFilter(getChoosableFileFilters()[0]);

        if (showOpenDialog(parent) != APPROVE_OPTION)
            return;

        atomCoordsFile = getSelectedFile().getAbsolutePath();
        if (atomCoordsFile == null || atomCoordsFile.length() == 0
                || !new java.io.File(atomCoordsFile).exists()) {
            logger.error("the file you've specified does not exist.");
            return;
        }

        int index = getSelectedFileFilterIndex();
        if (!importers[index].hasOptions()) {
            caller.coordsImported(
                    importers[index].getAtomCoordsFrom(atomCoordsFile),
                    importers[index].getType(), atomCoordsFile);
        } else {
            importers[index].createOptionsPanel(false, this, atomCoordsFile);
        }
    }

    private void createImporters() {
        Document doc = ciss.phase_viewer.jdom.XMLUtils
                .getDocumentFromURL(AtomCoordsIO.SUPPORTED_FILETYPE);
        Element root = doc.getRootElement();
        java.util.List list = root.getChildren("importer");
        Vector vec = new Vector();
        for (int i = 0; i < list.size(); i++) {
            String loadClass = ((Element) list.get(i))
                    .getChildTextTrim("loadclass");
            vec.addElement(loadClass);
        }
        importers = new Importer[vec.size()];
        for (int i = 0; i < vec.size(); i++) {
            String load = (String) vec.get(i);
            importers[i] = (Importer) PluginLoader.instantiate(load, null);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        int index = getSelectedFileFilterIndex();
        caller.coordsImported(
                importers[index].getAtomCoordsFrom(atomCoordsFile),
                importers[index].getType(), atomCoordsFile);
    }

}
