/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : SceneGraphElementCreator.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import javax.media.j3d.BranchGroup;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObjectBG;
import ciss.phase_viewer.acviewer.scenegraphelements.bond.BondObject;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

public class SceneGraphElementCreator {

    private static Logger logger = Logger
            .getLogger(SceneGraphElementCreator.class.getName());

    private ConfigDataManager mCD;

    private J3DDataManager mACVD;

    private TGAtom tgatom;

    private GlobalProperties props = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);

    public SceneGraphElementCreator(J3DDataManager mACVD, ConfigDataManager mCD) {
        this.mACVD = mACVD;
        this.mCD = mCD;
    }

    public void setTGAtom(TGAtom tgatom) {
        this.tgatom = tgatom;
    }

    public BranchGroup getSceneGraphElement(String ID, int atomicNumber,
            double[] pos, double[] force, int mobile, int weight) {
        AtomObject element = new AtomObject(ID, atomicNumber, pos, force,
                mobile, weight);
        element.register(mCD, mACVD, tgatom);
        element.setAttributes();
        element.create();
        AtomObjectBG bg = new AtomObjectBG(element);
        return bg;
    }

    // public SceneGraphElement getSceneGraphElement(double[] nearestNeighbor) {
    public SceneGraphElementBG getSceneGraphElement(double[] nearestNeighbor) {
        BondObject bond = new BondObject(nearestNeighbor);
        bond.register(mCD, mACVD, tgatom);
        bond.setBondColor(mACVD.getBondColor());
        bond.setNumNodes(mACVD.getNumNodesBond());

        // float scaleatom = 2.2f * mACVD.getScaleAtom() / (float)
        // (Math.pow((float) (mCD.getNumAt()), 1.0f / 3.0f));
        float scaleatom = mCD.getScaleAtom();
        double bondWidth = scaleatom * mACVD.getBondWidth();
        bond.setBondWidth(bondWidth);

        bond.create();

        return (SceneGraphElementBG) bond;
    }

    public SceneGraphElementBG getSceneGraphElement(double[] nearestNeighbor,
            int mode) {
        BondObject bond = new BondObject(nearestNeighbor);
        bond.register(mCD, mACVD, tgatom);
        bond.setBondColor(mACVD.getBondColor());
        // float scaleatom = 2.2f * mACVD.getScaleAtom() / (float)
        // (Math.pow((float)
        // (mCD.getNumAt()), 1.0f / 3.0f));
        float scaleatom = mCD.getScaleAtom();
        double bondWidth = scaleatom * mACVD.getBondWidth();
        bond.setBondWidth(bondWidth);
        bond.setNumNodes(mACVD.getNumNodesBond());
        bond.setMode(mode);
        bond.create();

        return (SceneGraphElementBG) bond;
    }

    /*
     * public SceneGraphElementBG getSceneGraphElement(double[]
     * cellOrigin,double[][] cellVec) { CellObject cell = new
     * CellObject(cellOrigin,cellVec);
     * 
     * cell.setCellColor(mACVD.getCellColor());
     * cell.setNumNodes(mACVD.getNumNodesCell());
     * cell.setCellWidth(mACVD.getCellWidth()); mCD.register(cell);
     * cell.register(mCD,mACVD,tgatom); cell.create();
     * 
     * return (SceneGraphElementBG) cell; }
     */

    public SceneGraphElementBG getSceneGraphElement(double[] atom1,
            double[] atom2, double result, String[] id) {
        MeasureObject measure = new MeasureObject(atom1, atom2, result);
        measure.register(mCD, mACVD, tgatom);
        measure.setIDString(id);
        measure.create();
        return (SceneGraphElementBG) measure;
    }

    public SceneGraphElementBG getSceneGraphElement(double[] atom1,
            double[] atom2, double[] atom3, double result, String[] id) {
        MeasureObject measure = new MeasureObject(atom1, atom2, atom3, result);
        measure.register(mCD, mACVD, tgatom);
        measure.setIDString(id);
        measure.create();
        return (SceneGraphElementBG) measure;
    }

    public SceneGraphElementBG getSceneGraphElement(double[] atom1,
            double[] atom2, double[] atom3, double[] atom4, double result,
            String[] id) {
        MeasureObject measure = new MeasureObject(atom1, atom2, atom3, atom4,
                result);
        measure.register(mCD, mACVD, tgatom);
        measure.setIDString(id);
        measure.create();
        return (SceneGraphElementBG) measure;
    }

    private CellObject cellObject;

    public SceneGraphElementBG getSceneGraphElementBG(int sceneType) {
        if (sceneType == SceneGraphElement.CELL) {
            if (cellObject == null) {
                cellObject = new CellObject();
                cellObject.register(mCD, mACVD, tgatom);
                mCD.register(cellObject);
            }
        }

        if (cellObject != null) {
            cellObject.create();
        }

        return cellObject;
    }

    public SceneGraphElement getSceneGraphElement(int sceneType) {
        SceneGraphElement ret = null;
        if (sceneType == SceneGraphElement.AXIS) {
            ret = new AxisObject();
        } else if (sceneType == SceneGraphElement.LEGEND) {
            LegendObject lo = new LegendObject();
            lo.setNumAt(mCD.getNumAt());
            lo.setElements(mCD.getElements());
            lo.setNumEl(mACVD.getNumEl());
            lo.setElementAll(mACVD.getElement());
            lo.setColor(mACVD.getColor());
            lo.setNumNodes(mACVD.getNumNodesAtom());
            lo.register(mCD, mACVD, tgatom);
            if (mCD != null)
                mCD.register(lo);
            ret = (SceneGraphElement) lo;
        } else if (sceneType == SceneGraphElement.BG) {
            BGObject bo = new BGObject();
            bo.register(mCD, mACVD, tgatom);
            bo.setBgColor(mACVD.getBgColor());
            if (mCD != null)
                mCD.register(bo);
            ret = (SceneGraphElement) bo;
        } else if (sceneType == SceneGraphElement.LIGHT) {
            ret = new LightObject();
        }

        if (ret != null) {
            ret.create();
        }

        return ret;
    }

    public ConfigDataManager getConfigData() {
        return this.mCD;
    }

    public J3DDataManager getACVData() {
        return this.mACVD;
    }

}
