/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/09/27, 15:31
!  AUTHOR(S): KOGA, Junichiro
!  File : BasicOperations.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.operations;

import java.util.Arrays;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomEvent;
import ciss.phase_viewer.atomcoord.AtomListener;

/**
 * qzuɊ{IȕҏWs߂̊e탁\bhz
 * 
 * @author
 */
public class BasicOperations implements AtomListener {
    private Logger logger = Logger.getLogger(BasicOperations.class.getName());
    private TGAtom tgatom;
    private MainPanel parent;

    public BasicOperations(MainPanel parent) {
        this.parent = parent;
        this.tgatom = (TGAtom) parent.getRootTransform();
    }

    /**
     * w̌q폜
     */
    public void removeAtoms(AtomObject[] atoms) {
        if (atoms == null || atoms.length == 0) {
            return;
        }
        AtomCoords coords = tgatom.getConfigData().getAtomCoords();
        coords.saveState();
        Vector indexVector = new Vector();
        for (int i = 0; i < atoms.length; i++) {
            int id = Integer.parseInt(atoms[i].getID()) - 1;
            indexVector.addElement(new Integer(id));
        }
        if (indexVector.size() == 0) {
            return;
        }
        Integer[] indeces = new Integer[indexVector.size()];
        indexVector.copyInto(indeces);
        Arrays.sort(indeces);
        for (int i = indeces.length - 1; i >= 0; i--) {
            coords.getAtomList().removeAtomAt(indeces[i].intValue());
        }

        coords.getAtomList().setUndoCount(atoms.length);

        if (!wait) {
            redraw();
        }
    }

    /**
     * V["I"̌qׂč폜
     */
    public void removeSelectedAtoms() {
        AtomObject[] atoms = tgatom.getSelectedAtoms();
        removeAtoms(atoms);
    }

    private void redraw() {
        AtomCoords coords = tgatom.getConfigData().getAtomCoords();
        tgatom.getConfigData().isRenderingManual(true);
        parent.prepareRedraw();
        parent.getCD().setCoords(coords);
        parent.postRedraw();
        parent.getCD().isRenderingManual(false);
        coords.finalizeState();
        wait = false;
    }

    /**
     * I𒆂̌q̑lύX郁\bh. ŗ^鑮l, I𒆂̑SqɓKp.
     * 
     * @param elementName
     *            f
     * @param auxvec
     *            auxiliaryȏi[Vector
     */
    public void modifyAttributesOfSelectedAtoms(String elementName,
            Vector auxvec) {
        AtomObject[] selectedAtoms = tgatom.getSelectedAtoms();
        AtomCoords coords = tgatom.getConfigData().getAtomCoords();
        if (selectedAtoms == null || selectedAtoms.length == 0)
            return;
        for (int j = 0; j < selectedAtoms.length; j++) {
            int id = Integer.parseInt(selectedAtoms[j].getID()) - 1;
            ciss.phase_viewer.atomcoord.Atom at = coords.getAtomList()
                    .getAtomAt(id);
            if (elementName.trim().length() != 0) {
                at.setElementName(elementName);
            }
            if (auxvec.size() != 0) {
                at.setAuxil(auxvec);
            }
        }
        if (!wait)
            redraw();
    }

    /**
     * I𒆂̌q̍Wi
     * 
     * @param x
     *            x̕i
     * @param y
     *            y̕i
     * @param z
     *            z̕i
     */
    public void translateSelectedAtoms(double x, double y, double z) {
        AtomObject[] selectedAtoms = tgatom.getSelectedAtoms();
        AtomCoords coords = tgatom.getConfigData().getAtomCoords();
        for (int i = 0; i < selectedAtoms.length; i++) {
            int id = Integer.parseInt(selectedAtoms[i].getID()) - 1;
            double[] pos = parent.getCD().getPos(id);
            pos[0] += x;
            pos[1] += y;
            pos[2] += z;
            ciss.phase_viewer.atomcoord.Atom atnow = coords.getAtomList()
                    .getAtomAt(id);
            ciss.phase_viewer.atomcoord.Atom newatom = atnow.getCopy();
            newatom.setPos(pos);
            coords.getAtomList().replaceAtomAt(id, newatom);
        }
        coords.getAtomList().setUndoCount(selectedAtoms.length);
        if (!wait)
            redraw();
    }

    private boolean wait = false;

    /**
     * trueɃZbgĂ, IɃV[ĕ`悷悤wȂV[̍ĕ`͍sȂ.
     * 
     * @param wait
     *            V[̍ĕ`Rg[ꍇtrueƂ
     */
    public void wait(boolean wait) {
        this.wait = wait;
    }

    /**
     * Iɍĕ`悷郁\bh
     */
    public void doUpdate() {
        redraw();
    }

    public void atomStateChanged(AtomEvent e) {
        ciss.phase_viewer.atomcoord.Atom atom = e.getAtom();
        int ind = e.getIndex();
        ciss.phase_viewer.atomcoord.AtomCoords coords = parent.getCD()
                .getAtomCoords();
        logger.debug("atom now: " + coords.getAtomList().getAtomAt(ind));
        Atom at = coords.getAtomList().getAtomAt(ind);
        Atom newat = at.getCopy();
        newat.setElementName(atom.getElementName());
        newat.setPos(atom.getPos());
        newat.setAuxil(atom.getAuxil());
        coords.replaceAtomAt(ind, newat);
        logger.debug("AtomStateChanged: " + e);
        if (!wait)
            redraw();
    }

}
