/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/12/27, 17:58
!  AUTHOR(S): KOGA, Junichiro
!  File : ScriptWrapper.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.scripting;

import java.io.File;

import org.apache.log4j.Logger;

import ciss.phase_viewer.ssh.hosts.HostInfo;

/**
 * XNvg̊eJvZ.
 * 
 * @author jkoga
 */
public class ScriptWrapper {
    public static Logger logger = Logger.getLogger(ScriptWrapper.class
            .getName());
    public static String BAT = "bat";
    public static String SH = "sh";
    public static String BSH = "bsh";

    public static String[] REGISTERED_SCRIPT_TYPE = { BAT, SH, BSH };

    private String file;
    private String scriptType = SH;

    /**
     * XNvgt@Cւ̃pXŏ.
     * 
     * @param file
     *            YXNvgt@Cւ̃pX
     */
    public ScriptWrapper(String file) {
        this.file = file;
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            scriptType = BAT;
        }
    }

    /**
     * XNvgt@Cւ̃pX̑, ǂȃXNvgw肷(default'sh'; windowŝbat).
     * 
     * @param file
     *            YXNvgt@Cւ̃pX
     * @param type
     *            XNvg̎
     */
    public ScriptWrapper(String file, String type) {
        this.file = file;
        if (type != null
                && (type.equals(SH) || type.equals(BSH) || type.equals(BAT))) {
            this.scriptType = type;
        } else if (System.getProperty("os.name").toLowerCase()
                .startsWith("windows")) {
            this.scriptType = BAT;
        } else {
            this.scriptType = SH;
        }
    }

    /**
     * tpXł͂Ȃ, t@ĈݕԂ
     * 
     * @return XNvgt@C̃t@C.
     */
    public String toString() {
        return new File(file).getName();
    }

    /**
     * YXNvgւ̃tpXԂ.
     * 
     * @return YXNvgւ̃tpX.
     */
    public String getPath() {
        return this.file;
    }

    /**
     * ǂȃXNvgԂ
     * 
     * @return XNvg(ftHg'sh')
     */
    public String getScriptType() {
        return this.scriptType;
    }

    /**
     * t@CXNvg擾
     * 
     * @param file
     *            t@C
     * @return XNvg
     */
    public static String getTypeFromFile(String file) {
        if (file == null) {
            return null;
        }
        String[] split = file.trim().split("\\.");
        String type = ScriptWrapper.SH;
        if (split != null && split.length >= 2) {
            if (split[split.length - 1].equalsIgnoreCase("bsh")) {
                type = ScriptWrapper.BSH;
            } else if (split[split.length - 1].equalsIgnoreCase("bat")) {
                type = ScriptWrapper.BAT;
            }
        }
        return type;
    }

    public static String[] getValidScriptType(HostInfo hostInfo) {
        // windows[JzXg̏ꍇ, "bat""bsh"̂ݗL
        if (hostInfo.isLocalHost()
                && System.getProperty("os.name").toLowerCase()
                        .startsWith("windows")) {
            return new String[] { BAT, BSH };
        }
        return new String[] { SH, BSH };
    }

}
