/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/25, 14:28
!  AUTHOR(S): KOGA, Junichiro
!  File : PDFExporter.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.common;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import org.apache.log4j.Logger;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;

/**
 * uPDFϊvpX^eBbN\bhĂNX.
 * 
 * @author
 */
public class PDFExporter {
    private static Logger logger = Logger
            .getLogger(PDFExporter.class.getName());

    /** Creates a new instance of PDFExporter */
    private PDFExporter() {
    }

    public static final void g2DtoPDF(Drawable draw, File file, int width,
            int height, FontMapper mapper) throws IOException {
        OutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        g2DtoPDF(draw, out, width, height, mapper);
    }

    public static final void g2DtoPDF(Drawable draw, File file, int width,
            int height) throws IOException {
        g2DtoPDF(draw, file, width, height, new DefaultFontMapper());
    }

    public static final void g2DtoPDF(Drawable draw, OutputStream out,
            int width, int height) throws IOException {
        g2DtoPDF(draw, out, width, height, new DefaultFontMapper());
    }

    public static final void g2DtoPDF(Drawable draw, OutputStream out,
            int width, int height, FontMapper mapper) throws IOException {
        com.lowagie.text.Rectangle pagesize = new com.lowagie.text.Rectangle(
                width, height);
        Document document = new Document(pagesize, 50, 50, 50, 50);
        try {
            PdfWriter writer = PdfWriter.getInstance(document, out);
            document.addAuthor("phase-viewer");
            document.addSubject("chart");
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate(width, height);
            Graphics2D g2 = tp.createGraphics(width, height, mapper);
            Rectangle2D r2D = new Rectangle2D.Double(0, 0, width, height);
            draw.draw(g2, r2D);
            g2.dispose();
            cb.addTemplate(tp, 0, 0);
        } catch (DocumentException de) {
            logger.error(de.getMessage());
        }
        document.close();
        out.close();
    }

}
