/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : OutputParserInterface.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.util.Vector;

import ciss.phase_viewer.graph.MainPanel;

public abstract class OutputParserInterface {

    /** vector for data set */
    private Vector vdata = new Vector();

    /** vector for "num of rows" set */
    private Vector vnumRows = new Vector();

    /** vector for "num of columns" set */
    private Vector vnumCols = new Vector();

    /** vector for "num of identifiers" set */
    private Vector vnumIdent = new Vector();

    /** vector for "column name" set */
    private Vector vcolName = new Vector();

    /** vector for "header" set */
    private Vector vheader = new Vector();

    /** vector for filenames set */
    private Vector vfilename = new Vector();

    /** vector for directory set */
    private Vector vdirectory = new Vector();

    /**
     * main panel for the graph module
     */
    private MainPanel graph = new MainPanel();

    /** constructor */
    public OutputParserInterface() {
    }

    public void setvData(Vector vdata) {
        this.vdata = vdata;
    }

    public void addvData(Vector vec) {
        this.vdata.addElement(vec);
    }

    public Vector getvData() {
        return this.vdata;
    }

    public void setvNumRows(Vector vnumRows) {
        this.vnumRows = vnumRows;
    }

    public void addvNumRows(Integer numrows) {
        this.vnumRows.addElement(numrows);
    }

    public Vector getvNumRows() {
        return this.vnumRows;
    }

    public void setvNumCols(Vector vnumCols) {
        this.vnumCols = vnumCols;
    }

    public void addvNumCols(Integer numcols) {
        this.vnumCols.addElement(numcols);
    }

    public Vector getvNumCols() {
        return this.vnumCols;
    }

    public void setvNumIdent(Vector vnumIdent) {
        this.vnumIdent = vnumIdent;
    }

    public void addvNumIdent(Integer numIdent) {
        this.vnumIdent.addElement(numIdent);
    }

    public Vector getvNumIdent() {
        return this.vnumIdent;
    }

    public void setvColName(Vector vcolName) {
        this.vcolName = vcolName;
    }

    public void addvColName(Vector vec) {
        this.vcolName.addElement(vec);
    }

    public Vector getvColName() {
        return this.vcolName;
    }

    public void setvHeader(Vector vheader) {
        this.vheader = vheader;
    }

    public void addvHeader(String str) {
        this.vheader.addElement(str);
    }

    public Vector getvHeader() {
        return this.vheader;
    }

    public void setvDirectory(Vector vdirectory) {
        this.vdirectory = vdirectory;
    }

    public void addvDirectory(String str) {
        this.vdirectory.addElement(str);
    }

    public Vector getvDirectory() {
        return this.vdirectory;
    }

    public void setvFileName(Vector vfilename) {
        this.vfilename = vfilename;
    }

    public void addvFileName(String str) {
        this.vfilename.addElement(str);
    }

    public Vector getvFileName() {
        return this.vfilename;
    }

    /**
     * Otc[Ƀf[^z, N̏s.
     */
    public void createMainPanel() {
        boolean b = setDataToGraph();
        if (b) {
            graph.setMode(MainPanel.FILE_AUTOMATIC);
            graph.loadData_AUTO();
        } else {
            System.out.println("one or more of the data were not properly set");
        }
    }

    /**
     * Otc[̃CX^XԂ.
     * 
     * @return Otc[̃CX^X.
     */
    public MainPanel getGraph() {
        return this.graph;
    }

    /** set data to graph module */
    private boolean setDataToGraph() {
        if (vdata.size() == 0 || vnumRows.size() == 0 || vnumCols.size() == 0
                || vnumIdent.size() == 0 || vheader.size() == 0
                || vfilename.size() == 0 || vfilename.size() == 0
                || vdirectory.size() == 0) {
            return false;
        }

        graph.setvFileName(vfilename);
        graph.setvDirectory(vdirectory);
        graph.setvData(vdata);
        graph.setvNumRows(vnumRows);
        graph.setvNumCols(vnumCols);
        graph.setvNumIdent(vnumIdent);
        graph.setvColName(vcolName);
        graph.setvHeader(vheader);

        return true;
    }

    /**
     * o̓t@Cp[X郁\bh. , o̓t@CɉăI[o[Ch.
     */
    public abstract void parseOutput();
}
