/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/10/19, 17:51
!  AUTHOR(S): KOGA, Junichiro
!  File : MouseMotionListenerAction.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.mouselistener;

import java.awt.event.MouseEvent;

import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.MainPanel;

/**
 * uMouseMotionListenersvsNX̃x[XNX.
 * 
 * @author
 */
public abstract class MouseMotionListenerAction {
    private static Logger logger = Logger
            .getLogger(MouseMotionListenerAction.class.getName());
    protected MainPanel parent;

    /**
     * Creates a new instance of MouseMotionListenerAction
     * 
     * @param qzur[A[̐epl
     *            .
     */
    public MouseMotionListenerAction(MainPanel parent) {
        this.parent = parent;
    }

    abstract void init(MouseEvent e);

    abstract void finalize(MouseEvent e);

    abstract void processMouseDrag(MouseEvent e);

    abstract void processMouseMove(MouseEvent e);

    public static double getScreenScale(MainPanel parent) {
        Transform3D viewplat = new Transform3D();
        parent.getUniverse().getViewingPlatform().getViewPlatformTransform()
                .getTransform(viewplat);
        Vector3d vvd = new Vector3d();
        viewplat.get(vvd);
        double dviewplat = vvd.z;
        Transform3D tgatom3d = new Transform3D();
        parent.getScene().getTGAtom().getTransform(tgatom3d);
        Vector3d transatom = new Vector3d();
        tgatom3d.get(transatom);

        return (dviewplat - transatom.z) / dviewplat;
    }

    public static Point3d getCoordsFromMousePosPlat(MainPanel parent,
            MouseEvent e) {
        // double screenScale = (dviewplat-transatom.z)/dviewplat;
        double screenScale = 1.0d;
        if (screenScale < parent.getCanvas().getView().getFrontClipDistance()) {
            screenScale = parent.getCanvas().getView().getFrontClipDistance();
        } else if (screenScale > parent.getCanvas().getView()
                .getBackClipDistance()) {
            screenScale = parent.getCanvas().getView().getBackClipDistance();
        }

        double dx;
        double dy;
        int canvSizex = parent.getCanvas().getSize().width;
        int canvSizey = parent.getCanvas().getSize().height;

        double x = (2.d * screenScale * (double) e.getX())
                / ((double) canvSizex) - screenScale;
        double y = (2.d * screenScale * (double) e.getY())
                / ((double) canvSizey) - screenScale;
        logger.debug("canvSizex, canvSizey: " + canvSizex + ", " + canvSizey);
        logger.debug("mousePosx, mousePosy: " + e.getX() + ", " + e.getY());
        logger.debug("x, y: " + x + ", " + y);
        return new Point3d(x, y, 0.d);
    }

    public static Point3d getCoordsFromMousePos(MainPanel parent, MouseEvent e) {
        Transform3D viewplat = new Transform3D();
        parent.getUniverse().getViewingPlatform().getViewPlatformTransform()
                .getTransform(viewplat);
        Vector3d vvd = new Vector3d();
        viewplat.get(vvd);
        double dviewplat = vvd.z;
        Transform3D tgatom3d = new Transform3D();
        parent.getScene().getTGAtom().getTransform(tgatom3d);
        Vector3d transatom = new Vector3d();
        tgatom3d.get(transatom);

        double screenScale = (dviewplat - transatom.z) / dviewplat;
        if (screenScale < parent.getCanvas().getView().getFrontClipDistance()) {
            screenScale = parent.getCanvas().getView().getFrontClipDistance();
        } else if (screenScale > parent.getCanvas().getView()
                .getBackClipDistance()) {
            screenScale = parent.getCanvas().getView().getBackClipDistance();
        }

        double dx;
        double dy;
        int canvSizex = parent.getCanvas().getSize().width;
        int canvSizey = parent.getCanvas().getSize().height;
        double x = (2.d * screenScale * (double) e.getX())
                / ((double) canvSizex) - screenScale;
        double y = (2.d * screenScale * (double) e.getY())
                / ((double) canvSizey) - screenScale;

        return new Point3d(x, y, 0.d);
    }

}
