/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/31, 14:53
!  AUTHOR(S): KOGA, Junichiro
!  File : AnimKeyListener.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.keylistener;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * Ctrl+AőSq̑IgO
 */
public class SelectAll implements KeyListener, PropertiesListener {
    private Logger logger = Logger.getLogger(SelectAll.class.getName());

    private J3DPanel parent;

    private TGAtom tgatom;

    /** Creates a new instance of AnimKeyListener */
    public SelectAll(J3DPanel parent) {
        this.parent = parent;
        PropertiesManager.getGlobalProperties(PropertiesManager.PROPERTIES_ACV)
                .addPropertiesListener(this);
        if (parent instanceof CoordsViewerInterface)
            tgatom = (TGAtom) ((CoordsViewerInterface) parent).getScene()
                    .getTGAtom();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (!(this.parent instanceof CoordsViewerInterface))
            return;
        logger.debug("keyCode: " + e.getKeyCode());
        if (e.isControlDown() && e.getKeyCode() == KeyEvent.VK_A) {
            AtomObject[] aobjs = tgatom.getAtomObjects();
            int nselec = 0;
            int nnselec = 0;
            for (AtomObject aobj : aobjs) {
                boolean b = aobj.toggleSelected();
                if (b)
                    nselec += 1;
                else
                    nnselec += 1;
            }
            if (nselec > 0)
                logger.info("selected " + nselec + " atoms");
            if (nnselec > 0)
                logger.info("deselected " + nnselec + " atoms");
        }

    }

    public void propertiesStored(GlobalProperties properties) {
    }

}
