/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/28, 14:47
!  AUTHOR(S): KOGA, Junichiro
!  File : ACViewer.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer;

import java.io.File;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.atomcoord.Nfdynm2AtomCoords;
import ciss.phase_viewer.common.StringConstants;

/**
 * qzur[A[P̋NpNX. 蒴.
 * 
 * @author
 */
public class ACViewer implements ACVCaller {
    private static Logger logger = Logger.getLogger(ACViewer.class.getName());

    /** Creates a new instance of ACViewer */
    public ACViewer() {
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("Usage: java -jar ACViewer.jar F_DYNMfilename");
            System.exit(0);
        }
        String filename = args[0];

        Nfdynm2AtomCoords dynmParser = new Nfdynm2AtomCoords(filename);
        Vector frames = dynmParser.getFrames();
        ACViewer acv = new ACViewer();
        String parentDir = new File(filename).getParent();
        ACVData acvdata = new ACVData(acv, frames, parentDir, null,
                StringConstants.phase_atom_tag);
        CoordsViewerInterface mPanel = new MainPanel(acvdata);
        try {
            mPanel.display3D();
        } catch (Exception exception) {
            logger.warn("failed to show atomic configuration");
            exception.printStackTrace();
        }
    }

    public void save(ciss.phase_viewer.atomcoord.AtomCoords coords) {
    }

}
