/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : CheckPanelPhase.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.primitiveguis;

import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;

public class CheckPanelPhase extends PrimitiveInputComponents implements
        PhaseInputPanelInterface {
    private CheckBoxPhase checkbox;
    public static String NO_SELECTION = ciss.phase_viewer.common.ConstParameters.NO_SELECTION;
    private static Logger logger = Logger.getLogger(CheckPanelPhase.class
            .getName());

    private String[] fullName;
    private String title;
    private Vector dupli = null;
    private boolean defaultValue = false;

    public CheckPanelPhase(String[] inputSpecifications,
            InputInterface inputinterface, String title, EventListener parent) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.createGUI();
        this.addListeners(parent);
    }

    public CheckPanelPhase(String[] inputSpecifications,
            InputInterface inputinterface, String title) {
        super(inputSpecifications, inputinterface);
        this.title = title;

        this.createGUI();
    }

    public CheckPanelPhase(String[] inputSpecifications,
            InputInterface inputinterface, String title, EventListener parent,
            boolean defaultValue) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.defaultValue = defaultValue;
        this.createGUI();
        this.addListeners(parent);
    }

    public CheckPanelPhase(String[] inputSpecifications,
            InputInterface inputinterface, String title, boolean defaultValue) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.defaultValue = defaultValue;
        this.createGUI();
    }

    private void createGUI() {
        super.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        this.createComboBox();
        super.add(checkbox);
        // if ( title != null ) {
        // super.setBorder( new TitledBorder(title) );
        // }
    }

    private void createComboBox() {
        checkbox = new CheckBoxPhase(inputSpecifications, inputInterface, title);
        checkbox.setSelected(this.defaultValue);
        String value = entry.getValue().trim();
        if (value.length() != 0) {
            if (InputInterface.isTrue(value))
                checkbox.setSelected(true);
            else
                checkbox.setSelected(false);
        }
    }

    /**
     * ̃NXێR{{bNX, ANVXi[t郁\bh.
     */
    public void addListeners(EventListener listener) {
        if (listener instanceof ActionListener) {
            checkbox.addActionListener((ActionListener) listener);
        }
    }

    public void registerDisabableGUI(JComponent jcomponent) {
        checkbox.removeListeners();
        checkbox.setDisabableGUI(jcomponent);
        checkbox.disableRegisteredGUI();
        checkbox.restoreListeners();
    }

    public void setEnabled(boolean enabled) {
        checkbox.setEnabled(enabled);
    }

    public String getValue() {
        String ret = "0";
        if (checkbox.isSelected())
            ret = "1";
        return ret;
    }

    public String getUnit() {
        return new String();
    }

    public JCheckBox getComboBox() {
        return this.checkbox;
    }

}
