/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : BondInfo.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer.scenegraphelements.bond;

public class BondInfo implements Comparable {
    private int atom1;
    private int atom2;
    private double[] coords;
    private boolean valid = false;

    public BondInfo() {
    }

    public void nullify() {
        coords = null;
    }

    /** : ̃NX equals ƈѐ̂ȂRt܂ */

    public BondInfo(int atom1, int atom2, double[] coords) {
        this.atom1 = atom1;
        this.atom2 = atom2;
        this.coords = coords;
    }

    public void addBondInfo(int atom1, int atom2, double[] coords) {
        this.atom1 = atom1;
        this.atom2 = atom2;
        this.coords = coords;
    }

    public void isValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return valid;
    }

    public int[] getIndexPair() {
        int[] ret = { atom1, atom2 };
        return ret;
    }

    /**
     * CfbNXtւ; q̐ɑꍇ̂悤ȂƂN.
     * 
     * @param atom1
     *            ̃{hɊ֘Atꂽڂ̌q̃CfbNX
     * @param atom2
     *            ̃{hɊ֘Atꂽڂ̌q̃CfbNX
     */
    public void setIndexPair(int atom1, int atom2) {
        this.atom1 = atom1;
        this.atom2 = atom2;
    }

    public double[] getCoordinates() {
        return coords;
    }

    private double crtdst;

    public void setCriticalDistanceSquared(double crtdst) {
        this.crtdst = crtdst;
    }

    public double getCriticalDistanceSquared() {
        return this.crtdst;
    }

    private BondObject bobject;

    public void setBond(BondObject bobject) {
        this.bobject = bobject;
    }

    public BondObject getBond() {
        return this.bobject;
    }

    private double length = -100;

    /**
     * {h𖾎IɃZbg; ʂ͌vZ
     * 
     * @param length
     *            {h
     */
    public void setBondLengthSquared(double length) {
        this.length = length;
    }

    public double getBondLength() {
        if (this.length > 0) {
            return Math.sqrt(this.length);
        }
        return Math.sqrt(Math.pow(coords[3] - coords[0], 2)
                + Math.pow(coords[4] - coords[1], 2)
                + Math.pow(coords[5] - coords[2], 2));
    }

    public boolean equals(BondInfo bondInfo) {
        int[] test = bondInfo.getIndexPair();
        if (test[0] == atom1 && test[1] == atom2) {
            return true;
        } else {
            return false;
        }
    }

    public int compareTo(Object o) {
        if (!(o instanceof BondInfo)) {
            throw new ClassCastException();
        }
        if (((BondInfo) o).length > this.length) {
            return -1;
        } else if (((BondInfo) o).length == this.length) {
            return 0;
        }
        return 1;
    }

}
