/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/10/19, 17:48
!  AUTHOR(S): KOGA, Junichiro
!  File : ACVMouseMotionListener.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.mouselistener;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.MainPanel;

/**
 * qzur[A[pMouseMotionListener
 * 
 * @author
 */
public class ACVMouseMotionListener implements MouseMotionListener,
        MouseListener {
    private Logger logger = Logger.getLogger(ACVMouseMotionListener.class
            .getName());

    private CoordsViewerInterface parent;

    private MouseMotionListenerManager manager;

    /** Creates a new instance of ACVMouseMotionListener */
    public ACVMouseMotionListener(MainPanel parent) {
        this.parent = parent;
        manager = new MouseMotionListenerManager(parent);
    }

    public void mouseDragged(MouseEvent e) {
        MouseMotionListenerAction action = manager.getAction(e);
        if (action == null) {
            logger.debug("action for "
                    + MouseEvent.getMouseModifiersText(e.getModifiersEx())
                    + " not implemented yet.");
            return;
        }
        action.processMouseDrag(e);
    }

    public void mouseMoved(MouseEvent e) {
        ((MainPanel) parent).getJCanvas3D().requestFocusInWindow();
    }

    public void mousePressed(MouseEvent e) {
        MouseMotionListenerAction action = manager.getAction(e);
        if (action == null) {
            logger.debug("action for "
                    + MouseEvent.getMouseModifiersText(e.getModifiersEx())
                    + " not implemented yet.");
            return;
        }
        action.init(e);
    }

    public void mouseReleased(MouseEvent e) {
        MouseMotionListenerAction action = manager.getAction(e);
        if (action == null) {
            logger.debug("action for "
                    + MouseEvent.getMouseModifiersText(e.getModifiersEx())
                    + " not implemented yet.");
            return;
        }
        action.finalize(e);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

}
