/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.parser.autodesk;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.cybergarage.x3d.node.AppearanceNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.GroupNode;
import org.cybergarage.x3d.node.IndexedFaceSetNode;
import org.cybergarage.x3d.node.MaterialNode;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.ShapeNode;
import org.cybergarage.x3d.parser.autodesk.Parser3DSConstants;
import org.cybergarage.x3d.util.Debug;

public class Parser3DS
implements Parser3DSConstants {
    private GroupNode mRootGroupNode;
    private GroupNode mMaterialRootNode;
    private MaterialNode mCurrentMaterialNode;
    private ShapeNode mCurrentShapeNode;
    private float[] color = new float[3];
    private float shininess;

    public Parser3DS() {
        this.setRootGroupNode(new GroupNode());
        this.setMaterialRootNode(new GroupNode());
        this.setCurrentShapeNode(null);
        this.setCurrentMaterialNode(null);
    }

    private void setRootGroupNode(GroupNode node) {
        this.mRootGroupNode = node;
    }

    public GroupNode getRootGroupNode() {
        return this.mRootGroupNode;
    }

    private void setMaterialRootNode(GroupNode node) {
        this.mMaterialRootNode = node;
    }

    private GroupNode getMaterialRootNode() {
        return this.mMaterialRootNode;
    }

    private void addMaterialNode(MaterialNode matNode) {
        this.getMaterialRootNode().addChildNode(matNode);
    }

    private MaterialNode getMaterialNode(String name) {
        if (name == null) {
            return null;
        }
        MaterialNode matNode = (MaterialNode)this.getMaterialRootNode().getChildNodes();
        while (matNode != null) {
            if (name.equalsIgnoreCase(matNode.getName())) {
                return matNode;
            }
            matNode = (MaterialNode)matNode.next();
        }
        return null;
    }

    private void setCurrentMaterialNode(MaterialNode node) {
        this.mCurrentMaterialNode = node;
    }

    private MaterialNode getCurrentMaterialNode() {
        return this.mCurrentMaterialNode;
    }

    private void setCurrentShapeNode(ShapeNode node) {
        this.mCurrentShapeNode = node;
    }

    private ShapeNode getCurrentShapeNode() {
        return this.mCurrentShapeNode;
    }

    private AppearanceNode getCurrentAppearanceNode() {
        return this.getCurrentShapeNode().getAppearanceNodes();
    }

    private IndexedFaceSetNode getCurrentIndexedFaceSetNode() {
        return this.getCurrentShapeNode().getIndexedFaceSetNodes();
    }

    private CoordinateNode getCurrentCoordinateNode() {
        return this.getCurrentIndexedFaceSetNode().getCoordinateNodes();
    }

    private NormalNode getCurrentNormalNode() {
        return this.getCurrentIndexedFaceSetNode().getNormalNodes();
    }

    public boolean load(InputStream inputStream) {
        try {
            DataInputStream dataIn = new DataInputStream(inputStream);
            while (true) {
                int id = this.readUnsignedShort(dataIn);
                int len = this.readInt(dataIn);
                this.readChunk(dataIn, id, len);
            }
        }
        catch (EOFException dataIn) {
        }
        catch (IOException ioe) {
            Debug.warning("Parser3DS.load");
            Debug.warning("\tIOException");
            return false;
        }
        return true;
    }

    private void readChunk(DataInputStream dataIn, int id, int len) throws IOException {
        switch (id) {
            case 19789: {
                Debug.message("ID_3DS_FILE");
                return;
            }
            case 15677: {
                Debug.message("ID_EDIT3DS");
                break;
            }
            case 45055: {
                Debug.message("ID_MATERIAL");
                MaterialNode matNode = new MaterialNode();
                matNode.setAmbientIntensity(0.0f);
                this.addMaterialNode(matNode);
                this.setCurrentMaterialNode(matNode);
                break;
            }
            case 40960: {
                Debug.message("ID_MATERIAL_NAME");
                String matName = this.readString(dataIn);
                Debug.message("\tname = " + matName);
                this.getCurrentMaterialNode().setName(matName);
                break;
            }
            case 40976: {
                this.readColor(dataIn, this.color);
                Debug.message("ID_MATERIAL_AMBIENT = (" + this.color[0] + ", " + this.color[1] + ", " + this.color[2] + ")");
                this.getCurrentMaterialNode().setEmissiveColor(this.color);
                break;
            }
            case 40992: {
                this.readColor(dataIn, this.color);
                Debug.message("ID_MATERIAL_DIFFUSE = (" + this.color[0] + ", " + this.color[1] + ", " + this.color[2] + ")");
                this.getCurrentMaterialNode().setDiffuseColor(this.color);
                break;
            }
            case 41008: {
                this.readColor(dataIn, this.color);
                Debug.message("ID_MATERIAL_SPECULAR = (" + this.color[0] + ", " + this.color[1] + ", " + this.color[2] + ")");
                this.getCurrentMaterialNode().setSpecularColor(this.color);
                break;
            }
            case 41024: {
                this.shininess = this.readPercentage(dataIn);
                Debug.message("ID_MATERIAL_SHININESS = " + this.shininess);
                break;
            }
            case 41025: {
                float shininessStrength = this.readPercentage(dataIn);
                Debug.message("ID_MATERIAL_SHININESS = " + shininessStrength);
                float matShiness = (1.0f - (this.shininess + shininessStrength) / 2.0f) * 128.0f;
                Debug.message("\tshininess = " + matShiness);
                this.getCurrentMaterialNode().setShininess(matShiness);
                break;
            }
            case 41040: {
                this.getCurrentMaterialNode().setTransparency(this.readPercentage(dataIn));
                break;
            }
            case 16384: {
                Debug.message("ID_NAMED_OBJECT");
                String objName = this.readString(dataIn);
                Debug.message("\tname = " + objName);
                ShapeNode shapeNode = new ShapeNode();
                shapeNode.setName(objName);
                shapeNode.addChildNode(new AppearanceNode());
                this.getRootGroupNode().addChildNode(shapeNode);
                this.setCurrentShapeNode(shapeNode);
                break;
            }
            case 16640: {
                Debug.message("ID_TRIANGLE_SET");
                IndexedFaceSetNode idxFaceSetNode = new IndexedFaceSetNode();
                idxFaceSetNode.addChildNode(new CoordinateNode());
                this.getCurrentShapeNode().addChildNode(idxFaceSetNode);
                break;
            }
            case 16656: {
                Debug.message("ID_POINT_LIST");
                int nPoints = this.readUnsignedShort(dataIn);
                Debug.message("\tnPoints = " + nPoints);
                CoordinateNode coordNode = this.getCurrentCoordinateNode();
                int n = 0;
                while (n < nPoints) {
                    float x = this.readFloat(dataIn);
                    float y = this.readFloat(dataIn);
                    float z = this.readFloat(dataIn);
                    coordNode.addPoint(x, y, z);
                    Debug.message("\t\t" + x + ", " + y + ", " + z);
                    ++n;
                }
                break;
            }
            case 16672: {
                Debug.message("ID_FACE_LIST");
                int nIndices = this.readUnsignedShort(dataIn);
                Debug.message("\tnIndices = " + nIndices);
                IndexedFaceSetNode idxFaceSetNode = this.getCurrentIndexedFaceSetNode();
                int n = 0;
                while (n < nIndices) {
                    int idx1 = this.readUnsignedShort(dataIn);
                    int idx2 = this.readUnsignedShort(dataIn);
                    int idx3 = this.readUnsignedShort(dataIn);
                    idxFaceSetNode.addCoordIndex(idx1);
                    idxFaceSetNode.addCoordIndex(idx2);
                    idxFaceSetNode.addCoordIndex(idx3);
                    idxFaceSetNode.addCoordIndex(-1);
                    Debug.message("\t\t" + idx1 + ", " + idx2 + ", " + idx3);
                    this.readUnsignedShort(dataIn);
                    ++n;
                }
                break;
            }
            case 16688: {
                Debug.message("ID_FACE_MATERIAL");
                String matName = this.readString(dataIn);
                Debug.message("\tname = " + matName);
                MaterialNode matNode = this.getMaterialNode(matName);
                if (matNode != null) {
                    this.getCurrentAppearanceNode().addChildNode(new MaterialNode(matNode));
                }
                int nCounts = this.readUnsignedShort(dataIn);
                int n = 0;
                while (n < nCounts) {
                    this.readUnsignedShort(dataIn);
                    ++n;
                }
                break;
            }
            default: {
                Debug.message("ID : 0x" + Integer.toHexString(id) + "  LEN : " + len);
                this.skipChunk(dataIn, len);
            }
        }
    }

    private int readUnsignedByte(DataInputStream dataIn) throws IOException {
        return dataIn.readUnsignedByte();
    }

    private int readUnsignedShort(DataInputStream dataIn) throws IOException {
        int value = dataIn.readUnsignedShort();
        return value << 8 & 0xFF00 | value >> 8 & 0xFF;
    }

    private int readInt(DataInputStream dataIn) throws IOException {
        int value = dataIn.readInt();
        return value << 24 & 0xFF000000 | value << 8 & 0xFF0000 | value >> 8 & 0xFF00 | value >> 24 & 0xFF;
    }

    private float readFloat(DataInputStream dataIn) throws IOException {
        return Float.intBitsToFloat(this.readInt(dataIn));
    }

    private String readString(DataInputStream dataIn) throws IOException {
        StringBuffer sb = new StringBuffer();
        byte c = dataIn.readByte();
        while (c != 0) {
            sb.append((char)c);
            c = dataIn.readByte();
        }
        return sb.toString();
    }

    private void readColor(DataInputStream dataIn, float[] color) throws IOException {
        int type = this.readUnsignedShort(dataIn);
        int len = this.readInt(dataIn);
        switch (type) {
            case 16: {
                color[0] = this.readFloat(dataIn);
                color[1] = this.readFloat(dataIn);
                color[2] = this.readFloat(dataIn);
                break;
            }
            case 17: {
                color[0] = (float)this.readUnsignedByte(dataIn) / 255.0f;
                color[1] = (float)this.readUnsignedByte(dataIn) / 255.0f;
                color[2] = (float)this.readUnsignedByte(dataIn) / 255.0f;
                break;
            }
            default: {
                Debug.warning("Unknown Color Type : 0x" + Integer.toHexString(type));
            }
        }
    }

    private float readPercentage(DataInputStream dataIn) throws IOException {
        int type = this.readUnsignedShort(dataIn);
        int len = this.readInt(dataIn);
        switch (type) {
            case 48: {
                return (float)this.readUnsignedShort(dataIn) / 100.0f;
            }
            case 49: {
                return this.readFloat(dataIn);
            }
        }
        Debug.warning("Unknown Percentage Type : 0x" + Integer.toHexString(type));
        return 0.0f;
    }

    private void skipChunk(DataInputStream dataIn, int len) throws IOException {
        int nSkipBytes = len - 6;
        if (nSkipBytes > 0) {
            dataIn.skipBytes(nSkipBytes);
        }
    }
}

