/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.field.SFNode;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.AudioClipNode;
import org.cybergarage.x3d.node.MovieTextureNode;
import org.cybergarage.x3d.node.Node;

public class SoundNode
extends Node {
    private static final String minFrontExposedFieldName = "minFront";
    private static final String maxFrontExposedFieldName = "maxFront";
    private static final String minBackExposedFieldName = "minBack";
    private static final String maxBackExposedFieldName = "maxBack";
    private static final String intensityExposedFieldName = "intensity";
    private static final String priorityExposedFieldName = "priority";
    private static final String directionExposedFieldName = "direction";
    private static final String locationExposedFieldName = "location";
    private static final String sourceExposedFieldName = "source";
    private static final String spatializeFieldName = "spatialize";
    private SFFloat minFrontField;
    private SFFloat maxFrontField;
    private SFFloat minBackField;
    private SFFloat maxBackField;
    private SFFloat intensityField;
    private SFFloat priorityField;
    private SFVec3f directionField;
    private SFVec3f locationField;
    private SFBool spatializeField;
    private SFNode sourceField;

    public SoundNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.SOUND);
        this.minFrontField = new SFFloat(1.0f);
        this.addExposedField(minFrontExposedFieldName, this.minFrontField);
        this.maxFrontField = new SFFloat(10.0f);
        this.addExposedField(maxFrontExposedFieldName, this.maxFrontField);
        this.minBackField = new SFFloat(1.0f);
        this.addExposedField(minBackExposedFieldName, this.minBackField);
        this.maxBackField = new SFFloat(10.0f);
        this.addExposedField(maxBackExposedFieldName, this.maxBackField);
        this.intensityField = new SFFloat(10.0f);
        this.addExposedField(intensityExposedFieldName, this.intensityField);
        this.priorityField = new SFFloat(10.0f);
        this.addExposedField(priorityExposedFieldName, this.priorityField);
        this.directionField = new SFVec3f(0.0f, 0.0f, 1.0f);
        this.addExposedField(directionExposedFieldName, this.directionField);
        this.locationField = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.addExposedField(locationExposedFieldName, this.locationField);
        this.sourceField = new SFNode();
        this.addExposedField(sourceExposedFieldName, this.sourceField);
        this.spatializeField = new SFBool(true);
        this.addField(spatializeFieldName, this.spatializeField);
    }

    public SoundNode(SoundNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFNode getSourceField() {
        if (!this.isInstanceNode()) {
            return this.sourceField;
        }
        return (SFNode)this.getExposedField(sourceExposedFieldName);
    }

    public void updateSourceField() {
    }

    public SFVec3f getDirectionField() {
        if (!this.isInstanceNode()) {
            return this.directionField;
        }
        return (SFVec3f)this.getExposedField(directionExposedFieldName);
    }

    public void setDirection(float[] value) {
        this.getDirectionField().setValue(value);
    }

    public void setDirection(float x, float y, float z) {
        this.getDirectionField().setValue(x, y, z);
    }

    public void setDirection(String value) {
        this.getDirectionField().setValue(value);
    }

    public void getDirection(float[] value) {
        this.getDirectionField().getValue(value);
    }

    public SFVec3f getLocationField() {
        if (!this.isInstanceNode()) {
            return this.locationField;
        }
        return (SFVec3f)this.getExposedField(locationExposedFieldName);
    }

    public void setLocation(float[] value) {
        this.getLocationField().setValue(value);
    }

    public void setLocation(float x, float y, float z) {
        this.getLocationField().setValue(x, y, z);
    }

    public void setLocation(String value) {
        this.getLocationField().setValue(value);
    }

    public void getLocation(float[] value) {
        this.getLocationField().getValue(value);
    }

    public SFFloat getMinFrontField() {
        if (!this.isInstanceNode()) {
            return this.minFrontField;
        }
        return (SFFloat)this.getExposedField(minFrontExposedFieldName);
    }

    public void setMinFront(float value) {
        this.getMinFrontField().setValue(value);
    }

    public void setMinFront(String value) {
        this.getMinFrontField().setValue(value);
    }

    public float getMinFront() {
        return this.getMinFrontField().getValue();
    }

    public SFFloat getMaxFrontField() {
        if (!this.isInstanceNode()) {
            return this.maxFrontField;
        }
        return (SFFloat)this.getExposedField(maxFrontExposedFieldName);
    }

    public void setMaxFront(float value) {
        this.getMaxFrontField().setValue(value);
    }

    public void setMaxFront(String value) {
        this.getMaxFrontField().setValue(value);
    }

    public float getMaxFront() {
        return this.getMaxFrontField().getValue();
    }

    public SFFloat getMinBackField() {
        if (!this.isInstanceNode()) {
            return this.minBackField;
        }
        return (SFFloat)this.getExposedField(minBackExposedFieldName);
    }

    public void setMinBack(float value) {
        this.getMinBackField().setValue(value);
    }

    public void setMinBack(String value) {
        this.getMinBackField().setValue(value);
    }

    public float getMinBack() {
        return this.getMinBackField().getValue();
    }

    public SFFloat getMaxBackField() {
        if (!this.isInstanceNode()) {
            return this.maxBackField;
        }
        return (SFFloat)this.getExposedField(maxBackExposedFieldName);
    }

    public void setMaxBack(float value) {
        this.getMaxBackField().setValue(value);
    }

    public void setMaxBack(String value) {
        this.getMaxBackField().setValue(value);
    }

    public float getMaxBack() {
        return this.getMaxBackField().getValue();
    }

    public SFFloat getIntensityField() {
        if (!this.isInstanceNode()) {
            return this.intensityField;
        }
        return (SFFloat)this.getExposedField(intensityExposedFieldName);
    }

    public void setIntensity(float value) {
        this.getIntensityField().setValue(value);
    }

    public void setIntensity(String value) {
        this.getIntensityField().setValue(value);
    }

    public float getIntensity() {
        return this.getIntensityField().getValue();
    }

    public SFFloat getPriorityField() {
        if (!this.isInstanceNode()) {
            return this.priorityField;
        }
        return (SFFloat)this.getExposedField(priorityExposedFieldName);
    }

    public void setPriority(float value) {
        this.getPriorityField().setValue(value);
    }

    public void setPriority(String value) {
        this.getPriorityField().setValue(value);
    }

    public float getPriority() {
        return this.getPriorityField().getValue();
    }

    public SFBool getSpatializeField() {
        if (!this.isInstanceNode()) {
            return this.spatializeField;
        }
        return (SFBool)this.getField(spatializeFieldName);
    }

    public void setSpatialize(boolean value) {
        this.getSpatializeField().setValue(value);
    }

    public void setSpatialize(String value) {
        this.getSpatializeField().setValue(value);
    }

    public boolean getSpatialize() {
        return this.getSpatializeField().getValue();
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return node.isAudioClipNode() || node.isMovieTextureNode();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        MovieTextureNode mtexture;
        SFBool spatialize = this.getSpatializeField();
        SFVec3f direction = this.getDirectionField();
        SFVec3f location = this.getLocationField();
        printStream.println(String.valueOf(indentString) + "\t" + "direction " + direction);
        printStream.println(String.valueOf(indentString) + "\t" + "location " + location);
        printStream.println(String.valueOf(indentString) + "\t" + "maxFront " + this.getMaxFront());
        printStream.println(String.valueOf(indentString) + "\t" + "minFront " + this.getMinFront());
        printStream.println(String.valueOf(indentString) + "\t" + "maxBack " + this.getMaxBack());
        printStream.println(String.valueOf(indentString) + "\t" + "minBack " + this.getMinBack());
        printStream.println(String.valueOf(indentString) + "\t" + "intensity " + this.getIntensity());
        printStream.println(String.valueOf(indentString) + "\t" + "priority " + this.getPriority());
        printStream.println(String.valueOf(indentString) + "\t" + "spatialize " + spatialize);
        AudioClipNode aclip = this.getAudioClipNodes();
        if (aclip != null) {
            if (!aclip.isInstanceNode()) {
                String nodeName = aclip.getName();
                if (nodeName != null && nodeName.length() > 0) {
                    printStream.println(String.valueOf(indentString) + "\t" + "source DEF " + aclip.getName() + " AudioClip {");
                } else {
                    printStream.println(String.valueOf(indentString) + "\t" + "source AudioClip {");
                }
                aclip.outputContext(printStream, String.valueOf(indentString) + "\t");
                printStream.println(String.valueOf(indentString) + "\t" + "}");
            } else {
                printStream.println(String.valueOf(indentString) + "\t" + "source USE " + aclip.getName());
            }
        }
        if ((mtexture = this.getMovieTextureNodes()) != null) {
            if (!mtexture.isInstanceNode()) {
                String nodeName = mtexture.getName();
                if (nodeName != null && nodeName.length() > 0) {
                    printStream.println(String.valueOf(indentString) + "\t" + "source DEF " + mtexture.getName() + " MovieTexture {");
                } else {
                    printStream.println(String.valueOf(indentString) + "\t" + "source MovieTexture {");
                }
                mtexture.outputContext(printStream, String.valueOf(indentString) + "\t");
                printStream.println(String.valueOf(indentString) + "\t" + "}");
            } else {
                printStream.println(String.valueOf(indentString) + "\t" + "source USE " + mtexture.getName());
            }
        }
    }
}

