/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class Targa {
    public static final int FORMAT_RGB_16 = 16;
    public static final int FORMAT_RGB_24 = 24;
    public static final int FORMAT_RGB_32 = 32;
    private BufferedImage mBufferedImage;
    private Header mHeader;

    public Targa() {
        this.setHeader(new Header());
        this.setBufferedImage(null);
    }

    public Targa(BufferedImage bufImage) {
        this.setHeader(new Header());
        this.setBufferedImage(bufImage);
    }

    public void setBufferedImage(BufferedImage bufImage) {
        this.mBufferedImage = bufImage;
        Header header = this.getHeader();
        if (bufImage == null) {
            header.setPixelSize(0);
            header.setWidth(0);
            header.setHeight(0);
            return;
        }
        header.setPixelSize(0);
        if (bufImage.getType() == 2) {
            header.setPixelSize(32);
        }
        if (bufImage.getType() == 1) {
            header.setPixelSize(24);
        }
        header.setWidth(bufImage.getWidth());
        header.setHeight(bufImage.getHeight());
    }

    public BufferedImage getBufferedImage() {
        return this.mBufferedImage;
    }

    public void printBufferedImageInfo() {
        System.out.println("==== BufferedImage Infomation ====");
        System.out.println("    mBufferedImage = " + this.mBufferedImage);
    }

    private void setHeader(Header bufImage) {
        this.mHeader = bufImage;
    }

    public Header getHeader() {
        return this.mHeader;
    }

    public boolean isGNUZipped(URL url) {
        boolean isZipped = false;
        try {
            InputStream in = url.openStream();
            byte[] header = new byte[]{this.readByte(in), this.readByte(in)};
            if (header[0] == 31 && header[1] == -117) {
                isZipped = true;
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isZipped;
    }

    public boolean isZipped(URL url) {
        boolean isZipped = false;
        try {
            InputStream in = url.openStream();
            byte[] header = new byte[]{this.readByte(in), this.readByte(in)};
            if (header[0] == 80 && header[1] == 75) {
                isZipped = true;
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isZipped;
    }

    public boolean load(URL url) {
        BufferedImage bufImage;
        int pixelSize;
        int height;
        int width;
        InputStream in;
        block13: {
            block12: {
                boolean isZipped = this.isGNUZipped(url);
                System.out.println("isZipped = " + isZipped);
                try {
                    in = url.openStream();
                    if (isZipped) {
                        in = new GZIPInputStream(in);
                    }
                    Header header = this.getHeader();
                    this.readHeader(in, header);
                    width = header.getWidth();
                    height = header.getHeight();
                    pixelSize = header.getPixelSize();
                    if (width > 0 && height > 0) break block12;
                    in.close();
                    return false;
                }
                catch (IOException ioe) {
                    return false;
                }
            }
            bufImage = null;
            if (pixelSize == 24) {
                bufImage = new BufferedImage(width, height, 1);
            }
            if (pixelSize == 16 || pixelSize == 32) {
                bufImage = new BufferedImage(width, height, 1);
            }
            if (bufImage != null) break block13;
            in.close();
            return false;
        }
        switch (pixelSize) {
            case 16: {
                this.readPixel16(in, bufImage, width, height);
                break;
            }
            case 24: {
                this.readPixel24(in, bufImage, width, height);
                break;
            }
            case 32: {
                this.readPixel32(in, bufImage, width, height);
            }
        }
        this.setBufferedImage(bufImage);
        in.close();
        return true;
    }

    private void readPixel16(InputStream in, BufferedImage bufImage, int width, int height) throws IOException {
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                short color16 = this.readShort(in);
                byte b = (byte)((float)((color16 & 0x7C00) >> 10) / 31.0f * 255.0f);
                byte g = (byte)((float)((color16 & 0x3E0) >> 5) / 31.0f * 255.0f);
                byte r = (byte)((float)((color16 & 0x1F) >> 0) / 31.0f * 255.0f);
                boolean useAlpha = (color16 & 0x8000) == 0;
                int color = 0;
                color |= r << 16 & 0xFF0000;
                color |= g << 8 & 0xFF00;
                color |= b << 0 & 0xFF;
                if (!useAlpha) {
                    color |= 0xFF000000;
                }
                bufImage.setRGB(x, y, color);
                ++x;
            }
            ++y;
        }
    }

    private void readPixel24(InputStream in, BufferedImage bufImage, int width, int height) throws IOException {
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int color = 0;
                color |= this.readByte(in) << 16 & 0xFF0000;
                color |= this.readByte(in) << 8 & 0xFF00;
                bufImage.setRGB(x, y, color |= this.readByte(in) << 0 & 0xFF);
                ++x;
            }
            ++y;
        }
    }

    private void readPixel32(InputStream in, BufferedImage bufImage, int width, int height) throws IOException {
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int color = 0;
                color |= this.readByte(in) << 16 & 0xFF0000;
                color |= this.readByte(in) << 8 & 0xFF00;
                color |= this.readByte(in) << 0 & 0xFF;
                bufImage.setRGB(x, y, color |= this.readByte(in) << 24 & 0xFF000000);
                ++x;
            }
            ++y;
        }
    }

    private byte readByte(InputStream in) throws IOException {
        return (byte)in.read();
    }

    private short readShort(InputStream in) throws IOException {
        return (short)(in.read() & 0xFF | in.read() << 8 & 0xFF00);
    }

    private void readHeader(InputStream in, Header header) throws IOException {
        header.idLength = this.readByte(in);
        header.coMapType = this.readByte(in);
        header.imgType = this.readByte(in);
        header.index = this.readShort(in);
        header.length = this.readShort(in);
        header.coSize = this.readByte(in);
        header.xOrg = this.readShort(in);
        header.yOrg = this.readShort(in);
        header.width = this.readShort(in);
        header.height = this.readShort(in);
        header.pixelSize = this.readByte(in);
        header.attBits = this.readByte(in);
    }

    public boolean load(File file) {
        try {
            return this.load(file.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public boolean load(String filename) {
        return this.load(new File(filename));
    }

    public boolean checkHeader() {
        BufferedImage bufImage = this.getBufferedImage();
        if (bufImage == null) {
            return false;
        }
        Header header = this.getHeader();
        int width = header.getWidth();
        int height = header.getHeight();
        return width > 0 && height > 0;
    }

    public boolean save(OutputStream out, int formatType) {
        BufferedImage bufImage = this.getBufferedImage();
        Header header = this.getHeader();
        int width = header.getWidth();
        int height = header.getHeight();
        if (formatType != 16 && formatType != 24 && formatType != 32) {
            return false;
        }
        header.setPixelSize(formatType);
        try {
            this.writeHeader(out, header);
            switch (formatType) {
                case 16: {
                    this.writePixel16(out, bufImage, width, height);
                    break;
                }
                case 24: {
                    this.writePixel24(out, bufImage, width, height);
                    break;
                }
                case 32: {
                    this.writePixel32(out, bufImage, width, height);
                }
            }
            out.flush();
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public boolean save(String filename, int formatType, boolean doCompress) {
        if (!this.checkHeader()) {
            return false;
        }
        try {
            OutputStream out = new FileOutputStream(filename);
            if (doCompress) {
                out = new GZIPOutputStream(out);
            }
            this.save(out, formatType);
            out.close();
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public boolean save(String filename, int formatType) {
        return this.save(filename, formatType, false);
    }

    private void writePixel16(OutputStream out, BufferedImage bufImage, int width, int height) throws IOException {
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int color = bufImage.getRGB(x, y);
                byte r = (byte)((float)((color & 0xFF0000) >> 16) / 255.0f * 31.0f);
                byte g = (byte)((float)((color & 0xFF00) >> 8) / 255.0f * 31.0f);
                byte b = (byte)((float)((color & 0xFF) >> 0) / 255.0f * 31.0f);
                boolean useAlpha = (color & 0xFF000000) >> 24 == 0;
                short argb = 0;
                argb = (short)(argb | b << 10 & 0x7C00);
                argb = (short)(argb | g << 5 & 0x3E0);
                argb = (short)(argb | r << 0 & 0x1F);
                argb = (short)(argb | (useAlpha ? 0 : 32768));
                this.writeShort(out, argb);
                ++x;
            }
            ++y;
        }
    }

    private void writePixel24(OutputStream out, BufferedImage bufImage, int width, int height) throws IOException {
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int color = bufImage.getRGB(x, y);
                this.writeByte(out, (byte)((color & 0xFF0000) >> 16));
                this.writeByte(out, (byte)((color & 0xFF00) >> 8));
                this.writeByte(out, (byte)((color & 0xFF) >> 0));
                ++x;
            }
            ++y;
        }
    }

    private void writePixel32(OutputStream out, BufferedImage bufImage, int width, int height) throws IOException {
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int color = bufImage.getRGB(x, y);
                this.writeByte(out, (byte)((color & 0xFF0000) >> 16));
                this.writeByte(out, (byte)((color & 0xFF00) >> 8));
                this.writeByte(out, (byte)((color & 0xFF) >> 0));
                this.writeByte(out, (byte)((color & 0xFF000000) >> 24));
                ++x;
            }
            ++y;
        }
    }

    private void writeByte(OutputStream out, byte data) throws IOException {
        out.write(data);
    }

    private void writeShort(OutputStream out, short data) throws IOException {
        out.write((byte)(data & 0xFF));
        out.write((byte)((data & 0xFF00) >> 8));
    }

    private void writeHeader(OutputStream out, Header header) throws IOException {
        this.writeByte(out, header.idLength);
        this.writeByte(out, header.coMapType);
        this.writeByte(out, header.imgType);
        this.writeShort(out, header.index);
        this.writeShort(out, header.length);
        this.writeByte(out, header.coSize);
        this.writeShort(out, header.xOrg);
        this.writeShort(out, header.yOrg);
        this.writeShort(out, header.width);
        this.writeShort(out, header.height);
        this.writeByte(out, header.pixelSize);
        this.writeByte(out, header.attBits);
    }

    public static void main(String[] args) {
        Targa inTarga = new Targa();
        boolean ret = inTarga.load("wood.tga");
        inTarga.getHeader().print();
        inTarga.printBufferedImageInfo();
        System.out.println("Loading ..... " + ret);
        Targa outTarga = new Targa();
        outTarga.setBufferedImage(inTarga.getBufferedImage());
        outTarga.getHeader().print();
        ret = outTarga.save("output.gz", 32, true);
        System.out.println("Saving ..... " + ret);
        Targa inTarga2 = new Targa();
        ret = inTarga2.load("output.gz");
        inTarga2.getHeader().print();
        inTarga2.printBufferedImageInfo();
        System.out.println("Loading ..... " + ret);
        Targa outTarga2 = new Targa();
        outTarga2.setBufferedImage(inTarga2.getBufferedImage());
        outTarga2.getHeader().print();
        ret = outTarga2.save("output.tga", 24);
        System.out.println("Saving ..... " + ret);
    }

    public class Header {
        public byte idLength = 0;
        public byte coMapType = 0;
        public byte imgType = (byte)2;
        public short index = 0;
        public short length = 0;
        public byte coSize = 0;
        public short xOrg = 0;
        public short yOrg = 0;
        public short width = 0;
        public short height = 0;
        public byte pixelSize = 0;
        public byte attBits = 0;

        public Header() {
        }

        public Header(int width, int height) {
            this();
            this.setWidth(width);
            this.setHeight(height);
        }

        public void setWidth(int width) {
            this.width = (short)width;
        }

        public int getWidth() {
            return this.width;
        }

        public void setHeight(int height) {
            this.height = (short)height;
        }

        public int getHeight() {
            return this.height;
        }

        public void setPixelSize(int pixelSize) {
            this.pixelSize = (byte)pixelSize;
        }

        public int getPixelSize() {
            return this.pixelSize;
        }

        public void print() {
            System.out.println("==== TARGA Header Infomation ====");
            System.out.println("    idLength  = " + this.idLength);
            System.out.println("    coMapType = " + this.coMapType);
            System.out.println("    index     = " + this.index);
            System.out.println("    length    = " + this.length);
            System.out.println("    coSize    = " + this.coSize);
            System.out.println("    xOrg      = " + this.xOrg);
            System.out.println("    yOrg      = " + this.yOrg);
            System.out.println("    width     = " + this.width);
            System.out.println("    height    = " + this.height);
            System.out.println("    pixelSize = " + this.pixelSize);
            System.out.println("    attBits   = " + this.attBits);
        }
    }
}

