/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.FieldType;
import org.cybergarage.x3d.field.Vec3dValue;

public class SFVec3d
extends Field {
    private Vec3dValue mVector = new Vec3dValue();

    public SFVec3d() {
        this.setType(FieldType.SFVEC3D);
        this.setValue(0.0, 0.0, 0.0);
    }

    public SFVec3d(SFVec3d vector) {
        this();
        this.setValue(vector);
    }

    public SFVec3d(double x, double y, double z) {
        this();
        this.setValue(x, y, z);
    }

    public SFVec3d(double[] value) {
        this();
        this.setValue(value);
    }

    public SFVec3d(String value) {
        this();
        this.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(Object object) {
        Vec3dValue vec3dValue = this.mVector;
        synchronized (vec3dValue) {
            this.mVector = (Vec3dValue)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject() {
        Vec3dValue object;
        Vec3dValue vec3dValue = this.mVector;
        synchronized (vec3dValue) {
            object = this.mVector;
        }
        return object;
    }

    public void getValue(double[] value) {
        this.mVector.getValue(value);
    }

    public double[] getValue() {
        return this.mVector.getValue();
    }

    public double getX() {
        return this.mVector.getX();
    }

    public double getY() {
        return this.mVector.getY();
    }

    public double getZ() {
        return this.mVector.getZ();
    }

    @Override
    public int getValueCount() {
        return 3;
    }

    public void setValue(double x, double y, double z, boolean doShare) {
        this.mVector.setValue(x, y, z);
        if (doShare) {
            this.postShareField(this);
        }
    }

    public void setValue(double x, double y, double z) {
        this.setValue(x, y, z, true);
    }

    public void setValue(double[] value) {
        if (value.length < 3) {
            return;
        }
        this.setValue(value[0], value[1], value[2]);
    }

    public void setValue(SFVec3d vector, boolean doShare) {
        this.setValue(vector.getX(), vector.getY(), vector.getZ(), doShare);
    }

    public void setValue(SFVec3d vector) {
        this.setValue(vector, true);
    }

    @Override
    public void setValue(String string) {
        this.mVector.setValue(string);
    }

    @Override
    public void setValue(Field field, boolean doShare) {
        if (field instanceof SFVec3d) {
            this.setValue((SFVec3d)field, doShare);
        }
    }

    @Override
    public void setValue(Field field) {
        this.setValue(field, true);
    }

    public void setX(double x) {
        this.setValue(x, this.getY(), this.getZ());
    }

    public void setY(double y) {
        this.setValue(this.getX(), y, this.getZ());
    }

    public void setZ(double z) {
        this.setValue(this.getX(), this.getY(), z);
    }

    public void add(double x, double y, double z) {
        this.mVector.add(x, y, z);
    }

    public void add(double[] value) {
        this.mVector.add(value);
    }

    public void add(SFVec3d value) {
        this.add(value.getValue());
    }

    public void sub(double x, double y, double z) {
        this.mVector.sub(x, y, z);
    }

    public void sub(double[] value) {
        this.mVector.sub(value);
    }

    public void sub(SFVec3d value) {
        this.sub(value.getValue());
    }

    public void scale(double scale) {
        this.mVector.scale(scale);
    }

    public void invert() {
        this.mVector.invert();
    }

    public double getScalar() {
        return this.mVector.getScalar();
    }

    public void normalize() {
        this.mVector.normalize();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getX()) + " " + this.getY() + " " + this.getZ();
    }
}

