/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d;

import org.cybergarage.x3d.Constants;
import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.InvalidEventInException;
import org.cybergarage.x3d.InvalidEventOutException;
import org.cybergarage.x3d.InvalidExposedFieldException;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.field.SFMatrix;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.AnchorNode;
import org.cybergarage.x3d.node.AppearanceNode;
import org.cybergarage.x3d.node.Arc2DNode;
import org.cybergarage.x3d.node.ArcClose2DNode;
import org.cybergarage.x3d.node.AudioClipNode;
import org.cybergarage.x3d.node.BackgroundNode;
import org.cybergarage.x3d.node.BillboardNode;
import org.cybergarage.x3d.node.BooleanFilterNode;
import org.cybergarage.x3d.node.BooleanSequencerNode;
import org.cybergarage.x3d.node.BooleanTimeTriggerNode;
import org.cybergarage.x3d.node.BooleanToggleNode;
import org.cybergarage.x3d.node.BooleanTriggerNode;
import org.cybergarage.x3d.node.BoxNode;
import org.cybergarage.x3d.node.Circle2DNode;
import org.cybergarage.x3d.node.CollisionNode;
import org.cybergarage.x3d.node.ColorInterpolatorNode;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.ColorRGBANode;
import org.cybergarage.x3d.node.ConeNode;
import org.cybergarage.x3d.node.CoordinateInterpolator2DNode;
import org.cybergarage.x3d.node.CoordinateInterpolatorNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.CylinderNode;
import org.cybergarage.x3d.node.CylinderSensorNode;
import org.cybergarage.x3d.node.DirectionalLightNode;
import org.cybergarage.x3d.node.Disk2DNode;
import org.cybergarage.x3d.node.ElevationGridNode;
import org.cybergarage.x3d.node.ExtrusionNode;
import org.cybergarage.x3d.node.FillPropertiesNode;
import org.cybergarage.x3d.node.FogNode;
import org.cybergarage.x3d.node.FontStyleNode;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.GroupNode;
import org.cybergarage.x3d.node.GroupingNode;
import org.cybergarage.x3d.node.ImageTextureNode;
import org.cybergarage.x3d.node.IndexedFaceSetNode;
import org.cybergarage.x3d.node.IndexedLineSetNode;
import org.cybergarage.x3d.node.InlineNode;
import org.cybergarage.x3d.node.IntegerSequencerNode;
import org.cybergarage.x3d.node.IntegerTriggerNode;
import org.cybergarage.x3d.node.InterpolatorNode;
import org.cybergarage.x3d.node.KeySensorNode;
import org.cybergarage.x3d.node.LODNode;
import org.cybergarage.x3d.node.LightNode;
import org.cybergarage.x3d.node.LinePropertiesNode;
import org.cybergarage.x3d.node.LoadSensorNode;
import org.cybergarage.x3d.node.MaterialNode;
import org.cybergarage.x3d.node.MovieTextureNode;
import org.cybergarage.x3d.node.MultiTextureCoordinateNode;
import org.cybergarage.x3d.node.MultiTextureNode;
import org.cybergarage.x3d.node.MultiTextureTransformNode;
import org.cybergarage.x3d.node.NavigationInfoNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeSequencerNode;
import org.cybergarage.x3d.node.NormalInterpolatorNode;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.OrientationInterpolatorNode;
import org.cybergarage.x3d.node.PixelTextureNode;
import org.cybergarage.x3d.node.PlaneSensorNode;
import org.cybergarage.x3d.node.PointLightNode;
import org.cybergarage.x3d.node.PointSetNode;
import org.cybergarage.x3d.node.Polyline2DNode;
import org.cybergarage.x3d.node.Polypoint2DNode;
import org.cybergarage.x3d.node.PositionInterpolator2DNode;
import org.cybergarage.x3d.node.PositionInterpolatorNode;
import org.cybergarage.x3d.node.ProximitySensorNode;
import org.cybergarage.x3d.node.ProxyNode;
import org.cybergarage.x3d.node.Rectangle2DNode;
import org.cybergarage.x3d.node.RootNode;
import org.cybergarage.x3d.node.ScalarInterpolatorNode;
import org.cybergarage.x3d.node.SceneNode;
import org.cybergarage.x3d.node.ScriptNode;
import org.cybergarage.x3d.node.Shape2DNode;
import org.cybergarage.x3d.node.ShapeNode;
import org.cybergarage.x3d.node.SoundNode;
import org.cybergarage.x3d.node.SphereNode;
import org.cybergarage.x3d.node.SphereSensorNode;
import org.cybergarage.x3d.node.SpotLightNode;
import org.cybergarage.x3d.node.StaticGroupNode;
import org.cybergarage.x3d.node.StringSensorNode;
import org.cybergarage.x3d.node.SwitchNode;
import org.cybergarage.x3d.node.TextNode;
import org.cybergarage.x3d.node.TextureCoordinateGeneratorNode;
import org.cybergarage.x3d.node.TextureCoordinateNode;
import org.cybergarage.x3d.node.TextureTransformNode;
import org.cybergarage.x3d.node.TimeSensorNode;
import org.cybergarage.x3d.node.TimeTriggerNode;
import org.cybergarage.x3d.node.TouchSensorNode;
import org.cybergarage.x3d.node.Transform2DNode;
import org.cybergarage.x3d.node.TransformNode;
import org.cybergarage.x3d.node.TriangleFanSetNode;
import org.cybergarage.x3d.node.TriangleSet2DNode;
import org.cybergarage.x3d.node.TriangleSetNode;
import org.cybergarage.x3d.node.TriangleStripSetNode;
import org.cybergarage.x3d.node.ViewpointNode;
import org.cybergarage.x3d.node.VisibilitySensorNode;
import org.cybergarage.x3d.node.WorldInfoNode;
import org.cybergarage.x3d.route.Route;
import org.cybergarage.x3d.util.BoundingBox;
import org.cybergarage.x3d.util.Debug;
import org.cybergarage.x3d.util.LinkedList;
import org.cybergarage.x3d.util.LinkedListNode;

public class Scene
extends LinkedListNode
implements Constants {
    private RootNode mRootNode = new RootNode();
    private LinkedList mRouteList = new LinkedList();
    private float[] mBoundingBoxCenter = new float[3];
    private float[] mBoundingBoxSize = new float[3];

    public RootNode getRootNode() {
        return this.mRootNode;
    }

    public int getNNodes() {
        return this.getRootNode().getNChildNodes();
    }

    public Node getNode(int n) {
        return this.getRootNode().getChildNode(n);
    }

    public Node getNodes() {
        return this.getRootNode().getChildNodes();
    }

    public void clearNodes() {
        this.getRootNode().removeChildNodes();
    }

    public Node getNodes(NodeType type) {
        Node node = this.getNodes();
        if (node == null) {
            return null;
        }
        NodeType nodeType = node.getType();
        if (nodeType.equals(type)) {
            return node;
        }
        return node.next(type);
    }

    public void setSceneGraph(SceneGraph sg) {
        RootNode rootNode = this.getRootNode();
        rootNode.setSceneGraph(sg);
    }

    public void addNode(Node node, boolean postShareEvent) {
        RootNode rootNode = this.getRootNode();
        rootNode.addChildNode(node, postShareEvent);
    }

    public void moveNode(Node node, boolean postShareEvent) {
        RootNode rootNode = this.getRootNode();
        rootNode.moveChildNode(node, postShareEvent);
    }

    public void addNode(Node node) {
        this.addNode(node, true);
    }

    public void moveNode(Node node) {
        this.moveNode(node, true);
    }

    public Route getRoutes() {
        return (Route)this.mRouteList.getNodes();
    }

    public Route getRoute(Node eventOutNode, Field eventOutField, Node eventInNode, Field eventInField) {
        Route route = this.getRoutes();
        while (route != null) {
            if (eventOutNode == route.getEventOutNode() && eventOutField == route.getEventOutField() && eventInNode == route.getEventInNode() && eventInField == route.getEventInField()) {
                return route;
            }
            route = route.next();
        }
        return null;
    }

    public Route addRoute(Route route) {
        if (route.getEventOutNode() == route.getEventInNode()) {
            Debug.warning("Invalidate route infomation = " + route);
            return null;
        }
        if (this.getRoute(route.getEventOutNode(), route.getEventOutField(), route.getEventInNode(), route.getEventInField()) != null) {
            Debug.message("The same route infomation is already added = " + route);
            return null;
        }
        this.mRouteList.addNode(route);
        return route;
    }

    public Route addRoute(Node eventOutNode, Field eventOutField, Node eventInNode, Field eventInField) {
        Route route = new Route(eventOutNode, eventOutField, eventInNode, eventInField);
        return this.addRoute(route);
    }

    public Route addRoute(String eventOutNodeName, String eventOutFieldName, String eventInNodeName, String eventInFieldName) {
        Node eventInNode = this.findNode(eventInNodeName);
        Node eventOutNode = this.findNode(eventOutNodeName);
        Field eventOutField = null;
        if (eventOutNode != null) {
            try {
                eventOutField = eventOutNode.getEventOut(eventOutFieldName);
            }
            catch (InvalidEventOutException eventOutException) {
                try {
                    eventOutField = eventOutNode.getExposedField(eventOutFieldName);
                }
                catch (InvalidExposedFieldException invalidExposedFieldException) {
                    // empty catch block
                }
            }
        }
        if (eventOutField == null) {
            Debug.warning("Couldn't a field (" + eventOutNodeName + "::" + eventOutFieldName + ")");
        }
        Field eventInField = null;
        if (eventInNode != null) {
            try {
                eventInField = eventInNode.getEventIn(eventInFieldName);
            }
            catch (InvalidEventInException eventInException) {
                try {
                    eventInField = eventInNode.getExposedField(eventInFieldName);
                }
                catch (InvalidExposedFieldException invalidExposedFieldException) {
                    // empty catch block
                }
            }
        }
        if (eventInField == null) {
            Debug.warning("Couldn't a field (" + eventInNodeName + "::" + eventInFieldName + ")");
        }
        return this.addRoute(eventOutNode, eventOutField, eventInNode, eventInField);
    }

    public void removeRoute(Node eventOutNode, Field eventOutField, Node eventInNode, Field eventInField) {
        Route route = this.getRoute(eventOutNode, eventOutField, eventInNode, eventInField);
        if (route != null) {
            route.remove();
        }
    }

    void removeEventInFieldRoutes(Node node, Field field) {
        Route route = this.getRoutes();
        while (route != null) {
            Route nextRoute = route.next();
            if (route.getEventInNode() == node && route.getEventInField() == field) {
                route.remove();
            }
            route = nextRoute;
        }
    }

    public void removeEventOutFieldRoutes(Node node, Field field) {
        Route route = this.getRoutes();
        while (route != null) {
            Route nextRoute = route.next();
            if (route.getEventOutNode() == node && route.getEventOutField() == field) {
                route.remove();
            }
            route = nextRoute;
        }
    }

    public void removeNodeRoutes(Node node) {
        Route route = this.getRoutes();
        while (route != null) {
            Route nextRoute = route.next();
            if (node == route.getEventInNode() || node == route.getEventOutNode()) {
                route.remove();
            }
            route = nextRoute;
        }
    }

    public void removeNodeRoutes(Node node, Field field) {
        this.removeEventInFieldRoutes(node, field);
        this.removeEventOutFieldRoutes(node, field);
    }

    public void removeRoute(Route removeRoute) {
        Route route = this.getRoutes();
        while (route != null) {
            if (removeRoute == route) {
                route.remove();
                return;
            }
            route = route.next();
        }
    }

    public Node findNode(NodeType type) {
        RootNode rootNode = this.getRootNode();
        return rootNode.nextTraversalByType(type);
    }

    public Node findNode(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() <= 0) {
            return null;
        }
        RootNode rootNode = this.getRootNode();
        return rootNode.nextTraversalByName(name);
    }

    public Node findNode(NodeType type, String name) {
        if (name == null) {
            return null;
        }
        if (name.length() <= 0) {
            return null;
        }
        Node node = this.findNode(type);
        while (node != null) {
            String nodeName = node.getName();
            if (nodeName != null && name.equals(nodeName)) {
                return node;
            }
            node = node.nextTraversalSameType();
        }
        return null;
    }

    public GroupingNode getGroupingNodes() {
        Node node = this.getNodes();
        while (node != null) {
            if (node.isGroupingNode()) {
                return (GroupingNode)node;
            }
            node = node.next();
        }
        return null;
    }

    public AnchorNode getAnchorNodes() {
        return (AnchorNode)this.getNodes(NodeType.ANCHOR);
    }

    public AppearanceNode getAppearanceNodes() {
        return (AppearanceNode)this.getNodes(NodeType.APPEARANCE);
    }

    public AudioClipNode getAudioClipNodes() {
        return (AudioClipNode)this.getNodes(NodeType.AUDIOCLIP);
    }

    public BackgroundNode getBackgroundNodes() {
        return (BackgroundNode)this.getNodes(NodeType.BACKGROUND);
    }

    public BillboardNode getBillboardNodes() {
        return (BillboardNode)this.getNodes(NodeType.BILLBOARD);
    }

    public BoxNode getBoxNodes() {
        return (BoxNode)this.getNodes(NodeType.BOX);
    }

    public CollisionNode getCollisionNodes() {
        return (CollisionNode)this.getNodes(NodeType.COLLISION);
    }

    public ColorNode getColorNodes() {
        return (ColorNode)this.getNodes(NodeType.COLOR);
    }

    public ColorInterpolatorNode getColorInterpolatorNodes() {
        return (ColorInterpolatorNode)this.getNodes(NodeType.COLORINTERP);
    }

    public ConeNode getConeNodes() {
        return (ConeNode)this.getNodes(NodeType.CONE);
    }

    public CoordinateNode getCoordinateNodes() {
        return (CoordinateNode)this.getNodes(NodeType.COORD);
    }

    public CoordinateInterpolatorNode getCoordinateInterpolatorNodes() {
        return (CoordinateInterpolatorNode)this.getNodes(NodeType.COORDINTERP);
    }

    public CylinderNode getCylinderNodes() {
        return (CylinderNode)this.getNodes(NodeType.CYLINDER);
    }

    public CylinderSensorNode getCylinderSensorNodes() {
        return (CylinderSensorNode)this.getNodes(NodeType.CYLINDERSENSOR);
    }

    public DirectionalLightNode getDirectionalLightNodes() {
        return (DirectionalLightNode)this.getNodes(NodeType.DIRLIGHT);
    }

    public ElevationGridNode getElevationGridNodes() {
        return (ElevationGridNode)this.getNodes(NodeType.ELEVATIONGRID);
    }

    public ExtrusionNode getExtrusionNodes() {
        return (ExtrusionNode)this.getNodes(NodeType.EXTRUSION);
    }

    public FogNode getFogNodes() {
        return (FogNode)this.getNodes(NodeType.FOG);
    }

    public FontStyleNode getFontStyleNodes() {
        return (FontStyleNode)this.getNodes(NodeType.FONTSTYLE);
    }

    public GroupNode getGroupNodes() {
        return (GroupNode)this.getNodes(NodeType.GROUP);
    }

    public ImageTextureNode getImageTextureNodes() {
        return (ImageTextureNode)this.getNodes(NodeType.IMAGETEXTURE);
    }

    public IndexedFaceSetNode getIndexedFaceSetNodes() {
        return (IndexedFaceSetNode)this.getNodes(NodeType.INDEXEDFACESET);
    }

    public IndexedLineSetNode getIndexedLineSetNodes() {
        return (IndexedLineSetNode)this.getNodes(NodeType.INDEXEDLINESET);
    }

    public InlineNode getInlineNodes() {
        return (InlineNode)this.getNodes(NodeType.INLINE);
    }

    public LODNode getLODNodes() {
        return (LODNode)this.getNodes(NodeType.LOD);
    }

    public MaterialNode getMaterialNodes() {
        return (MaterialNode)this.getNodes(NodeType.MATERIAL);
    }

    public MovieTextureNode getMovieTextureNodes() {
        return (MovieTextureNode)this.getNodes(NodeType.MOVIETEXTURE);
    }

    public NavigationInfoNode getNavigationInfoNodes() {
        return (NavigationInfoNode)this.getNodes(NodeType.NAVIGATIONINFO);
    }

    public NormalNode getNormalNodes() {
        return (NormalNode)this.getNodes(NodeType.NORMAL);
    }

    public NormalInterpolatorNode getNormalInterpolatorNodes() {
        return (NormalInterpolatorNode)this.getNodes(NodeType.NORMALINTERP);
    }

    public OrientationInterpolatorNode getOrientationInterpolatorNodes() {
        return (OrientationInterpolatorNode)this.getNodes(NodeType.ORIENTATIONINTERP);
    }

    public PixelTextureNode getPixelTextureNodes() {
        return (PixelTextureNode)this.getNodes(NodeType.PIXELTEXTURE);
    }

    public PlaneSensorNode getPlaneSensorNodes() {
        return (PlaneSensorNode)this.getNodes(NodeType.PLANESENSOR);
    }

    public PointLightNode getPointLightNodes() {
        return (PointLightNode)this.getNodes(NodeType.POINTLIGHT);
    }

    public PointSetNode getPointSetNodes() {
        return (PointSetNode)this.getNodes(NodeType.POINTSET);
    }

    public PositionInterpolatorNode getPositionInterpolatorNodes() {
        return (PositionInterpolatorNode)this.getNodes(NodeType.POSITONINTERP);
    }

    public ProximitySensorNode getProximitySensorNodes() {
        return (ProximitySensorNode)this.getNodes(NodeType.PROXIMITYSENSOR);
    }

    public ProxyNode getProxyNodeNodes() {
        return (ProxyNode)this.getNodes(NodeType.PROXY);
    }

    public ScalarInterpolatorNode getScalarInterpolatorNodes() {
        return (ScalarInterpolatorNode)this.getNodes(NodeType.SCALARINTERP);
    }

    public ScriptNode getScriptNodes() {
        return (ScriptNode)this.getNodes(NodeType.SCRIPT);
    }

    public ShapeNode getShapeNodes() {
        return (ShapeNode)this.getNodes(NodeType.SHAPE);
    }

    public SoundNode getSoundNodes() {
        return (SoundNode)this.getNodes(NodeType.SOUND);
    }

    public SphereNode getSphereNodes() {
        return (SphereNode)this.getNodes(NodeType.SPHERE);
    }

    public SphereSensorNode getSphereSensorNodes() {
        return (SphereSensorNode)this.getNodes(NodeType.SPHERESENSOR);
    }

    public SpotLightNode getSpotLightNodes() {
        return (SpotLightNode)this.getNodes(NodeType.SPOTLIGHT);
    }

    public SwitchNode getSwitchNodes() {
        return (SwitchNode)this.getNodes(NodeType.SWITCH);
    }

    public TextNode getTextNodes() {
        return (TextNode)this.getNodes(NodeType.TEXT);
    }

    public TextureCoordinateNode getTextureCoordinateNodes() {
        return (TextureCoordinateNode)this.getNodes(NodeType.TEXTURECOORD);
    }

    public TextureTransformNode getTextureTransformNodes() {
        return (TextureTransformNode)this.getNodes(NodeType.TEXTURETRANSFORM);
    }

    public TimeSensorNode getTimeSensorNodes() {
        return (TimeSensorNode)this.getNodes(NodeType.TIMESENSOR);
    }

    public TouchSensorNode getTouchSensorNodes() {
        return (TouchSensorNode)this.getNodes(NodeType.TOUCHSENSOR);
    }

    public TransformNode getTransformNodes() {
        return (TransformNode)this.getNodes(NodeType.TRANSFORM);
    }

    public ViewpointNode getViewpointNodes() {
        return (ViewpointNode)this.getNodes(NodeType.VIEWPOINT);
    }

    public VisibilitySensorNode getVisibilitySensorNodes() {
        return (VisibilitySensorNode)this.getNodes(NodeType.VISIBILITYSENSOR);
    }

    public WorldInfoNode getWorldInfoNodes() {
        return (WorldInfoNode)this.getNodes(NodeType.WORLDINFO);
    }

    public LoadSensorNode getLoadSensorNodes() {
        return (LoadSensorNode)this.getNodes(NodeType.LOADSENSOR);
    }

    public StaticGroupNode getStaticGroupNodes() {
        return (StaticGroupNode)this.getNodes(NodeType.STATICGROUP);
    }

    public ColorRGBANode getColorRGBANodes() {
        return (ColorRGBANode)this.getNodes(NodeType.COLORRGBA);
    }

    public TriangleSetNode getTriangleSetNodes() {
        return (TriangleSetNode)this.getNodes(NodeType.TRIANGLESET);
    }

    public TriangleFanSetNode getTriangleFanSetNodes() {
        return (TriangleFanSetNode)this.getNodes(NodeType.TRIANGLEFANSET);
    }

    public TriangleStripSetNode getTriangleStripSetNodes() {
        return (TriangleStripSetNode)this.getNodes(NodeType.TRIANGLESTRIPSET);
    }

    public FillPropertiesNode getFillPropertiesNodes() {
        return (FillPropertiesNode)this.getNodes(NodeType.FILLPROPERTIES);
    }

    public LinePropertiesNode getLinePropertiesNodes() {
        return (LinePropertiesNode)this.getNodes(NodeType.LINEPROPERTIES);
    }

    public Arc2DNode getArc2DNodes() {
        return (Arc2DNode)this.getNodes(NodeType.ARC2D);
    }

    public ArcClose2DNode getArcClose2DNodes() {
        return (ArcClose2DNode)this.getNodes(NodeType.ARCCLOSE2D);
    }

    public Circle2DNode getCircle2DNodes() {
        return (Circle2DNode)this.getNodes(NodeType.CIRCLE2D);
    }

    public Disk2DNode getDisk2DNodes() {
        return (Disk2DNode)this.getNodes(NodeType.DISK2D);
    }

    public Polyline2DNode getPolyline2DNodes() {
        return (Polyline2DNode)this.getNodes(NodeType.POLYLINE2D);
    }

    public Polypoint2DNode getPolypoint2DNodes() {
        return (Polypoint2DNode)this.getNodes(NodeType.POLYPOINT2D);
    }

    public Rectangle2DNode getRectangle2DNodes() {
        return (Rectangle2DNode)this.getNodes(NodeType.RECTANGLE2D);
    }

    public TriangleSet2DNode getTriangleSet2DNodes() {
        return (TriangleSet2DNode)this.getNodes(NodeType.TRIANGLESET2D);
    }

    public MultiTextureNode getMultiTextureNodes() {
        return (MultiTextureNode)this.getNodes(NodeType.MULTITEXTURE);
    }

    public MultiTextureCoordinateNode getMultiTextureCoordinateNodes() {
        return (MultiTextureCoordinateNode)this.getNodes(NodeType.MULTITEXTURECOORD);
    }

    public MultiTextureTransformNode getMultiTextureTransformNodes() {
        return (MultiTextureTransformNode)this.getNodes(NodeType.MULTITEXTURETRANSFORM);
    }

    public TextureCoordinateGeneratorNode getTextureCoordinateGeneratorNodes() {
        return (TextureCoordinateGeneratorNode)this.getNodes(NodeType.TEXCOORDGEN);
    }

    public CoordinateInterpolator2DNode getCoordinateInterpolator2DNodes() {
        return (CoordinateInterpolator2DNode)this.getNodes(NodeType.COORDINATEINTERPOLATOR2D);
    }

    public PositionInterpolator2DNode getPositionInterpolator2DNodes() {
        return (PositionInterpolator2DNode)this.getNodes(NodeType.POSITIONINTERPOLATOR2D);
    }

    public KeySensorNode getKeySensorNodes() {
        return (KeySensorNode)this.getNodes(NodeType.KEYSENSOR);
    }

    public StringSensorNode getStringSensorNodes() {
        return (StringSensorNode)this.getNodes(NodeType.STRINGSENSOR);
    }

    public BooleanFilterNode getBooleanFilterNodes() {
        return (BooleanFilterNode)this.getNodes(NodeType.BOOLEANFILTER);
    }

    public BooleanToggleNode getBooleanToggleNodes() {
        return (BooleanToggleNode)this.getNodes(NodeType.BOOLEANTOGGLE);
    }

    public BooleanTriggerNode getBooleanTriggerNodes() {
        return (BooleanTriggerNode)this.getNodes(NodeType.BOOLEANTRIGGER);
    }

    public BooleanSequencerNode getBooleanSequencerNodes() {
        return (BooleanSequencerNode)this.getNodes(NodeType.BOOLEANSEQUENCER);
    }

    public IntegerTriggerNode getIntegerTriggerNodes() {
        return (IntegerTriggerNode)this.getNodes(NodeType.INTEGERTRIGGER);
    }

    public IntegerSequencerNode getIntegerSequencerNodes() {
        return (IntegerSequencerNode)this.getNodes(NodeType.INTEGERSEQUENCER);
    }

    public TimeTriggerNode getTimeTriggerNodes() {
        return (TimeTriggerNode)this.getNodes(NodeType.TIMETRIGGER);
    }

    public NodeSequencerNode getNodeSequencerNodes() {
        return (NodeSequencerNode)this.getNodes(NodeType.NODESEQUENCER);
    }

    public Shape2DNode getShape2DNodes() {
        return (Shape2DNode)this.getNodes(NodeType.SHAPE2D);
    }

    public BooleanTimeTriggerNode getBooleanTimeTriggerNodes() {
        return (BooleanTimeTriggerNode)this.getNodes(NodeType.BOOLEANTIMETRIGGER);
    }

    public Transform2DNode getTransform2DNodes() {
        return (Transform2DNode)this.getNodes(NodeType.TRANSFORM2D);
    }

    public GroupingNode findGroupingNode() {
        Node node = this.getRootNode().nextTraversal();
        while (node != null) {
            if (node.isGroupingNode()) {
                return (GroupingNode)node;
            }
            node = node.nextTraversal();
        }
        return null;
    }

    public LightNode findLightNode() {
        Node node = this.getRootNode().nextTraversal();
        while (node != null) {
            if (node.isLightNode()) {
                return (LightNode)node;
            }
            node = node.nextTraversal();
        }
        return null;
    }

    public Geometry3DNode findGeometry3DNode() {
        Node node = this.getRootNode().nextTraversal();
        while (node != null) {
            if (node.isGeometry3DNode()) {
                return (Geometry3DNode)node;
            }
            node = node.nextTraversal();
        }
        return null;
    }

    public InterpolatorNode findInterpolatorNode() {
        Node node = this.getRootNode().nextTraversal();
        while (node != null) {
            if (node.isInterpolatorNode()) {
                return (InterpolatorNode)node;
            }
            node = node.nextTraversal();
        }
        return null;
    }

    public AnchorNode findAnchorNode() {
        return (AnchorNode)this.findNode(NodeType.ANCHOR);
    }

    public AppearanceNode findAppearanceNode() {
        return (AppearanceNode)this.findNode(NodeType.APPEARANCE);
    }

    public AudioClipNode findAudioClipNode() {
        return (AudioClipNode)this.findNode(NodeType.AUDIOCLIP);
    }

    public BackgroundNode findBackgroundNode() {
        return (BackgroundNode)this.findNode(NodeType.BACKGROUND);
    }

    public BillboardNode findBillboardNode() {
        return (BillboardNode)this.findNode(NodeType.BILLBOARD);
    }

    public BoxNode findBoxNode() {
        return (BoxNode)this.findNode(NodeType.BOX);
    }

    public CollisionNode findCollisionNode() {
        return (CollisionNode)this.findNode(NodeType.COLLISION);
    }

    public ColorNode findColorNode() {
        return (ColorNode)this.findNode(NodeType.COLOR);
    }

    public ColorInterpolatorNode findColorInterpolatorNode() {
        return (ColorInterpolatorNode)this.findNode(NodeType.COLORINTERP);
    }

    public ConeNode findConeNode() {
        return (ConeNode)this.findNode(NodeType.CONE);
    }

    public CoordinateNode findCoordinateNode() {
        return (CoordinateNode)this.findNode(NodeType.COORD);
    }

    public CoordinateInterpolatorNode findCoordinateInterpolatorNode() {
        return (CoordinateInterpolatorNode)this.findNode(NodeType.COORDINTERP);
    }

    public CylinderNode findCylinderNode() {
        return (CylinderNode)this.findNode(NodeType.CYLINDER);
    }

    public CylinderSensorNode findCylinderSensorNode() {
        return (CylinderSensorNode)this.findNode(NodeType.CYLINDERSENSOR);
    }

    public DirectionalLightNode findDirectionalLightNode() {
        return (DirectionalLightNode)this.findNode(NodeType.DIRLIGHT);
    }

    public ElevationGridNode findElevationGridNode() {
        return (ElevationGridNode)this.findNode(NodeType.ELEVATIONGRID);
    }

    public ExtrusionNode findExtrusionNode() {
        return (ExtrusionNode)this.findNode(NodeType.EXTRUSION);
    }

    public FogNode findFogNode() {
        return (FogNode)this.findNode(NodeType.FOG);
    }

    public FontStyleNode findFontStyleNode() {
        return (FontStyleNode)this.findNode(NodeType.FONTSTYLE);
    }

    public GroupNode findGroupNode() {
        return (GroupNode)this.findNode(NodeType.GROUP);
    }

    public ImageTextureNode findImageTextureNode() {
        return (ImageTextureNode)this.findNode(NodeType.IMAGETEXTURE);
    }

    public IndexedFaceSetNode findIndexedFaceSetNode() {
        return (IndexedFaceSetNode)this.findNode(NodeType.INDEXEDFACESET);
    }

    public IndexedLineSetNode findIndexedLineSetNode() {
        return (IndexedLineSetNode)this.findNode(NodeType.INDEXEDLINESET);
    }

    public InlineNode findInlineNode() {
        return (InlineNode)this.findNode(NodeType.INLINE);
    }

    public LODNode findLODNode() {
        return (LODNode)this.findNode(NodeType.LOD);
    }

    public MaterialNode findMaterialNode() {
        return (MaterialNode)this.findNode(NodeType.MATERIAL);
    }

    public MovieTextureNode findMovieTextureNode() {
        return (MovieTextureNode)this.findNode(NodeType.MOVIETEXTURE);
    }

    public NavigationInfoNode findNavigationInfoNode() {
        return (NavigationInfoNode)this.findNode(NodeType.NAVIGATIONINFO);
    }

    public NormalNode findNormalNode() {
        return (NormalNode)this.findNode(NodeType.NORMAL);
    }

    public NormalInterpolatorNode findNormalInterpolatorNode() {
        return (NormalInterpolatorNode)this.findNode(NodeType.NORMALINTERP);
    }

    public OrientationInterpolatorNode findOrientationInterpolatorNode() {
        return (OrientationInterpolatorNode)this.findNode(NodeType.ORIENTATIONINTERP);
    }

    public PixelTextureNode findPixelTextureNode() {
        return (PixelTextureNode)this.findNode(NodeType.PIXELTEXTURE);
    }

    public PlaneSensorNode findPlaneSensorNode() {
        return (PlaneSensorNode)this.findNode(NodeType.PLANESENSOR);
    }

    public PointLightNode findPointLightNode() {
        return (PointLightNode)this.findNode(NodeType.POINTLIGHT);
    }

    public PointSetNode findPointSetNode() {
        return (PointSetNode)this.findNode(NodeType.POINTSET);
    }

    public PositionInterpolatorNode findPositionInterpolatorNode() {
        return (PositionInterpolatorNode)this.findNode(NodeType.POSITONINTERP);
    }

    public ProximitySensorNode findProximitySensorNode() {
        return (ProximitySensorNode)this.findNode(NodeType.PROXIMITYSENSOR);
    }

    public ProxyNode findProxyNode() {
        return (ProxyNode)this.findNode(NodeType.PROXY);
    }

    public ScalarInterpolatorNode findScalarInterpolatorNode() {
        return (ScalarInterpolatorNode)this.findNode(NodeType.SCALARINTERP);
    }

    public ScriptNode findScriptNode() {
        return (ScriptNode)this.findNode(NodeType.SCRIPT);
    }

    public ShapeNode findShapeNode() {
        return (ShapeNode)this.findNode(NodeType.SHAPE);
    }

    public SoundNode findSoundNode() {
        return (SoundNode)this.findNode(NodeType.SOUND);
    }

    public SphereNode findSphereNode() {
        return (SphereNode)this.findNode(NodeType.SPHERE);
    }

    public SphereSensorNode findSphereSensorNode() {
        return (SphereSensorNode)this.findNode(NodeType.SPHERESENSOR);
    }

    public SpotLightNode findSpotLightNode() {
        return (SpotLightNode)this.findNode(NodeType.SPOTLIGHT);
    }

    public SwitchNode findSwitchNode() {
        return (SwitchNode)this.findNode(NodeType.SWITCH);
    }

    public TextNode findTextNode() {
        return (TextNode)this.findNode(NodeType.TEXT);
    }

    public TextureCoordinateNode findTextureCoordinateNode() {
        return (TextureCoordinateNode)this.findNode(NodeType.TEXTURECOORD);
    }

    public TextureTransformNode findTextureTransformNode() {
        return (TextureTransformNode)this.findNode(NodeType.TEXTURETRANSFORM);
    }

    public TimeSensorNode findTimeSensorNode() {
        return (TimeSensorNode)this.findNode(NodeType.TIMESENSOR);
    }

    public TouchSensorNode findTouchSensorNode() {
        return (TouchSensorNode)this.findNode(NodeType.TOUCHSENSOR);
    }

    public TransformNode findTransformNode() {
        return (TransformNode)this.findNode(NodeType.TRANSFORM);
    }

    public ViewpointNode findViewpointNode() {
        return (ViewpointNode)this.findNode(NodeType.VIEWPOINT);
    }

    public VisibilitySensorNode findVisibilitySensorNode() {
        return (VisibilitySensorNode)this.findNode(NodeType.VISIBILITYSENSOR);
    }

    public WorldInfoNode findWorldInfoNode() {
        return (WorldInfoNode)this.findNode(NodeType.WORLDINFO);
    }

    public SceneNode findSceneNode() {
        return (SceneNode)this.findNode(NodeType.SCENE);
    }

    public LoadSensorNode findLoadSensorNode() {
        return (LoadSensorNode)this.findNode(NodeType.LOADSENSOR);
    }

    public StaticGroupNode findStaticGroupNode() {
        return (StaticGroupNode)this.findNode(NodeType.STATICGROUP);
    }

    public ColorRGBANode findColorRGBANode() {
        return (ColorRGBANode)this.findNode(NodeType.COLORRGBA);
    }

    public TriangleSetNode findTriangleSetNode() {
        return (TriangleSetNode)this.findNode(NodeType.TRIANGLESET);
    }

    public TriangleFanSetNode findTriangleFanSetNode() {
        return (TriangleFanSetNode)this.findNode(NodeType.TRIANGLEFANSET);
    }

    public TriangleStripSetNode findTriangleStripSetNode() {
        return (TriangleStripSetNode)this.findNode(NodeType.TRIANGLESTRIPSET);
    }

    public FillPropertiesNode findFillPropertiesNode() {
        return (FillPropertiesNode)this.findNode(NodeType.FILLPROPERTIES);
    }

    public LinePropertiesNode findLinePropertiesNode() {
        return (LinePropertiesNode)this.findNode(NodeType.LINEPROPERTIES);
    }

    public Arc2DNode findArc2DNode() {
        return (Arc2DNode)this.findNode(NodeType.ARC2D);
    }

    public ArcClose2DNode findArcClose2DNode() {
        return (ArcClose2DNode)this.findNode(NodeType.ARCCLOSE2D);
    }

    public Circle2DNode findCircle2DNode() {
        return (Circle2DNode)this.findNode(NodeType.CIRCLE2D);
    }

    public Disk2DNode findDisk2DNode() {
        return (Disk2DNode)this.findNode(NodeType.DISK2D);
    }

    public Polyline2DNode findPolyline2DNode() {
        return (Polyline2DNode)this.findNode(NodeType.POLYLINE2D);
    }

    public Polypoint2DNode findPolypoint2DNode() {
        return (Polypoint2DNode)this.findNode(NodeType.POLYPOINT2D);
    }

    public Rectangle2DNode findRectangle2DNode() {
        return (Rectangle2DNode)this.findNode(NodeType.RECTANGLE2D);
    }

    public TriangleSet2DNode findTriangleSet2DNode() {
        return (TriangleSet2DNode)this.findNode(NodeType.TRIANGLESET2D);
    }

    public MultiTextureNode findMultiTextureNode() {
        return (MultiTextureNode)this.findNode(NodeType.MULTITEXTURE);
    }

    public MultiTextureCoordinateNode findMultiTextureCoordinateNode() {
        return (MultiTextureCoordinateNode)this.findNode(NodeType.MULTITEXTURECOORD);
    }

    public MultiTextureTransformNode findMultiTextureTransformNode() {
        return (MultiTextureTransformNode)this.findNode(NodeType.MULTITEXTURETRANSFORM);
    }

    public TextureCoordinateGeneratorNode findTextureCoordinateGeneratorNode() {
        return (TextureCoordinateGeneratorNode)this.findNode(NodeType.TEXCOORDGEN);
    }

    public CoordinateInterpolator2DNode findCoordinateInterpolator2DNode() {
        return (CoordinateInterpolator2DNode)this.findNode(NodeType.COORDINATEINTERPOLATOR2D);
    }

    public PositionInterpolator2DNode findPositionInterpolator2DNode() {
        return (PositionInterpolator2DNode)this.findNode(NodeType.POSITIONINTERPOLATOR2D);
    }

    public KeySensorNode findKeySensorNode() {
        return (KeySensorNode)this.findNode(NodeType.KEYSENSOR);
    }

    public StringSensorNode findStringSensorNode() {
        return (StringSensorNode)this.findNode(NodeType.STRINGSENSOR);
    }

    public BooleanFilterNode findBooleanFilterNode() {
        return (BooleanFilterNode)this.findNode(NodeType.BOOLEANFILTER);
    }

    public BooleanToggleNode findBooleanToggleNode() {
        return (BooleanToggleNode)this.findNode(NodeType.BOOLEANTOGGLE);
    }

    public BooleanTriggerNode findBooleanTriggerNode() {
        return (BooleanTriggerNode)this.findNode(NodeType.BOOLEANTRIGGER);
    }

    public BooleanSequencerNode findBooleanSequencerNode() {
        return (BooleanSequencerNode)this.findNode(NodeType.BOOLEANSEQUENCER);
    }

    public IntegerTriggerNode findIntegerTriggerNode() {
        return (IntegerTriggerNode)this.findNode(NodeType.INTEGERTRIGGER);
    }

    public IntegerSequencerNode findIntegerSequencerNode() {
        return (IntegerSequencerNode)this.findNode(NodeType.INTEGERSEQUENCER);
    }

    public TimeTriggerNode findTimeTriggerNode() {
        return (TimeTriggerNode)this.findNode(NodeType.TIMETRIGGER);
    }

    public NodeSequencerNode findNodeSequencerNode() {
        return (NodeSequencerNode)this.findNode(NodeType.NODESEQUENCER);
    }

    public Shape2DNode findShape2DNode() {
        return (Shape2DNode)this.findNode(NodeType.SHAPE2D);
    }

    public BooleanTimeTriggerNode findBooleanTimeTriggerNode() {
        return (BooleanTimeTriggerNode)this.findNode(NodeType.BOOLEANTIMETRIGGER);
    }

    public Transform2DNode findTransform2DNode() {
        return (Transform2DNode)this.findNode(NodeType.TRANSFORM2D);
    }

    public GroupingNode findGroupingNode(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() <= 0) {
            return null;
        }
        Node node = this.findGroupingNode();
        while (node != null) {
            String nodeName;
            if (node.isGroupingNode() && (nodeName = node.getName()) != null && name.equals(nodeName)) {
                return node;
            }
            node = node.nextTraversal();
        }
        return null;
    }

    public LightNode findLightNode(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() <= 0) {
            return null;
        }
        Node node = this.findLightNode();
        while (node != null) {
            String nodeName;
            if (node.isLightNode() && (nodeName = node.getName()) != null && name.equals(nodeName)) {
                return node;
            }
            node = node.nextTraversal();
        }
        return null;
    }

    public Geometry3DNode findGeometry3DNode(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() <= 0) {
            return null;
        }
        Node node = this.findGeometry3DNode();
        while (node != null) {
            String nodeName;
            if (node.isGeometry3DNode() && (nodeName = node.getName()) != null && name.equals(nodeName)) {
                return node;
            }
            node = node.nextTraversal();
        }
        return null;
    }

    public InterpolatorNode findInterpolatorNode(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() <= 0) {
            return null;
        }
        Node node = this.findInterpolatorNode();
        while (node != null) {
            String nodeName;
            if (node.isInterpolatorNode() && (nodeName = node.getName()) != null && name.equals(nodeName)) {
                return node;
            }
            node = node.nextTraversal();
        }
        return null;
    }

    public AnchorNode findAnchorNode(String name) {
        return (AnchorNode)this.findNode(NodeType.ANCHOR, name);
    }

    public AppearanceNode findAppearanceNode(String name) {
        return (AppearanceNode)this.findNode(NodeType.APPEARANCE, name);
    }

    public AudioClipNode findAudioClipNode(String name) {
        return (AudioClipNode)this.findNode(NodeType.AUDIOCLIP, name);
    }

    public BackgroundNode findBackgroundNode(String name) {
        return (BackgroundNode)this.findNode(NodeType.BACKGROUND, name);
    }

    public BillboardNode findBillboardNode(String name) {
        return (BillboardNode)this.findNode(NodeType.BILLBOARD, name);
    }

    public BoxNode findBoxNode(String name) {
        return (BoxNode)this.findNode(NodeType.BOX, name);
    }

    public CollisionNode findCollisionNode(String name) {
        return (CollisionNode)this.findNode(NodeType.COLLISION, name);
    }

    public ColorNode findColorNode(String name) {
        return (ColorNode)this.findNode(NodeType.COLOR, name);
    }

    public ColorInterpolatorNode findColorInterpolatorNode(String name) {
        return (ColorInterpolatorNode)this.findNode(NodeType.COLORINTERP, name);
    }

    public ConeNode findConeNode(String name) {
        return (ConeNode)this.findNode(NodeType.CONE, name);
    }

    public CoordinateNode findCoordinateNode(String name) {
        return (CoordinateNode)this.findNode(NodeType.COORD, name);
    }

    public CoordinateInterpolatorNode findCoordinateInterpolatorNode(String name) {
        return (CoordinateInterpolatorNode)this.findNode(NodeType.COORDINTERP, name);
    }

    public CylinderNode findCylinderNode(String name) {
        return (CylinderNode)this.findNode(NodeType.CYLINDER, name);
    }

    public CylinderSensorNode findCylinderSensorNode(String name) {
        return (CylinderSensorNode)this.findNode(NodeType.CYLINDERSENSOR, name);
    }

    public DirectionalLightNode findDirectionalLightNode(String name) {
        return (DirectionalLightNode)this.findNode(NodeType.DIRLIGHT, name);
    }

    public ElevationGridNode findElevationGridNode(String name) {
        return (ElevationGridNode)this.findNode(NodeType.ELEVATIONGRID, name);
    }

    public ExtrusionNode findExtrusionNode(String name) {
        return (ExtrusionNode)this.findNode(NodeType.EXTRUSION, name);
    }

    public FogNode findFogNode(String name) {
        return (FogNode)this.findNode(NodeType.FOG, name);
    }

    public FontStyleNode findFontStyleNode(String name) {
        return (FontStyleNode)this.findNode(NodeType.FONTSTYLE, name);
    }

    public GroupNode findGroupNode(String name) {
        return (GroupNode)this.findNode(NodeType.GROUP, name);
    }

    public ImageTextureNode findImageTextureNode(String name) {
        return (ImageTextureNode)this.findNode(NodeType.IMAGETEXTURE, name);
    }

    public IndexedFaceSetNode findIndexedFaceSetNode(String name) {
        return (IndexedFaceSetNode)this.findNode(NodeType.INDEXEDFACESET, name);
    }

    public IndexedLineSetNode findIndexedLineSetNode(String name) {
        return (IndexedLineSetNode)this.findNode(NodeType.INDEXEDLINESET, name);
    }

    public InlineNode findInlineNode(String name) {
        return (InlineNode)this.findNode(NodeType.INLINE, name);
    }

    public LODNode findLODNode(String name) {
        return (LODNode)this.findNode(NodeType.LOD, name);
    }

    public MaterialNode findMaterialNode(String name) {
        return (MaterialNode)this.findNode(NodeType.MATERIAL, name);
    }

    public MovieTextureNode findMovieTextureNode(String name) {
        return (MovieTextureNode)this.findNode(NodeType.MOVIETEXTURE, name);
    }

    public NavigationInfoNode findNavigationInfoNode(String name) {
        return (NavigationInfoNode)this.findNode(NodeType.NAVIGATIONINFO, name);
    }

    public NormalNode findNormalNode(String name) {
        return (NormalNode)this.findNode(NodeType.NORMAL, name);
    }

    public NormalInterpolatorNode findNormalInterpolatorNode(String name) {
        return (NormalInterpolatorNode)this.findNode(NodeType.NORMALINTERP, name);
    }

    public OrientationInterpolatorNode findOrientationInterpolatorNode(String name) {
        return (OrientationInterpolatorNode)this.findNode(NodeType.ORIENTATIONINTERP, name);
    }

    public PixelTextureNode findPixelTextureNode(String name) {
        return (PixelTextureNode)this.findNode(NodeType.PIXELTEXTURE, name);
    }

    public PlaneSensorNode findPlaneSensorNode(String name) {
        return (PlaneSensorNode)this.findNode(NodeType.PLANESENSOR, name);
    }

    public PointLightNode findPointLightNode(String name) {
        return (PointLightNode)this.findNode(NodeType.POINTLIGHT, name);
    }

    public PointSetNode findPointSetNode(String name) {
        return (PointSetNode)this.findNode(NodeType.POINTSET, name);
    }

    public PositionInterpolatorNode findPositionInterpolatorNode(String name) {
        return (PositionInterpolatorNode)this.findNode(NodeType.POSITONINTERP, name);
    }

    public ProximitySensorNode findProximitySensorNode(String name) {
        return (ProximitySensorNode)this.findNode(NodeType.PROXIMITYSENSOR, name);
    }

    public ProxyNode findProxyNode(String name) {
        return (ProxyNode)this.findNode(NodeType.PROXY, name);
    }

    public ScalarInterpolatorNode findScalarInterpolatorNode(String name) {
        return (ScalarInterpolatorNode)this.findNode(NodeType.SCALARINTERP, name);
    }

    public ScriptNode findScriptNode(String name) {
        return (ScriptNode)this.findNode(NodeType.SCRIPT, name);
    }

    public ShapeNode findShapeNode(String name) {
        return (ShapeNode)this.findNode(NodeType.SHAPE, name);
    }

    public SoundNode findSoundNode(String name) {
        return (SoundNode)this.findNode(NodeType.SOUND, name);
    }

    public SphereNode findSphereNode(String name) {
        return (SphereNode)this.findNode(NodeType.SPHERE, name);
    }

    public SphereSensorNode findSphereSensorNode(String name) {
        return (SphereSensorNode)this.findNode(NodeType.SPHERESENSOR, name);
    }

    public SpotLightNode findSpotLightNode(String name) {
        return (SpotLightNode)this.findNode(NodeType.SPOTLIGHT, name);
    }

    public SwitchNode findSwitchNode(String name) {
        return (SwitchNode)this.findNode(NodeType.SWITCH, name);
    }

    public TextNode findTextNode(String name) {
        return (TextNode)this.findNode(NodeType.TEXT, name);
    }

    public TextureCoordinateNode findTextureCoordinateNode(String name) {
        return (TextureCoordinateNode)this.findNode(NodeType.TEXTURECOORD, name);
    }

    public TextureTransformNode findTextureTransformNode(String name) {
        return (TextureTransformNode)this.findNode(NodeType.TEXTURETRANSFORM, name);
    }

    public TimeSensorNode findTimeSensorNode(String name) {
        return (TimeSensorNode)this.findNode(NodeType.TIMESENSOR, name);
    }

    public TouchSensorNode findTouchSensorNode(String name) {
        return (TouchSensorNode)this.findNode(NodeType.TOUCHSENSOR, name);
    }

    public TransformNode findTransformNode(String name) {
        return (TransformNode)this.findNode(NodeType.TRANSFORM, name);
    }

    public ViewpointNode findViewpointNode(String name) {
        return (ViewpointNode)this.findNode(NodeType.VIEWPOINT, name);
    }

    public VisibilitySensorNode findVisibilitySensorNode(String name) {
        return (VisibilitySensorNode)this.findNode(NodeType.VISIBILITYSENSOR, name);
    }

    public WorldInfoNode findWorldInfoNode(String name) {
        return (WorldInfoNode)this.findNode(NodeType.WORLDINFO, name);
    }

    public LoadSensorNode findLoadSensorNode(String name) {
        return (LoadSensorNode)this.findNode(NodeType.LOADSENSOR, name);
    }

    public StaticGroupNode findStaticGroupNode(String name) {
        return (StaticGroupNode)this.findNode(NodeType.STATICGROUP, name);
    }

    public ColorRGBANode findColorRGBANode(String name) {
        return (ColorRGBANode)this.findNode(NodeType.COLORRGBA, name);
    }

    public TriangleSetNode findTriangleSetNode(String name) {
        return (TriangleSetNode)this.findNode(NodeType.TRIANGLESET, name);
    }

    public TriangleFanSetNode findTriangleFanSetNode(String name) {
        return (TriangleFanSetNode)this.findNode(NodeType.TRIANGLEFANSET, name);
    }

    public TriangleStripSetNode findTriangleStripSetNode(String name) {
        return (TriangleStripSetNode)this.findNode(NodeType.TRIANGLESTRIPSET, name);
    }

    public FillPropertiesNode findFillPropertiesNode(String name) {
        return (FillPropertiesNode)this.findNode(NodeType.FILLPROPERTIES, name);
    }

    public LinePropertiesNode findLinePropertiesNode(String name) {
        return (LinePropertiesNode)this.findNode(NodeType.LINEPROPERTIES, name);
    }

    public Arc2DNode findArc2DNode(String name) {
        return (Arc2DNode)this.findNode(NodeType.ARC2D, name);
    }

    public ArcClose2DNode findArcClose2DNode(String name) {
        return (ArcClose2DNode)this.findNode(NodeType.ARCCLOSE2D, name);
    }

    public Circle2DNode findCircle2DNode(String name) {
        return (Circle2DNode)this.findNode(NodeType.CIRCLE2D, name);
    }

    public Disk2DNode findDisk2DNode(String name) {
        return (Disk2DNode)this.findNode(NodeType.DISK2D, name);
    }

    public Polyline2DNode findPolyline2DNode(String name) {
        return (Polyline2DNode)this.findNode(NodeType.POLYLINE2D, name);
    }

    public Polypoint2DNode findPolypoint2DNode(String name) {
        return (Polypoint2DNode)this.findNode(NodeType.POLYPOINT2D, name);
    }

    public Rectangle2DNode findRectangle2DNode(String name) {
        return (Rectangle2DNode)this.findNode(NodeType.RECTANGLE2D, name);
    }

    public TriangleSet2DNode findTriangleSet2DNode(String name) {
        return (TriangleSet2DNode)this.findNode(NodeType.TRIANGLESET2D, name);
    }

    public MultiTextureNode findMultiTextureNode(String name) {
        return (MultiTextureNode)this.findNode(NodeType.MULTITEXTURE, name);
    }

    public MultiTextureCoordinateNode findMultiTextureCoordinateNode(String name) {
        return (MultiTextureCoordinateNode)this.findNode(NodeType.MULTITEXTURECOORD, name);
    }

    public MultiTextureTransformNode findMultiTextureTransformNode(String name) {
        return (MultiTextureTransformNode)this.findNode(NodeType.MULTITEXTURETRANSFORM, name);
    }

    public TextureCoordinateGeneratorNode findTextureCoordinateGeneratorNode(String name) {
        return (TextureCoordinateGeneratorNode)this.findNode(NodeType.TEXCOORDGEN, name);
    }

    public CoordinateInterpolator2DNode findCoordinateInterpolator2DNode(String name) {
        return (CoordinateInterpolator2DNode)this.findNode(NodeType.COORDINATEINTERPOLATOR2D, name);
    }

    public PositionInterpolator2DNode findPositionInterpolator2DNode(String name) {
        return (PositionInterpolator2DNode)this.findNode(NodeType.POSITIONINTERPOLATOR2D, name);
    }

    public KeySensorNode findKeySensorNode(String name) {
        return (KeySensorNode)this.findNode(NodeType.KEYSENSOR, name);
    }

    public StringSensorNode findStringSensorNode(String name) {
        return (StringSensorNode)this.findNode(NodeType.STRINGSENSOR, name);
    }

    public BooleanFilterNode findBooleanFilterNode(String name) {
        return (BooleanFilterNode)this.findNode(NodeType.BOOLEANFILTER, name);
    }

    public BooleanToggleNode findBooleanToggleNode(String name) {
        return (BooleanToggleNode)this.findNode(NodeType.BOOLEANTOGGLE, name);
    }

    public BooleanTriggerNode findBooleanTriggerNode(String name) {
        return (BooleanTriggerNode)this.findNode(NodeType.BOOLEANTRIGGER, name);
    }

    public BooleanSequencerNode findBooleanSequencerNode(String name) {
        return (BooleanSequencerNode)this.findNode(NodeType.BOOLEANSEQUENCER, name);
    }

    public IntegerTriggerNode findIntegerTriggerNode(String name) {
        return (IntegerTriggerNode)this.findNode(NodeType.INTEGERTRIGGER, name);
    }

    public IntegerSequencerNode findIntegerSequencerNode(String name) {
        return (IntegerSequencerNode)this.findNode(NodeType.INTEGERSEQUENCER, name);
    }

    public TimeTriggerNode findTimeTriggerNode(String name) {
        return (TimeTriggerNode)this.findNode(NodeType.TIMETRIGGER, name);
    }

    public NodeSequencerNode findNodeSequencerNode(String name) {
        return (NodeSequencerNode)this.findNode(NodeType.NODESEQUENCER, name);
    }

    public Shape2DNode findShape2DNode(String name) {
        return (Shape2DNode)this.findNode(NodeType.SHAPE2D, name);
    }

    public BooleanTimeTriggerNode findBooleanTimeTriggerNode(String name) {
        return (BooleanTimeTriggerNode)this.findNode(NodeType.BOOLEANTIMETRIGGER, name);
    }

    public Transform2DNode findTransform2DNode(String name) {
        return (Transform2DNode)this.findNode(NodeType.TRANSFORM2D);
    }

    public int getNAllNodes(NodeType nodeType) {
        int nNodes = 0;
        Node node = this.findNode(nodeType);
        while (node != null) {
            ++nNodes;
            node = node.nextTraversalSameType();
        }
        return nNodes;
    }

    public int getNAllGeometry3DNodes() {
        int nNodes = 0;
        Node node = this.getNodes();
        while (node != null) {
            if (node.isGeometry3DNode()) {
                ++nNodes;
            }
            node = node.nextTraversal();
        }
        return nNodes;
    }

    public int getNAllAnchorNodes() {
        return this.getNAllNodes(NodeType.ANCHOR);
    }

    public int getNAllAppearanceNodes() {
        return this.getNAllNodes(NodeType.APPEARANCE);
    }

    public int getNAllAudioClipNodes() {
        return this.getNAllNodes(NodeType.AUDIOCLIP);
    }

    public int getNAllBackgroundNodes() {
        return this.getNAllNodes(NodeType.BACKGROUND);
    }

    public int getNAllBillboardNodes() {
        return this.getNAllNodes(NodeType.BILLBOARD);
    }

    public int getNAllBoxNodes() {
        return this.getNAllNodes(NodeType.BOX);
    }

    public int getNAllCollisionNodes() {
        return this.getNAllNodes(NodeType.COLLISION);
    }

    public int getNAllColorNodes() {
        return this.getNAllNodes(NodeType.COLOR);
    }

    public int getNAllColorInterpolatorNodes() {
        return this.getNAllNodes(NodeType.COLORINTERP);
    }

    public int getNAllConeNodes() {
        return this.getNAllNodes(NodeType.CONE);
    }

    public int getNAllCoordinateNodes() {
        return this.getNAllNodes(NodeType.COORD);
    }

    public int getNAllCoordinateInterpolatorNodes() {
        return this.getNAllNodes(NodeType.COORDINTERP);
    }

    public int getNAllCylinderNodes() {
        return this.getNAllNodes(NodeType.CYLINDER);
    }

    public int getNAllCylinderSensorNodes() {
        return this.getNAllNodes(NodeType.CYLINDERSENSOR);
    }

    public int getNAllDirectionalLightNodes() {
        return this.getNAllNodes(NodeType.DIRLIGHT);
    }

    public int getNAllElevationGridNodes() {
        return this.getNAllNodes(NodeType.ELEVATIONGRID);
    }

    public int getNAllExtrusionNodes() {
        return this.getNAllNodes(NodeType.EXTRUSION);
    }

    public int getNAllFogNodes() {
        return this.getNAllNodes(NodeType.FOG);
    }

    public int getNAllFontStyleNodes() {
        return this.getNAllNodes(NodeType.FONTSTYLE);
    }

    public int getNAllGroupNodes() {
        return this.getNAllNodes(NodeType.GROUP);
    }

    public int getNAllImageTextureNodes() {
        return this.getNAllNodes(NodeType.IMAGETEXTURE);
    }

    public int getNAllIndexedFaceSetNodes() {
        return this.getNAllNodes(NodeType.INDEXEDFACESET);
    }

    public int getNAllIndexedLineSetNodes() {
        return this.getNAllNodes(NodeType.INDEXEDLINESET);
    }

    public int getNAllInlineNodes() {
        return this.getNAllNodes(NodeType.INLINE);
    }

    public int getNAllLODNodes() {
        return this.getNAllNodes(NodeType.LOD);
    }

    public int getNAllMaterialNodes() {
        return this.getNAllNodes(NodeType.MATERIAL);
    }

    public int getNAllMovieTextureNodes() {
        return this.getNAllNodes(NodeType.MOVIETEXTURE);
    }

    public int getNAllNavigationInfoNodes() {
        return this.getNAllNodes(NodeType.NAVIGATIONINFO);
    }

    public int getNAllNormalNodes() {
        return this.getNAllNodes(NodeType.NORMAL);
    }

    public int getNAllNormalInterpolatorNodes() {
        return this.getNAllNodes(NodeType.NORMALINTERP);
    }

    public int getNAllOrientationInterpolatorNodes() {
        return this.getNAllNodes(NodeType.ORIENTATIONINTERP);
    }

    public int getNAllPixelTextureNodes() {
        return this.getNAllNodes(NodeType.PIXELTEXTURE);
    }

    public int getNAllPlaneSensorNodes() {
        return this.getNAllNodes(NodeType.PLANESENSOR);
    }

    public int getNAllPointLightNodes() {
        return this.getNAllNodes(NodeType.POINTLIGHT);
    }

    public int getNAllPointSetNodes() {
        return this.getNAllNodes(NodeType.POINTSET);
    }

    public int getNAllPositionInterpolatorNodes() {
        return this.getNAllNodes(NodeType.POSITONINTERP);
    }

    public int getNAllProximitySensorNodes() {
        return this.getNAllNodes(NodeType.PROXIMITYSENSOR);
    }

    public int getNAllProxyNodes() {
        return this.getNAllNodes(NodeType.PROXY);
    }

    public int getNAllScalarInterpolatorNodes() {
        return this.getNAllNodes(NodeType.SCALARINTERP);
    }

    public int getNAllScriptNodes() {
        return this.getNAllNodes(NodeType.SCRIPT);
    }

    public int getNAllShapeNodes() {
        return this.getNAllNodes(NodeType.SHAPE);
    }

    public int getNAllSoundNodes() {
        return this.getNAllNodes(NodeType.SOUND);
    }

    public int getNAllSphereNodes() {
        return this.getNAllNodes(NodeType.SPHERE);
    }

    public int getNAllSphereSensorNodes() {
        return this.getNAllNodes(NodeType.SPHERESENSOR);
    }

    public int getNAllSpotLightNodes() {
        return this.getNAllNodes(NodeType.SPOTLIGHT);
    }

    public int getNAllSwitchNodes() {
        return this.getNAllNodes(NodeType.SWITCH);
    }

    public int getNAllTextNodes() {
        return this.getNAllNodes(NodeType.TEXT);
    }

    public int getNAllTextureCoordinateNodes() {
        return this.getNAllNodes(NodeType.TEXTURECOORD);
    }

    public int getNAllTextureTransformNodes() {
        return this.getNAllNodes(NodeType.TEXTURETRANSFORM);
    }

    public int getNAllTimeSensorNodes() {
        return this.getNAllNodes(NodeType.TIMESENSOR);
    }

    public int getNAllTouchSensorNodes() {
        return this.getNAllNodes(NodeType.TOUCHSENSOR);
    }

    public int getNAllTransformNodes() {
        return this.getNAllNodes(NodeType.TRANSFORM);
    }

    public int getNAllViewpointNodes() {
        return this.getNAllNodes(NodeType.VIEWPOINT);
    }

    public int getNAllVisibilitySensorNodes() {
        return this.getNAllNodes(NodeType.VISIBILITYSENSOR);
    }

    public int getNAllWorldInfoNodes() {
        return this.getNAllNodes(NodeType.WORLDINFO);
    }

    public int getNAllLoadSensorNodes() {
        return this.getNAllNodes(NodeType.LOADSENSOR);
    }

    public int getNAllStaticGroupNodes() {
        return this.getNAllNodes(NodeType.STATICGROUP);
    }

    public int getNAllColorRGBANodes() {
        return this.getNAllNodes(NodeType.COLORRGBA);
    }

    public int getNAllTriangleSetNodes() {
        return this.getNAllNodes(NodeType.TRIANGLESET);
    }

    public int getNAllTriangleFanSetNodes() {
        return this.getNAllNodes(NodeType.TRIANGLEFANSET);
    }

    public int getNAllTriangleStripSetNodes() {
        return this.getNAllNodes(NodeType.TRIANGLESTRIPSET);
    }

    public int getNAllFillPropertiesNodes() {
        return this.getNAllNodes(NodeType.FILLPROPERTIES);
    }

    public int getNAllLinePropertiesNodes() {
        return this.getNAllNodes(NodeType.LINEPROPERTIES);
    }

    public int getNAllArc2DNodes() {
        return this.getNAllNodes(NodeType.ARC2D);
    }

    public int getNAllArcClose2DNodes() {
        return this.getNAllNodes(NodeType.ARCCLOSE2D);
    }

    public int getNAllCircle2DNodes() {
        return this.getNAllNodes(NodeType.CIRCLE2D);
    }

    public int getNAllDisk2DNodes() {
        return this.getNAllNodes(NodeType.DISK2D);
    }

    public int getNAllPolyline2DNodes() {
        return this.getNAllNodes(NodeType.POLYLINE2D);
    }

    public int getNAllPolypoint2DNodes() {
        return this.getNAllNodes(NodeType.POLYPOINT2D);
    }

    public int getNAllRectangle2DNodes() {
        return this.getNAllNodes(NodeType.RECTANGLE2D);
    }

    public int getNAllTriangleSet2DNodes() {
        return this.getNAllNodes(NodeType.TRIANGLESET2D);
    }

    public int getNAllMultiTextureNodes() {
        return this.getNAllNodes(NodeType.MULTITEXTURE);
    }

    public int getNAllMultiTextureCoordinateNodes() {
        return this.getNAllNodes(NodeType.MULTITEXTURECOORD);
    }

    public int getNAllMultiTextureTransformNodes() {
        return this.getNAllNodes(NodeType.MULTITEXTURETRANSFORM);
    }

    public int getNAllTextureCoordinateGeneratorNodes() {
        return this.getNAllNodes(NodeType.TEXCOORDGEN);
    }

    public int getNAllCoordinateInterpolator2DNodes() {
        return this.getNAllNodes(NodeType.COORDINATEINTERPOLATOR2D);
    }

    public int getNAllPositionInterpolator2DNodes() {
        return this.getNAllNodes(NodeType.POSITIONINTERPOLATOR2D);
    }

    public int getNAllKeySensorNodes() {
        return this.getNAllNodes(NodeType.KEYSENSOR);
    }

    public int getNAllStringSensorNodes() {
        return this.getNAllNodes(NodeType.STRINGSENSOR);
    }

    public int getNAllBooleanFilterNodes() {
        return this.getNAllNodes(NodeType.BOOLEANFILTER);
    }

    public int getNAllBooleanToggleNodes() {
        return this.getNAllNodes(NodeType.BOOLEANTOGGLE);
    }

    public int getNAllBooleanTriggerNodes() {
        return this.getNAllNodes(NodeType.BOOLEANTRIGGER);
    }

    public int getNAllBooleanSequencerNodes() {
        return this.getNAllNodes(NodeType.BOOLEANSEQUENCER);
    }

    public int getNAllIntegerTriggerNodes() {
        return this.getNAllNodes(NodeType.INTEGERTRIGGER);
    }

    public int getNAllIntegerSequencerNodes() {
        return this.getNAllNodes(NodeType.INTEGERSEQUENCER);
    }

    public int getNAllTimeTriggerNodes() {
        return this.getNAllNodes(NodeType.TIMETRIGGER);
    }

    public int getNAllNodeSequencerNodes() {
        return this.getNAllNodes(NodeType.NODESEQUENCER);
    }

    public int getNAllShape2DNodes() {
        return this.getNAllNodes(NodeType.SHAPE2D);
    }

    public int getNAllBooleanTimeTriggerNodes() {
        return this.getNAllNodes(NodeType.BOOLEANTIMETRIGGER);
    }

    public int getNAllTransform2DNodes() {
        return this.getNAllNodes(NodeType.TRANSFORM2D);
    }

    public void removeNode(Node node) {
        this.removeNodeRoutes(node);
        node.remove();
    }

    public void setBoundingBoxCenter(float[] center) {
        int n = 0;
        while (n < 3) {
            this.mBoundingBoxCenter[n] = center[n];
            ++n;
        }
    }

    public void setBoundingBoxCenter(float x, float y, float z) {
        this.mBoundingBoxCenter[0] = x;
        this.mBoundingBoxCenter[1] = y;
        this.mBoundingBoxCenter[2] = z;
    }

    public void getBoundingBoxCenter(float[] center) {
        int n = 0;
        while (n < 3) {
            center[n] = this.mBoundingBoxCenter[n];
            ++n;
        }
    }

    public float[] getBoundingBoxCenter() {
        float[] center = new float[3];
        this.getBoundingBoxCenter(center);
        return center;
    }

    public void setBoundingBoxSize(float[] size) {
        int n = 0;
        while (n < 3) {
            this.mBoundingBoxSize[n] = size[n];
            ++n;
        }
    }

    public void setBoundingBoxSize(float x, float y, float z) {
        this.mBoundingBoxSize[0] = x;
        this.mBoundingBoxSize[1] = y;
        this.mBoundingBoxSize[2] = z;
    }

    public void getBoundingBoxSize(float[] size) {
        int n = 0;
        while (n < 3) {
            size[n] = this.mBoundingBoxSize[n];
            ++n;
        }
    }

    public float[] getBoundingBoxSize() {
        float[] size = new float[3];
        this.getBoundingBoxSize(size);
        return size;
    }

    public void updateBoundingBox(Node node, BoundingBox bbox) {
        if (node.isGeometry3DNode()) {
            Geometry3DNode gnode = (Geometry3DNode)node;
            float[] bboxCenter = new float[3];
            float[] bboxSize = new float[3];
            float[] point = new float[3];
            gnode.getBoundingBoxCenter(bboxCenter);
            gnode.getBoundingBoxSize(bboxSize);
            if (bboxSize[0] >= 0.0f && bboxSize[1] >= 0.0f && bboxSize[2] >= 0.0f) {
                SFMatrix nodemx = node.getTransformMatrix();
                int n = 0;
                while (n < 8) {
                    point[0] = n < 4 ? bboxCenter[0] - bboxSize[0] : bboxCenter[0] + bboxSize[0];
                    point[1] = n % 2 != 0 ? bboxCenter[1] - bboxSize[1] : bboxCenter[1] + bboxSize[1];
                    point[2] = n % 4 < 2 ? bboxCenter[2] - bboxSize[2] : bboxCenter[2] + bboxSize[2];
                    nodemx.multi(point);
                    bbox.addPoint(point);
                    ++n;
                }
            }
        }
        Node cnode = node.getChildNodes();
        while (cnode != null) {
            this.updateBoundingBox(cnode, bbox);
            cnode = cnode.next();
        }
    }

    public void updateBoundingBox() {
        BoundingBox bbox = new BoundingBox();
        Node node = this.getNodes();
        while (node != null) {
            this.updateBoundingBox(node, bbox);
            node = node.next();
        }
        this.setBoundingBoxCenter(bbox.getCenter());
        this.setBoundingBoxSize(bbox.getSize());
    }

    public float getRadius() {
        SFVec3f bboxSize = new SFVec3f(this.getBoundingBoxSize());
        return bboxSize.getScalar();
    }
}

