/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.sftp;

import ciss.phase_viewer.filebrowser.FileBrowserEvent;
import ciss.phase_viewer.filebrowser.FileBrowserTree;
import ciss.phase_viewer.filebrowser.FileBrowserTreeListener;
import ciss.phase_viewer.filebrowser.FileTransfer;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeEvent;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeListener;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.SshClient;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.sftp.Sftp;
import ciss.phase_viewer.ssh.sftp.SftpEvent;
import ciss.phase_viewer.ssh.sftp.SftpListener;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class SftpClientPanel
extends JPanel
implements SshClient,
SftpListener,
FileBrowserTreeListener,
FileTransfer,
ProjectDirBrowserNodeChangeListener {
    private Logger logger = Logger.getLogger((String)SftpClientPanel.class.getName());
    private FileBrowserTree local;
    private FileBrowserTree remote;
    private HostInfo hostinfo;
    private Sftp sftp;
    private ChannelSftp c;
    private boolean isConnected = false;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
    private String localInitDir = System.getProperty("user.home");
    private String remoteInitDir;
    private boolean local_has_projbrowser = false;
    public static final int REMOTE_PANE = 0;
    public static final int LOCAL_PANE = 1;

    public SftpClientPanel() {
        this.init();
        this.setVisible(true);
    }

    public SftpClientPanel(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
        this.init();
        this.connect(hostinfo);
    }

    public SftpClientPanel(HostInfo hostinfo, boolean local_has_projbrowser) {
        this.hostinfo = hostinfo;
        this.local_has_projbrowser = local_has_projbrowser;
        this.init();
        this.connect(hostinfo);
    }

    public SftpClientPanel(String initDir) {
        this.localInitDir = initDir;
        this.init();
    }

    public SftpClientPanel(String initDir, boolean local_has_projbrowser) {
        this.localInitDir = initDir;
        this.local_has_projbrowser = local_has_projbrowser;
        this.init();
    }

    public SftpClientPanel(boolean local_has_projbrowser) {
        this.local_has_projbrowser = local_has_projbrowser;
        this.init();
    }

    @Override
    public void uploadFinished(SftpEvent se) {
        this.reload(0);
    }

    @Override
    public void downloadFinished(SftpEvent se) {
        this.reload(1);
    }

    public void setLocalInitialDir(String dir) {
        this.localInitDir = dir;
    }

    public void setRemoteInitialDir(String dir) {
        this.remoteInitDir = dir;
    }

    @Override
    public void connect(HostInfo host) {
        this.hostinfo = host;
        this.logger.debug((Object)("connecting to host: " + host.getName()));
        this.sftp = new Sftp(host);
        this.sftp.addSftpListener(this);
        this.sftp.addSftpListener(this.remote);
        this.sftp.connect();
        ((TitledBorder)this.remote.getBorder()).setTitle("connected to host: " + host.getName());
        this.c = this.sftp.getChannelSftp();
        this.remote.setChannelSftp(this.c);
        if (this.remoteInitDir == null || this.remoteInitDir.trim().length() == 0) {
            try {
                this.remoteInitDir = this.sftp.getChannelSftp().pwd();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.remote.init(this.remoteInitDir);
        this.setSize(this.getSize().width, this.getSize().height);
        this.isConnected = true;
    }

    @Override
    public void disconnect() {
        if (this.sftp != null) {
            this.sftp.disconnect();
        }
        this.revalidate();
    }

    @Override
    public void setHostInfo(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
    }

    @Override
    public HostInfo getHostInfo() {
        return this.hostinfo;
    }

    public Sftp getSftp() {
        return this.sftp;
    }

    @Override
    public void directoryHasChanged(FileBrowserEvent fbe) {
        FileBrowserTree tmp = (FileBrowserTree)fbe.getSource();
        boolean isremote = tmp.isRemote();
        RemoteFile cur = tmp.getCurrentDir();
        String curdir = new String();
        curdir = cur != null ? cur.getAbsolutePath() : RemoteFile.listRoots()[0].getAbsolutePath();
        if (isremote) {
            this.logger.debug((Object)("remote directory has changed to " + curdir));
            if (this.sftp != null) {
                this.sftp.cd(curdir);
            }
        } else {
            this.logger.debug((Object)("local directory has changed to " + curdir));
            if (this.sftp != null) {
                this.sftp.lcd(curdir);
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    protected void reload(int mode) {
        if (mode == 1) {
            this.local.init();
        } else if (mode == 0) {
            this.remote.init();
        }
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel pane = this.createBrowsers();
        this.add(pane);
    }

    private JPanel createBrowsers() {
        int os = 0;
        if (!System.getProperty("os.name").trim().toLowerCase().startsWith("windows")) {
            os = 1;
        }
        this.local = new FileBrowserTree(os, this.localInitDir, this, "ciss.phase_viewer.ssh.sftp.SftpNode", false);
        this.local.init();
        this.local.setBorder(new TitledBorder("local"));
        this.local.addFileBrowserListener(this);
        this.local.setFileTransfer(this);
        this.remote = new FileBrowserTree(1, ".", this, "ciss.phase_viewer.ssh.sftp.SftpNode", false);
        this.remote.setBorder(new TitledBorder("(not connected)"));
        this.remote.setRemote(true);
        this.remote.addFileBrowserListener(this);
        this.remote.setFileTransfer(this);
        JPanel p = new JPanel();
        JSplitPane split0 = new JSplitPane(0, true, this.local, this.remote);
        split0.setResizeWeight(0.5);
        split0.setDividerLocation(0.5);
        split0.setPreferredSize(this.getPreferredSize());
        p.setLayout(new BoxLayout(p, 0));
        JScrollPane pan = new JScrollPane(split0);
        pan.setPreferredSize(split0.getPreferredSize());
        if (this.local_has_projbrowser) {
            ProjectDirBrowser dirBrowser = new ProjectDirBrowser("projects", new ProjectDirBrowserNodeChangeListener[]{this});
            JSplitPane split1 = new JSplitPane(1, true, split0, dirBrowser);
            p.add(split1);
        } else {
            p.add(split0);
        }
        return p;
    }

    @Override
    public void uploadFiles() {
        RemoteFile[] localFiles = this.local.getSelectedFiles();
        if (localFiles != null) {
            int i = 0;
            while (i < localFiles.length) {
                this.logger.debug((Object)("selected file: " + localFiles[i].getAbsolutePath()));
                ++i;
            }
        }
        if (this.sftp == null) {
            this.logger.info((Object)"not connected");
            return;
        }
        String foo = localFiles[0].getParent();
        if (!foo.endsWith(System.getProperty("file.separator"))) {
            foo = String.valueOf(foo) + System.getProperty("file.separator");
        }
        this.sftp.upload(localFiles, this.remote.getCurrentDir(), null);
    }

    @Override
    public void downloadFiles() {
        RemoteFile[] remoteFiles = this.remote.getSelectedFiles();
        if (remoteFiles != null) {
            int i = 0;
            while (i < remoteFiles.length) {
                this.logger.debug((Object)("selected file: " + remoteFiles[i].getAbsolutePath()));
                ++i;
            }
        }
        if (this.sftp == null) {
            this.logger.info((Object)"not connected");
            return;
        }
        this.sftp.download(remoteFiles, this.local.getCurrentDir());
    }

    public FileBrowserTree getBrowserTree(int mode) {
        if (mode == 0) {
            return this.remote;
        }
        if (mode == 1) {
            return this.local;
        }
        this.logger.error((Object)"invalid specification of 'mode'");
        return null;
    }

    @Override
    public void downloadToTmpFile() {
        int i;
        String tmp = System.getProperty("java.io.tmpdir");
        RemoteFile[] remoteFiles = this.remote.getSelectedFiles();
        if (remoteFiles != null) {
            i = 0;
            while (i < remoteFiles.length) {
                this.logger.debug((Object)("selected file: " + remoteFiles[i].getAbsolutePath()));
                ++i;
            }
        }
        if (this.sftp == null) {
            this.logger.info((Object)"not connected");
            return;
        }
        i = 0;
        while (i < remoteFiles.length) {
            new File(String.valueOf(tmp) + System.getProperty("file.separator") + remoteFiles[i].getName()).deleteOnExit();
            ++i;
        }
        RemoteFile tmpdir = new RemoteFile(tmp);
        this.sftp.download(remoteFiles, tmpdir);
    }

    @Override
    public void nodeSelected(ProjectDirBrowserNodeChangeEvent e) {
        if (e == null || e.getSource() == null) {
            return;
        }
        ProjectDirBrowserNode node = (ProjectDirBrowserNode)e.getSource();
        ProjectInfo proj = node.getProjectInfo();
        String dir = proj.getProjectDirectory();
        this.logger.debug((Object)("dir: " + dir));
        this.local.setRoot(dir);
        if (this.hostinfo != null) {
            proj.setHostInfo(this.hostinfo);
            String targetDir = proj.getTargetDirectory();
            this.remote.setRoot(targetDir);
        }
    }
}

