/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh;

import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.ssh.KnownHosts;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.MyUserInfo;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SessionCreator {
    private static Logger logger = Logger.getLogger((String)SessionCreator.class.getName());

    private SessionCreator() {
    }

    public static Session getSession(HostInfo info) throws JSchException {
        return SessionCreator.getSession(info, -1);
    }

    public static Session getSession(HostInfo info, int timeout) throws JSchException {
        String pkey;
        logger.debug((Object)"creating session: ");
        String user = info.getProperty("username");
        String address = info.getProperty("address");
        if (user == null || user.length() == 0) {
            SessionCreator.prompt("username", user, info);
            if (user == null || user.length() == 0) {
                logger.info((Object)"operation canceled.");
                return null;
            }
        }
        if (address == null || address.length() == 0) {
            SessionCreator.prompt("address", address, info);
            if (address == null || address.length() == 0) {
                logger.info((Object)"operation canceled.");
                return null;
            }
        }
        int port = 22;
        String sport = info.getProperty("port");
        if (sport != null) {
            try {
                port = Integer.parseInt(sport);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        MyUserInfo userinfo = new MyUserInfo(info);
        JSch jsch = KnownHosts.getJSch();
        String pkeySupport = System.getProperty("private_key_support");
        if (pkeySupport != null && pkeySupport.equals("true") && (pkey = info.getProperty("private_key_file")) != null && new File(pkey).exists()) {
            jsch.addIdentity(pkey);
        }
        Session session = jsch.getSession(user, address, port);
        session.setUserInfo((UserInfo)userinfo);
        if (timeout >= 0) {
            session.setTimeout(timeout);
        }
        try {
            session.connect();
        }
        catch (JSchException ex) {
            ex.printStackTrace();
            logger.error((Object)"connection failed");
            return null;
        }
        return session;
    }

    private static String prompt(String tag, String str, HostInfo info) {
        JTextField text = new JTextField();
        Object[] ob = new Object[]{text};
        int result = JOptionPane.showConfirmDialog(Desk.getDesktop(), text, "enter " + tag, 2);
        if (result == 0) {
            str = text.getText();
            info.setProperty(tag, str);
            return str;
        }
        return null;
    }
}

