/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.settings;

import ciss.phase_viewer.settings.InstallationProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class GlobalProperties
extends Properties {
    private static Logger logger = Logger.getLogger((String)GlobalProperties.class.getName());
    protected String fileName;
    protected int propertyType;
    protected InstallationProperties installation;
    protected String FS = System.getProperty("file.separator");
    protected String homeDir = System.getProperty("user.home");
    protected String instDir = System.getProperty("pviewer.home");
    protected String pviewerHomeDir = String.valueOf(this.homeDir) + this.FS + ".phase-viewer";
    private static Vector listeners;

    private void init() {
        this.FS = System.getProperty("file.separator");
        this.homeDir = System.getProperty("user.home");
        this.instDir = System.getProperty("pviewer.home");
        this.pviewerHomeDir = String.valueOf(this.homeDir) + this.FS + ".phase-viewer";
    }

    protected GlobalProperties() {
        this.init();
        this.setFileName();
        this.loadProperty();
    }

    protected GlobalProperties(InstallationProperties installation) {
        this.init();
        this.installation = installation;
        this.setFileName();
        this.loadProperty();
    }

    protected GlobalProperties(InstallationProperties installation, Properties defaultProperties) {
        super(defaultProperties);
        this.init();
        this.installation = installation;
        this.setFileName();
        this.loadProperty();
    }

    public abstract String getFileName();

    public abstract int getPropertyType();

    protected abstract void setFileName();

    private void loadProperty() {
        try {
            if (new File(this.fileName).exists()) {
                super.load(new FileInputStream(this.fileName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addPropertiesListener(PropertiesListener listener) {
        if (listeners == null) {
            listeners = new Vector();
        }
        listeners.addElement(listener);
    }

    public static void removePropertiesListener(PropertiesListener listener) {
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
    }

    public void storeProperty() {
        try {
            if (new File(this.fileName).exists() && !new File(this.fileName).canWrite()) {
                return;
            }
            super.store(new FileOutputStream(this.fileName), "last modification");
            if (listeners != null) {
                int i = 0;
                while (i < listeners.size()) {
                    ((PropertiesListener)listeners.get(i)).propertiesStored(this);
                    ++i;
                }
            }
        }
        catch (IOException exc) {
            logger.debug((Object)("failed to store property to file: " + this.fileName));
            exc.printStackTrace();
        }
    }
}

