/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser;

import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.mainpanel.LookandFeel;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.ProjectManipulatorSubSelector;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

class SubSelectorButton
extends JButton
implements ActionListener {
    private Logger logger = Logger.getLogger((String)SubSelectorButton.class.getName());
    private String loadClass;
    private ProjectInfo info;
    private JSplitPane splitpane;
    private ProjectManipulatorSubSelector subSelector;

    protected SubSelectorButton(String name, String iconpath, String description, String loadClass, ProjectInfo info, JSplitPane splitpane, ProjectManipulatorSubSelector subSelector) {
        super(name);
        this.info = info;
        this.loadClass = loadClass;
        this.splitpane = splitpane;
        this.subSelector = subSelector;
        if (iconpath != null && iconpath.length() != 0 && !iconpath.equals("null")) {
            this.logger.debug((Object)("iconpath: " + iconpath));
            PluginLoader loader = new PluginLoader();
            URL res = null;
            super.setHorizontalTextPosition(0);
            super.setVerticalTextPosition(3);
            if (UIManager.getLookAndFeel().getClass().getName().equals(LookandFeel.landf_metal)) {
                super.setContentAreaFilled(false);
            }
            try {
                res = loader.getResource(iconpath.trim());
                super.setIcon(new ImageIcon(res));
            }
            catch (Exception ex) {
                this.logger.error((Object)"failed to resolve icon path.");
            }
            super.revalidate();
        }
        if (description != null && description.length() != 0) {
            super.setToolTipText(description);
        }
        super.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.bootProjectManipulatorSub();
    }

    protected void bootProjectManipulatorSub() {
        this.logger.debug((Object)("loadClass: " + this.loadClass));
        ProjectManipulator manip = null;
        try {
            PluginLoader loader = new PluginLoader();
            Class<?> cla = loader.loadClass(this.loadClass);
            manip = this.subSelector.getProjectManipulator(cla.getName());
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (manip == null) {
            manip = (ProjectManipulator)PluginLoader.instantiate(this.loadClass, new Object[]{this.info});
            manip.init();
            this.subSelector.registerProjectManipulators(manip);
        }
        if (manip != null) {
            manip.buttonPressed();
        }
        boolean post = true;
        try {
            Vector manips = this.subSelector.getProjectManipulators();
            int i = 0;
            while (i < manips.size()) {
                if (!((ProjectManipulator)manips.elementAt(i)).postProcess()) {
                    post = false;
                }
                ++i;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (post) {
            if (this.subSelector.getLayoutPolicy() == 0) {
                this.splitpane.setRightComponent(manip);
            } else {
                this.splitpane.setBottomComponent(manip);
            }
            manip.componentSet();
        } else {
            this.logger.info((Object)"operation canceled.");
        }
        if (manip != null) {
            manip.postInit();
        }
    }
}

