/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser;

import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jdom.XMLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class Restorer {
    private static Logger logger = Logger.getLogger((String)Restorer.class.getName());
    private static File rootDirectory;
    private static final String PROJECT = "project";
    private static final String SUBPROJECT = "subproject";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String DISPLAY = "display";
    private static final String HASSUB = "hassub";
    private static final String SUBIDENT = "subident";
    private static final String SHOULDBEVISIBLE = "shouldbevisible";
    private static final String SELECTED = "selected";
    private static final String FS;
    private static final String PHASE = "phase";
    private static final String EKCAL = "ekcal";
    private static final String UVSOR = "uvsor-epsilon";

    static {
        FS = System.getProperty("file.separator");
    }

    public static boolean restore(File targetDir, File outFile) {
        File[] files;
        if (!targetDir.exists() || !targetDir.isDirectory()) {
            logger.error((Object)"Specify an existing directory!");
            return false;
        }
        Element rootElement = new Element("projects");
        Restorer.initRoot(targetDir, rootElement);
        File[] fileArray = files = targetDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                Restorer.restoreCore(file, rootElement);
            }
            ++n2;
        }
        Restorer.dumpProjectSpecFile(outFile, rootElement);
        return true;
    }

    private static void initRoot(File targetDir, Element rootElement) {
        rootDirectory = targetDir;
        rootElement.setAttribute(new Attribute(DISPLAY, TRUE));
        rootElement.setAttribute(new Attribute(HASSUB, TRUE));
        rootElement.setAttribute(new Attribute(SUBIDENT, PROJECT));
        rootElement.setAttribute(new Attribute(SHOULDBEVISIBLE, TRUE));
        rootElement.setAttribute(new Attribute(SELECTED, FALSE));
        Element name = new Element("name").setText(MyElement.encode(targetDir.getName()));
        Element type = new Element("type").setText("root");
        Element dir = new Element("directory").setText(MyElement.encode(targetDir.getAbsolutePath()));
        rootElement.addContent((Content)name);
        rootElement.addContent((Content)type);
        rootElement.addContent((Content)dir);
    }

    private static void restoreCore(File targetDir, Element parentElement) {
        File[] files = targetDir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        Element element = null;
        element = Restorer.isProject(targetDir) && !Restorer.isPPDirectory(targetDir) ? Restorer.getProjectElement(targetDir) : Restorer.getSubProjectElement(targetDir);
        parentElement.addContent((Content)element);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                Restorer.restoreCore(file, element);
            }
            ++n2;
        }
    }

    private static Element getProjectElement(File targetDir) {
        Element ret = new Element(PROJECT);
        ret.setAttribute(new Attribute(DISPLAY, TRUE));
        ret.setAttribute(new Attribute(HASSUB, TRUE));
        ret.setAttribute(new Attribute(SUBIDENT, SUBPROJECT));
        ret.setAttribute(new Attribute(SHOULDBEVISIBLE, FALSE));
        ret.setAttribute(new Attribute(SELECTED, FALSE));
        Element name = new Element("name").setText(MyElement.encode(targetDir.getName()));
        Element typ = new Element("type").setText("chase project");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(targetDir.lastModified());
        Element time = new Element("date").setText(MyElement.encode(calendar.getTime().toString()));
        Element dir = new Element("directory").setText(MyElement.encode(targetDir.getAbsolutePath()));
        ret.addContent((Content)name);
        ret.addContent((Content)typ);
        ret.addContent((Content)time);
        ret.addContent((Content)dir);
        if (Restorer.isDataDirectory(targetDir)) {
            ret.addContent((Content)new Element("editable").setText(FALSE));
        }
        return ret;
    }

    private static Element getSubProjectElement(File targetDir) {
        Element ret = new Element(SUBPROJECT);
        ret.setAttribute(new Attribute(DISPLAY, TRUE));
        ret.setAttribute(new Attribute(SHOULDBEVISIBLE, FALSE));
        ret.setAttribute(new Attribute(SELECTED, FALSE));
        Element name = new Element("name").setText(MyElement.encode(targetDir.getName()));
        String fname = String.valueOf(targetDir.getAbsolutePath()) + FS + "file_names.data";
        String nfinp = Restorer.getFilePathFromFileNamesData(fname, "F_INP", "nfinp.data");
        InputInterface inpint = Restorer.getInputInterface(String.valueOf(targetDir.getAbsolutePath()) + FS + nfinp);
        if (inpint == null) {
            return ret;
        }
        String cond = inpint.getInputInterfacePrimitiveEntry("control.condition").getValue().trim();
        boolean isPhase = true;
        if (cond.equals("2") || cond.equals("3") || cond.toLowerCase().startsWith("fixed_charge")) {
            isPhase = false;
        }
        String subprojType = PHASE;
        String associatedDirectory = null;
        if (!isPhase) {
            subprojType = inpint.getInputInterfacePrimitiveEntry("epsilon.sw_epsilon").getValue().length() == 0 ? EKCAL : UVSOR;
            String nfchgt = Restorer.getFilePathFromFileNamesData(fname, "F_CHGT", "nfchgt.data");
            if (nfchgt != null) {
                associatedDirectory = new File(nfchgt).getParent();
            }
        }
        if (Restorer.isPPDirectory(targetDir)) {
            subprojType = "pp";
            ret.addContent((Content)new Element("editable").setText(FALSE));
        }
        Element typ = new Element("type").setText(subprojType);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(targetDir.lastModified());
        Element dat = new Element("date").setText(MyElement.encode(calendar.getTime().toString()));
        ret.addContent((Content)name);
        ret.addContent((Content)typ);
        ret.addContent((Content)dat);
        if (!isPhase && associatedDirectory != null) {
            Element ass = new Element("associated_directory");
            ass.setAttribute(new Attribute("type", "parent"));
            ass.setText(MyElement.encode(associatedDirectory));
            ret.addContent((Content)ass);
        }
        return ret;
    }

    private static InputInterface getInputInterface(String nfinp) {
        DataManager dm = new DataManager(nfinp);
        try {
            dm.parse();
        }
        catch (Exception exc) {
            return null;
        }
        InputInterface inputInterface = dm.getInputInterface();
        return inputInterface;
    }

    private static String getFilePathFromFileNamesData(String fileNamesData, String ident, String defaultName) {
        BufferedReader reader = null;
        String ret = defaultName;
        if (fileNamesData == null || !new File(fileNamesData).exists()) {
            return ret;
        }
        try {
            try {
                reader = new BufferedReader(new FileReader(fileNamesData));
                String line = "";
                while ((line = reader.readLine()) != null) {
                    String fname;
                    String[] lines;
                    if ((line = line.trim()).startsWith("&") || (lines = line.split("=")).length < 2 || (fname = lines[1].trim()).length() <= 2 || !lines[0].trim().equals(ident)) continue;
                    ret = fname.substring(1, fname.length() - 1);
                    break;
                }
            }
            catch (IOException ioe) {
                String string = ret;
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return string;
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return ret;
    }

    private static boolean isProject(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        boolean filesAreDirectories = true;
        boolean fileNamesDataExists = false;
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory()) {
                filesAreDirectories = false;
            }
            if (files[i].getName().equals("file_names.data")) {
                fileNamesDataExists = true;
            }
            ++i;
        }
        return filesAreDirectories || !fileNamesDataExists;
    }

    private static boolean isDataDirectory(File dir) {
        return dir.getAbsolutePath().toLowerCase().equals((String.valueOf(rootDirectory.getAbsolutePath()) + FS + "data").toLowerCase());
    }

    private static boolean isPPDirectory(File dir) {
        return dir.getAbsolutePath().toLowerCase().equals((String.valueOf(rootDirectory.getAbsolutePath()) + FS + "data" + FS + "pseudopotential").toLowerCase());
    }

    private static void dumpProjectSpecFile(File file, Element rootElement) {
        Document doc = new Document();
        doc.setRootElement(rootElement);
        XMLUtils.saveDocumentTo(doc, file);
    }
}

