/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.prefs.prefseditor;

import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.TaggedString;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class ACVEditors
extends JPanel {
    private static Logger logger = Logger.getLogger((String)ACVEditors.class.getName());
    protected MainPanel mp;
    protected J3DDataManager mACVD;
    protected ConfigDataManager mCD;
    protected AtomCoords coords;
    protected DecimalFormat formater = ConstParameters.formater;
    protected double[][] Cell;
    protected double[][] Dpos;
    protected String[] elements;
    protected TaggedString[][] auxils;
    protected int NumEl;
    protected int NumAt;
    protected int NumAllAtoms;

    public ACVEditors(MainPanel mp) {
        logger.debug((Object)"initializing ACVEditors ...");
        this.mp = mp;
        this.mACVD = mp.getJ3DDataManager();
        this.mCD = mp.getCD();
        this.coords = this.mCD.getAtomCoords();
        this.getData();
        this.createGUI();
        this.setDataToPanel();
    }

    protected void getData() {
        this.NumEl = this.mACVD.getElement().length;
        this.NumAllAtoms = this.NumAt = this.mCD.getNumAt();
        logger.debug((Object)("NumEl, NumAt: " + this.NumEl + " " + this.NumAt));
        this.elements = this.mCD.getElements();
        this.Cell = this.mCD.getCell();
        this.Dpos = this.mCD.getPos();
        this.auxils = this.mCD.getAuxils();
    }

    protected abstract void createGUI();

    protected abstract void setDataToPanel();

    protected abstract void setDataToRepository();

    protected abstract String getTitle();
}

