/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.measure;

import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.measure.Measurable;
import ciss.phase_viewer.acviewer.measure.Measure;
import ciss.phase_viewer.acviewer.measure.MeasureBranchGroup;
import ciss.phase_viewer.acviewer.measure.MeasureListener;
import ciss.phase_viewer.acviewer.measure.NullMeasure;
import ciss.phase_viewer.acviewer.scenegraphelements.MeasureObject;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.media.j3d.BranchGroup;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class MeasurePanel
extends InternalFrameChase
implements ConfigData,
MeasureListener {
    private Logger logger = Logger.getLogger((String)MeasurePanel.class.getName());
    private J3DPanel parent;
    private Measurable measurable;
    private Measure[] measures;
    private JComboBox measureSelector;
    private JList jList;
    private DefaultListModel listModel;
    private String FS = System.getProperty("file.separator");
    private String specfile = String.valueOf(System.getProperty("pviewer.home")) + this.FS + "plugins" + this.FS + "ciss" + this.FS + "phase_viewer" + this.FS + "plugins" + this.FS + "viewer" + this.FS + "measure" + this.FS + "supported.xml";
    private JButton remselected;
    private JButton remall;
    private JButton dismiss;

    public MeasurePanel(J3DPanel parent) {
        super("measure", new Dimension(350, 250));
        this.parent = parent;
        if (!(parent.getRootTransform() instanceof Measurable)) {
            this.logger.error((Object)"'measure' function not supported.");
            this.dispose();
            return;
        }
        this.measurable = (Measurable)parent.getRootTransform();
        this.measurable.addMeasureListener(this);
        this.init();
        parent.addDisposeOnExit(this);
        this.setVisible(true);
    }

    private void init() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.createMeasures();
        JPanel mpanel = new JPanel();
        mpanel.setBorder(new TitledBorder("select measure"));
        mpanel.add(this.measureSelector);
        container.add((Component)mpanel, "North");
        JPanel mlist = this.createMeasureList();
        container.add((Component)mlist, "Center");
        JPanel btns = this.createBtnPanel();
        container.add((Component)btns, "South");
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent ev) {
                MeasurePanel.this.winclosed();
            }
        });
    }

    private void winclosed() {
        this.measurable.removeMeasureListener(this);
        this.measurable.registerMeasure(new NullMeasure(this.measurable));
    }

    private JPanel createMeasureList() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 1));
        this.listModel = new DefaultListModel();
        this.jList = new JList(this.listModel);
        JScrollPane scrpane = new JScrollPane(this.jList);
        ret.add(scrpane);
        MeasureBranchGroup[] mbgs = this.measurable.getExistingMeasures();
        if (mbgs != null && mbgs.length != 0) {
            int i = 0;
            while (i < mbgs.length) {
                int j = 0;
                while (j < mbgs[i].numChildren()) {
                    MeasureObject mobj = (MeasureObject)mbgs[i].getChild(j);
                    this.listModel.addElement(mobj);
                    ++j;
                }
                ++i;
            }
        }
        return ret;
    }

    private void createMeasures() {
        this.logger.debug((Object)("specfile: " + this.specfile));
        Object[] args = new Object[]{this.measurable};
        Document doc = XMLUtils.getDocumentFromFile(new File(this.specfile));
        Element rootElement = doc.getRootElement();
        List measureList = rootElement.getChildren("measure");
        String[] measureNames = new String[measureList.size()];
        this.measures = new Measure[measureList.size()];
        int i = 0;
        while (i < measureList.size()) {
            Element measureElement = (Element)measureList.get(i);
            measureNames[i] = measureElement.getChildTextTrim("name");
            String clazz = measureElement.getChildTextTrim("class");
            this.measures[i] = (Measure)PluginLoader.instantiate(clazz, args);
            ++i;
        }
        this.measureSelector = new JComboBox<Measure>(this.measures);
        this.measureSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeasurePanel.this.measurable.registerMeasure((Measure)MeasurePanel.this.measureSelector.getSelectedItem());
            }
        });
        this.measureSelector.setSelectedIndex(0);
    }

    private JPanel createBtnPanel() {
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new BoxLayout(btnpanel, 0));
        this.remselected = new JButton("remove selected");
        this.remall = new JButton("remove all");
        this.dismiss = new JButton("dismiss");
        btnpanel.add(this.remselected);
        btnpanel.add(this.remall);
        btnpanel.add(this.dismiss);
        this.dismiss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeasurePanel.this.dispose();
            }
        });
        this.remselected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeasurePanel.this.remSelected();
            }
        });
        this.remall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeasurePanel.this.remAll();
            }
        });
        JPanel ret = new JPanel();
        ret.add(btnpanel);
        return ret;
    }

    private void remSelected() {
        int[] indeces = this.jList.getSelectedIndices();
        if (indeces == null || indeces.length == 0) {
            this.logger.info((Object)"measure unselected");
            return;
        }
        int i = indeces.length - 1;
        while (i >= 0) {
            if (indeces[i] >= 0 && indeces[i] < this.listModel.size()) {
                Object obj = this.listModel.remove(indeces[i]);
                ((BranchGroup)obj).detach();
            }
            --i;
        }
    }

    private void remAll() {
        int i = this.listModel.size() - 1;
        while (i >= 0) {
            if (i >= 0 && i < this.listModel.size()) {
                Object obj = this.listModel.remove(i);
                ((BranchGroup)obj).detach();
            }
            --i;
        }
    }

    @Override
    public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
        this.configDataUpdate();
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    @Override
    public void configDataUpdate() {
    }

    @Override
    public void measured(Measure measure) {
        this.logger.debug((Object)"at measured");
        MeasureBranchGroup mbg = measure.getMeasureBranch();
        if (mbg.numChildren() == 0) {
            return;
        }
        MeasureObject mobj = (MeasureObject)mbg.getChild(mbg.numChildren() - 1);
        mobj.setAssociatedListModel(this.listModel);
        this.listModel.addElement(mobj);
    }

    @Override
    public void measureUpdated(Measure measure) {
        if (this.jList != null) {
            this.jList.repaint();
        }
    }
}

