/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.measure;

import ciss.phase_viewer.acviewer.measure.Measurable;
import ciss.phase_viewer.acviewer.measure.Measure;
import ciss.phase_viewer.acviewer.scenegraphelements.MeasureObject;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementCreator;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.VectorOperations;
import javax.media.j3d.BranchGroup;
import org.apache.log4j.Logger;

public class DistanceMeasure
extends Measure {
    private static Logger logger = Logger.getLogger((String)DistanceMeasure.class.getName());
    private MeasureObject mobj;

    public DistanceMeasure(Measurable measurable) {
        super(measurable);
    }

    @Override
    public int getNumberOfNecessaryAtoms() {
        return 2;
    }

    @Override
    public void draw() {
        if (!this.validData) {
            return;
        }
        this.mobj = (MeasureObject)this.getElem();
        this.mobj.setAtomVector(this.atomVectorNow);
        this.bg.addMeasureObject(this.mobj);
    }

    private BranchGroup getElem() {
        SceneGraphElementCreator creator = this.measurable.getCreator();
        return creator.getSceneGraphElement(this.xyz[0], this.xyz[1], this.result, this.id);
    }

    @Override
    public void calculate() {
        double distance;
        this.result = distance = VectorOperations.calDist(this.pos_moto[0], this.pos_moto[1]);
        if (!this.updating) {
            logger.info((Object)("distance between atom " + this.id[1] + " and " + this.id[0] + " : " + ConstParameters.formater.format(distance) + "\u212b"));
        }
    }

    @Override
    protected void initUpdate() {
        this.updating = true;
    }

    @Override
    public void redraw(int measureIndex, boolean valid) {
        if (!this.validData) {
            return;
        }
        this.mobj = (MeasureObject)this.bg.getChild(measureIndex);
        if (!valid) {
            this.mobj.detach();
            return;
        }
        this.mobj.setAtoms(new double[][]{this.xyz[0], this.xyz[1]});
        this.mobj.setResult(this.result);
        this.mobj.recreate();
    }

    @Override
    protected void finalizeUpdate() {
        this.updating = false;
    }

    public String toString() {
        return "distance";
    }
}

