/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.edit;

import Jama.Matrix;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;

class AtomicConfiguration
implements Cloneable {
    private static Logger logger = Logger.getLogger((String)AtomicConfiguration.class.getName());
    protected String name = "AtomicConfiguration";
    protected int nat;
    protected String[] elemname;
    protected double[][] cartpos;
    protected double[][] fractpos;
    protected double[][] latvec;
    protected double[] latconst;
    protected AtomCoords coords;
    private double[] com;
    private boolean reverseShift;
    private int[][] rotmat1;
    private int[][] rotmat2;
    private int[][] rotmat3;
    private int[][] rotmat4;

    void setName(String name) {
        this.name = name;
    }

    void initFromElement(Element element) {
        String nam = element.getAttributeValue("name");
        if (nam != null && nam.length() > 0) {
            this.setName(nam);
        }
        try {
            int na = element.getAttribute("nat").getIntValue();
            this.setNumAt(na);
        }
        catch (DataConversionException dce) {
            dce.printStackTrace();
            logger.error((Object)"failed conversion");
            return;
        }
        Element lat = element.getChild("lattice");
        Element avec = lat.getChild("avec");
        Element bvec = lat.getChild("bvec");
        Element cvec = lat.getChild("cvec");
        Element lconst = lat.getChild("latconst");
        this.latvec = new double[3][3];
        this.latconst = new double[6];
        if (avec != null) {
            try {
                this.latvec[0][0] = avec.getAttribute("x").getDoubleValue();
                this.latvec[0][1] = avec.getAttribute("y").getDoubleValue();
                this.latvec[0][2] = avec.getAttribute("z").getDoubleValue();
            }
            catch (DataConversionException dce) {
                logger.error((Object)"failed conversion");
            }
        }
        if (bvec != null) {
            try {
                this.latvec[1][0] = bvec.getAttribute("x").getDoubleValue();
                this.latvec[1][1] = bvec.getAttribute("y").getDoubleValue();
                this.latvec[1][2] = bvec.getAttribute("z").getDoubleValue();
            }
            catch (DataConversionException dce) {
                logger.error((Object)"failed conversion");
            }
        }
        if (cvec != null) {
            try {
                this.latvec[2][0] = cvec.getAttribute("x").getDoubleValue();
                this.latvec[2][1] = cvec.getAttribute("y").getDoubleValue();
                this.latvec[2][2] = cvec.getAttribute("z").getDoubleValue();
            }
            catch (DataConversionException dce) {
                logger.error((Object)"failed conversion");
            }
        }
        if (lconst != null) {
            try {
                this.latconst[0] = lconst.getAttribute("a").getDoubleValue();
                this.latconst[1] = lconst.getAttribute("b").getDoubleValue();
                this.latconst[2] = lconst.getAttribute("c").getDoubleValue();
                this.latconst[3] = lconst.getAttribute("alpha").getDoubleValue();
                this.latconst[4] = lconst.getAttribute("beta").getDoubleValue();
                this.latconst[5] = lconst.getAttribute("gamma").getDoubleValue();
            }
            catch (DataConversionException dce) {
                logger.error((Object)"failed conversion");
            }
        }
        List atms = element.getChildren("atom");
        int iat = 0;
        for (Element atm : atms) {
            this.elemname[iat] = atm.getAttributeValue("elemname");
            Element cpos = atm.getChild("cartpos");
            try {
                this.cartpos[iat][0] = cpos.getAttribute("x").getDoubleValue();
                this.cartpos[iat][1] = cpos.getAttribute("y").getDoubleValue();
                this.cartpos[iat][2] = cpos.getAttribute("z").getDoubleValue();
            }
            catch (DataConversionException e) {
                logger.error((Object)"failed conversion");
            }
            Element fpos = atm.getChild("fractpos");
            try {
                this.fractpos[iat][0] = fpos.getAttribute("x").getDoubleValue();
                this.fractpos[iat][1] = fpos.getAttribute("y").getDoubleValue();
                this.fractpos[iat][2] = fpos.getAttribute("z").getDoubleValue();
            }
            catch (DataConversionException e) {
                logger.error((Object)"failed conversion");
            }
            ++iat;
        }
    }

    Element getElement() {
        Element elem = new Element("AtomicConfiguration");
        elem.setAttribute("name", this.name);
        elem.setAttribute("nat", String.valueOf(this.nat));
        Element lattice = new Element("lattice");
        elem.addContent((Content)lattice);
        Element eavec = new Element("avec");
        eavec.setAttribute("x", String.valueOf(this.latvec[0][0]));
        eavec.setAttribute("y", String.valueOf(this.latvec[0][1]));
        eavec.setAttribute("z", String.valueOf(this.latvec[0][2]));
        Element ebvec = new Element("bvec");
        ebvec.setAttribute("x", String.valueOf(this.latvec[1][0]));
        ebvec.setAttribute("y", String.valueOf(this.latvec[1][1]));
        ebvec.setAttribute("z", String.valueOf(this.latvec[1][2]));
        Element ecvec = new Element("cvec");
        ecvec.setAttribute("x", String.valueOf(this.latvec[2][0]));
        ecvec.setAttribute("y", String.valueOf(this.latvec[2][1]));
        ecvec.setAttribute("z", String.valueOf(this.latvec[2][2]));
        Element lconst = new Element("latconst");
        lconst.setAttribute("a", String.valueOf(this.latconst[0]));
        lconst.setAttribute("b", String.valueOf(this.latconst[1]));
        lconst.setAttribute("c", String.valueOf(this.latconst[2]));
        lconst.setAttribute("alpha", String.valueOf(this.latconst[3]));
        lconst.setAttribute("beta", String.valueOf(this.latconst[4]));
        lconst.setAttribute("gamma", String.valueOf(this.latconst[5]));
        lattice.addContent((Content)eavec);
        lattice.addContent((Content)ebvec);
        lattice.addContent((Content)ecvec);
        lattice.addContent((Content)lconst);
        int i = 0;
        while (i < this.nat) {
            Element atm = new Element("atom");
            elem.addContent((Content)atm);
            atm.setAttribute("no", String.valueOf(i));
            atm.setAttribute("elemname", this.elemname[i]);
            Element cart = new Element("cartpos");
            cart.setAttribute("x", String.valueOf(this.cartpos[i][0]));
            cart.setAttribute("y", String.valueOf(this.cartpos[i][1]));
            cart.setAttribute("z", String.valueOf(this.cartpos[i][2]));
            atm.addContent((Content)cart);
            Element fract = new Element("fractpos");
            fract.setAttribute("x", String.valueOf(this.fractpos[i][0]));
            fract.setAttribute("y", String.valueOf(this.fractpos[i][1]));
            fract.setAttribute("z", String.valueOf(this.fractpos[i][2]));
            atm.addContent((Content)fract);
            ++i;
        }
        return elem;
    }

    double[][] getCartPos() {
        return this.cartpos;
    }

    double[][] getFractPos() {
        return this.fractpos;
    }

    double[][] getLatVec() {
        return this.latvec;
    }

    double[] getLatConst() {
        return this.latconst;
    }

    int getNumAt() {
        return this.nat;
    }

    protected void setNumAt(int nat) {
        this.nat = nat;
        this.elemname = new String[nat];
        this.cartpos = new double[nat][3];
        this.fractpos = new double[nat][3];
    }

    AtomicConfiguration() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        this.rotmat1 = nArrayArray;
        int[][] nArrayArray2 = new int[3][];
        int[] nArray4 = new int[3];
        nArray4[0] = 1;
        nArrayArray2[0] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[1] = 1;
        nArrayArray2[1] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = 1;
        nArrayArray2[2] = nArray6;
        this.rotmat2 = nArrayArray2;
        int[][] nArrayArray3 = new int[3][];
        int[] nArray7 = new int[3];
        nArray7[0] = 1;
        nArray7[2] = -1;
        nArrayArray3[0] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[1] = 1;
        nArrayArray3[1] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[2] = 1;
        nArrayArray3[2] = nArray9;
        this.rotmat3 = nArrayArray3;
        int[][] nArrayArray4 = new int[3][];
        int[] nArray10 = new int[3];
        nArray10[0] = 1;
        nArrayArray4[0] = nArray10;
        int[] nArray11 = new int[3];
        nArray11[1] = 1;
        nArray11[2] = -1;
        nArrayArray4[1] = nArray11;
        int[] nArray12 = new int[3];
        nArray12[2] = 1;
        nArrayArray4[2] = nArray12;
        this.rotmat4 = nArrayArray4;
    }

    AtomicConfiguration(int nat, String[] elemname, double[][] cartpos, double[][] latvec) {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        this.rotmat1 = nArrayArray;
        int[][] nArrayArray2 = new int[3][];
        int[] nArray4 = new int[3];
        nArray4[0] = 1;
        nArrayArray2[0] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[1] = 1;
        nArrayArray2[1] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = 1;
        nArrayArray2[2] = nArray6;
        this.rotmat2 = nArrayArray2;
        int[][] nArrayArray3 = new int[3][];
        int[] nArray7 = new int[3];
        nArray7[0] = 1;
        nArray7[2] = -1;
        nArrayArray3[0] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[1] = 1;
        nArrayArray3[1] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[2] = 1;
        nArrayArray3[2] = nArray9;
        this.rotmat3 = nArrayArray3;
        int[][] nArrayArray4 = new int[3][];
        int[] nArray10 = new int[3];
        nArray10[0] = 1;
        nArrayArray4[0] = nArray10;
        int[] nArray11 = new int[3];
        nArray11[1] = 1;
        nArray11[2] = -1;
        nArrayArray4[1] = nArray11;
        int[] nArray12 = new int[3];
        nArray12[2] = 1;
        nArrayArray4[2] = nArray12;
        this.rotmat4 = nArrayArray4;
        this.nat = nat;
        this.elemname = elemname;
        this.cartpos = cartpos;
        this.latvec = latvec;
        this.updateFract();
        this.updateLatticeConstant();
    }

    AtomCoords getAtomCoordsObj() {
        return this.getAtomCoordsObj(true);
    }

    AtomCoords getAtomCoordsObj(boolean newInstance) {
        if (newInstance || this.coords == null) {
            this.coords = new AtomCoords();
        }
        this.coords.isCart(true);
        this.coords.setUnit(2);
        AtomList list = this.coords.getAtomList();
        list.clear();
        double[][] cellVec = this.latvec;
        double[] av = new double[3];
        double[] bv = new double[3];
        double[] cv = new double[3];
        int i = 0;
        while (i < 3) {
            av[i] = cellVec[0][i];
            bv[i] = cellVec[1][i];
            cv[i] = cellVec[2][i];
            ++i;
        }
        Cell cellv = new Cell(av, bv, cv);
        this.coords.setCell(cellv);
        int NumAt = this.nat;
        double[][] fposs = this.fractpos;
        int i2 = 0;
        while (i2 < fposs.length) {
            logger.debug((Object)("fractional pos " + i2 + " " + fposs[i2][0] + ", " + fposs[i2][1] + ", " + fposs[i2][2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < NumAt) {
            String element = this.elemname[i2];
            element = element.split("\\d+")[0].split("\\(")[0];
            logger.debug((Object)("atom :" + i2 + " name: " + element));
            double[] cpos = new double[3];
            int j = 0;
            while (j < 3) {
                cpos[j] = 0.0;
                int k = 0;
                while (k < 3) {
                    cpos[j] = cpos[j] + cellVec[k][j] * fposs[i2][k];
                    ++k;
                }
                ++j;
            }
            Atom at = new Atom(element, cpos);
            list.addAtom(at);
            ++i2;
        }
        return this.coords;
    }

    String[] getElementName() {
        return this.elemname;
    }

    void setCOM(double[] com) {
        this.com = com;
    }

    static AtomicConfiguration getAtomicConfiguration(AtomCoords coor) {
        AtomicConfiguration conf = new AtomicConfiguration();
        conf.mergeAtomCoords(coor);
        return conf;
    }

    public Object clone() {
        int j;
        AtomicConfiguration ret = new AtomicConfiguration();
        ret.setNumAt(this.nat);
        ret.latvec = new double[3][3];
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                ret.latvec[i][j] = this.latvec[i][j];
                ++j;
            }
            ++i;
        }
        ret.updateLatticeConstant();
        i = 0;
        while (i < this.nat) {
            ret.elemname[i] = new String(this.elemname[i]);
            j = 0;
            while (j < 3) {
                ret.cartpos[i][j] = this.cartpos[i][j];
                ++j;
            }
            ++i;
        }
        ret.updateFract();
        return ret;
    }

    double[] getCartJusin(int[] hkl) {
        AtomicConfiguration ac = null;
        ac = (AtomicConfiguration)this.clone();
        ac.swapABC(hkl[0], hkl[1], hkl[2], true);
        return ac.getCartJusin();
    }

    double[] getCartJusin() {
        double[] ret = new double[]{0.0, 0.0, 0.0};
        int i = 0;
        while (i < this.nat) {
            int j = 0;
            while (j < 3) {
                int n = j;
                ret[n] = ret[n] + this.cartpos[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            int n = i++;
            ret[n] = ret[n] / (double)this.nat;
        }
        return ret;
    }

    void mergeAtomCoords(AtomCoords coor) {
        int j;
        int uni = coor.getUnit();
        boolean wasCart = coor.isCart();
        coor.convert(6, 8);
        double[][] cell = coor.getCellDouble(0);
        AtomList alist = coor.getAtomList();
        int nat = alist.getNumAt();
        double[][] cartpos = new double[nat][3];
        int i = 0;
        while (i < nat) {
            cartpos[i] = alist.getAtomAt(i).getDouble();
            ++i;
        }
        String[] elemname = new String[nat];
        int i2 = 0;
        while (i2 < nat) {
            elemname[i2] = alist.getAtomAt(i2).getElementName();
            ++i2;
        }
        this.setNumAt(nat);
        i2 = 0;
        while (i2 < nat) {
            this.elemname[i2] = new String(elemname[i2]);
            j = 0;
            while (j < 3) {
                this.cartpos[i2][j] = cartpos[i2][j];
                ++j;
            }
            ++i2;
        }
        this.latvec = new double[3][3];
        i2 = 0;
        while (i2 < 3) {
            j = 0;
            while (j < 3) {
                this.latvec[i2][j] = cell[i2][j];
                ++j;
            }
            ++i2;
        }
        this.updateFract();
        this.updateLatticeConstant();
        if (!wasCart) {
            coor.convert(7, uni);
        } else {
            coor.convert(6, uni);
        }
    }

    void generateSurface(int h, int k, int l, int sx, int sy, int sz, double vac, double shift, double zoff, boolean perp) {
        int hh = h;
        int kk = k;
        int ll = l;
        if (hh == 0) {
            hh = 1;
        }
        if (kk == 0) {
            kk = 1;
        }
        if (ll == 0) {
            ll = 1;
        }
        this.updateFract();
        this.pack();
        this.toSuper(hh, kk, ll);
        zoff = 0.0;
        double[] jusin = this.getCartJusin(new int[]{h, k, l});
        int i = 0;
        while (i < this.nat) {
            int j = 0;
            while (j < 3) {
                double[] dArray = this.cartpos[i];
                int n = j;
                dArray[n] = dArray[n] - jusin[j];
                ++j;
            }
            ++i;
        }
        this.updateFract();
        this.pack();
        this.swapABC(h, k, l);
        logger.debug((Object)"fract coords");
        i = 0;
        while (i < this.nat) {
            logger.debug((Object)(String.valueOf(this.fractpos[i][0]) + " " + this.fractpos[i][1] + " " + this.fractpos[i][2]));
            ++i;
        }
        logger.debug((Object)"latvec before rotation");
        i = 0;
        while (i < 3) {
            logger.debug((Object)(String.valueOf(this.latvec[i][0]) + " " + this.latvec[i][1] + " " + this.latvec[i][2]));
            ++i;
        }
        this.rotate(h, k, l);
        logger.debug((Object)"latvec after rotation");
        i = 0;
        while (i < 3) {
            logger.debug((Object)(String.valueOf(this.latvec[i][0]) + " " + this.latvec[i][1] + " " + this.latvec[i][2]));
            ++i;
        }
        this.pack();
        this.toSuper(sx, sy, sz);
        this.updateCart();
        this.updateFract();
        this.updateLatticeConstant();
        this.updateLatticeVector();
        this.updateCart();
        if (perp) {
            this.setLatticeConstant(new double[]{this.latconst[0], this.latconst[1], this.latvec[2][2], 90.0, 90.0, this.latconst[5]});
            this.updateLatticeVector();
            this.updateFract();
        }
        Point3f nrm = AtomicConfiguration.getNormalVector(this, new int[]{h, k, l});
        this.doShift(shift, zoff, nrm);
        this.setVacuumLayer(vac);
        logger.debug((Object)this);
    }

    private void setVacuumLayer(double vac) {
        this.latconst[2] = this.latconst[2] + vac;
        this.updateLatticeVector();
        this.updateFract();
    }

    private void doShift(double shift, double offset, Point3f nrm) {
        double[] norm = this.getNorm(2);
        logger.debug((Object)("shift amount : " + shift + ", offset : " + offset));
        logger.debug((Object)("direction of shift: " + norm[0] + ", " + norm[1] + ", " + norm[2]));
        if (!this.reverseShift) {
            int i = 0;
            while (i < this.nat) {
                double[] dArray = this.cartpos[i];
                dArray[2] = dArray[2] + (shift + offset * (double)nrm.z);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nat) {
                double[] dArray = this.cartpos[i];
                dArray[2] = dArray[2] - (shift + offset * (double)nrm.z);
                double[] dArray2 = this.cartpos[i];
                dArray2[2] = dArray2[2] * -1.0;
                ++i;
            }
        }
        this.updateFract();
        this.pack();
    }

    private double[] getNorm(int i) {
        double[] ret = new double[3];
        int j = 0;
        while (j < 3) {
            ret[j] = this.latvec[i][j];
            ++j;
        }
        double n = 0.0;
        int j2 = 0;
        while (j2 < 3) {
            n += ret[j2] * ret[j2];
            ++j2;
        }
        n = Math.sqrt(n);
        j2 = 0;
        while (j2 < 3) {
            int n2 = j2++;
            ret[n2] = ret[n2] / n;
        }
        return ret;
    }

    private static ArrayList<Integer> nonZeroIndices(int[] mill) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int i = 0;
        while (i < 3) {
            if (mill[i] != 0) {
                ret.add(i);
            }
            ++i;
        }
        return ret;
    }

    private static ArrayList<Integer> zeroIndices(int[] mill) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int i = 0;
        while (i < 3) {
            if (mill[i] == 0) {
                ret.add(i);
            }
            ++i;
        }
        return ret;
    }

    static Point3f getNormalVector(AtomicConfiguration conf, int[] mill) {
        double[][] latvec = conf.getLatVec();
        double[][] latvecs = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                latvecs[i][j] = latvec[i][j] * (double)mill[i];
                ++j;
            }
            ++i;
        }
        double[] vec1 = new double[3];
        double[] vec2 = new double[3];
        SurfaceType styp = AtomicConfiguration.getSurfaceType(mill[0], mill[1], mill[2]);
        ArrayList<Integer> nonzero = AtomicConfiguration.nonZeroIndices(mill);
        ArrayList<Integer> zero = AtomicConfiguration.zeroIndices(mill);
        Vector3d vec = new Vector3d();
        if (styp == SurfaceType.ONE_ONE_ONE) {
            int i2 = 0;
            while (i2 < 3) {
                vec1[i2] = latvecs[0][i2] - latvecs[2][i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < 3) {
                vec2[i2] = latvecs[1][i2] - latvecs[2][i2];
                ++i2;
            }
            vec.cross(new Vector3d(vec1), new Vector3d(vec2));
        } else if (styp == SurfaceType.ONE_ONE_ZERO) {
            int i3 = 0;
            while (i3 < 3) {
                vec1[i3] = latvecs[nonzero.get(0)][i3] - latvecs[nonzero.get(1)][i3];
                ++i3;
            }
            Vector3d tvec = new Vector3d();
            tvec.cross(new Vector3d(latvecs[nonzero.get(1)]), new Vector3d(latvecs[nonzero.get(0)]));
            vec2[0] = tvec.x;
            vec2[1] = tvec.y;
            vec2[2] = tvec.z;
            vec.cross(new Vector3d(vec1), new Vector3d(vec2));
        } else if (styp == SurfaceType.ONE_ZERO_ZERO) {
            logger.debug((Object)("zero " + zero.get(0) + ", " + zero.get(1)));
            int i0 = zero.get(0);
            int i1 = zero.get(1);
            logger.debug((Object)("latvecs0 " + latvecs[i0][0] + " " + latvecs[i0][1] + " " + latvecs[i0][2]));
            logger.debug((Object)("latvecs1 " + latvecs[i1][0] + " " + latvecs[i1][1] + " " + latvecs[i1][2]));
            vec1 = conf.getLatVec()[zero.get(0)];
            vec2 = conf.getLatVec()[zero.get(1)];
            logger.debug((Object)("vec1, vec2 : " + vec1[0] + ", " + vec1[1] + ", " + vec1[2] + " " + vec2[0] + ", " + vec2[1] + ", " + vec2[2]));
            vec.cross(new Vector3d(vec1), new Vector3d(vec2));
        } else {
            return null;
        }
        vec.normalize();
        return new Point3f(new float[]{(float)vec.x, (float)vec.y, (float)vec.z});
    }

    void pack(int[][] map) {
        int i = 0;
        while (i < this.nat) {
            int j = 0;
            while (j < 3) {
                if (this.fractpos[i][j] > 1.0) {
                    this.fractpos[i][j] = this.fractpos[i][j] - Math.floor(this.fractpos[i][j]);
                    if (map != null) {
                        int[] nArray = map[i];
                        int n = j;
                        nArray[n] = nArray[n] + 1;
                    }
                } else if (this.fractpos[i][j] < 0.0) {
                    this.fractpos[i][j] = this.fractpos[i][j] + Math.ceil(-this.fractpos[i][j]);
                    if (map != null) {
                        int[] nArray = map[i];
                        int n = j;
                        nArray[n] = nArray[n] - 1;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.updateCart();
    }

    void pack() {
        int[][] map = null;
        this.pack(map);
    }

    void pack(int j, int[][] map) {
        int i = 0;
        while (i < this.nat) {
            if (this.fractpos[i][j] > 1.0) {
                this.fractpos[i][j] = this.fractpos[i][j] - Math.floor(this.fractpos[i][j]);
                if (map != null) {
                    int[] nArray = map[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
            } else if (this.fractpos[i][j] < 0.0) {
                this.fractpos[i][j] = this.fractpos[i][j] + Math.ceil(-this.fractpos[i][j]);
                if (map != null) {
                    int[] nArray = map[i];
                    int n = j;
                    nArray[n] = nArray[n] - 1;
                }
            }
            ++i;
        }
        this.updateCart(j);
    }

    void pack(int j) {
        this.pack(j, null);
    }

    void swapABC(int h, int k, int l) {
        this.swapABC(h, k, l, false);
    }

    void swapABC(int h, int k, int l, boolean invertOnly) {
        int j;
        this.reverseShift = false;
        boolean[] invert = new boolean[3];
        int inda = 0;
        int indb = 1;
        int indc = 2;
        if (h < 0) {
            invert[0] = true;
        }
        if (k < 0) {
            invert[1] = true;
        }
        if (l < 0) {
            invert[2] = true;
        }
        int ii = 0;
        int i = 0;
        while (i < 3) {
            if (invert[i]) {
                ++ii;
            }
            ++i;
        }
        if (ii == 1 || ii == 3) {
            this.reverseShift = true;
        }
        if (AtomicConfiguration.getSurfaceType(h, k, l) == SurfaceType.ONE_ONE_ZERO) {
            i = 0;
            while (i < 3) {
                invert[i] = false;
                ++i;
            }
            if (h == 0) {
                if (k < 0) {
                    invert[1] = true;
                }
                if (l < 0) {
                    invert[2] = true;
                }
            }
            if (k == 0) {
                inda = 1;
                indb = 0;
                indc = 2;
                if (h < 0) {
                    invert[1] = true;
                }
                if (l < 0) {
                    invert[2] = true;
                }
            }
            if (l == 0) {
                inda = 2;
                indb = 1;
                indc = 0;
                if (h < 0) {
                    invert[2] = true;
                }
                if (k < 0) {
                    invert[1] = true;
                }
            }
        }
        if (AtomicConfiguration.getSurfaceType(h, k, l) == SurfaceType.ONE_ZERO_ZERO) {
            i = 0;
            while (i < 3) {
                invert[i] = false;
                ++i;
            }
            if (h != 0) {
                inda = 1;
                indb = 2;
                indc = 0;
                if (h < 0) {
                    invert[2] = true;
                }
            }
            if (k != 0) {
                inda = 0;
                indb = 2;
                indc = 1;
                if (k < 0) {
                    invert[2] = true;
                }
            }
            if (l != 0) {
                inda = 0;
                indb = 1;
                indc = 2;
                if (l < 0) {
                    invert[2] = true;
                }
            }
            if (invert[2]) {
                this.reverseShift = true;
            }
        }
        double[][] pos = new double[this.nat][3];
        double[][] cell = new double[3][3];
        int i2 = 0;
        while (i2 < this.nat) {
            pos[i2][0] = this.fractpos[i2][inda];
            pos[i2][1] = this.fractpos[i2][indb];
            pos[i2][2] = this.fractpos[i2][indc];
            ++i2;
        }
        i2 = 0;
        while (i2 < 3) {
            if (invert[i2]) {
                j = 0;
                while (j < this.nat) {
                    pos[j][i2] = -pos[j][i2];
                    ++j;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < 3) {
            cell[0][i2] = this.latvec[inda][i2];
            cell[1][i2] = this.latvec[indb][i2];
            cell[2][i2] = this.latvec[indc][i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < 3) {
            if (invert[i2]) {
                j = 0;
                while (j < 3) {
                    cell[i2][j] = -cell[i2][j];
                    ++j;
                }
            }
            ++i2;
        }
        if (invertOnly) {
            double[][] tcell = new double[3][3];
            int i3 = 0;
            while (i3 < 3) {
                tcell[inda][i3] = cell[0][i3];
                tcell[indb][i3] = cell[1][i3];
                tcell[indc][i3] = cell[2][i3];
                ++i3;
            }
            cell = tcell;
            double[][] tpos = new double[this.nat][3];
            int i4 = 0;
            while (i4 < this.nat) {
                tpos[i4][inda] = pos[i4][0];
                tpos[i4][indb] = pos[i4][1];
                tpos[i4][indc] = pos[i4][2];
                ++i4;
            }
            pos = tpos;
        }
        this.fractpos = pos;
        this.latvec = cell;
        this.pack();
        this.updateCart();
    }

    static SurfaceType getSurfaceType(int h, int k, int l) {
        int zcount = 0;
        if (h == 0) {
            ++zcount;
        }
        if (k == 0) {
            ++zcount;
        }
        if (l == 0) {
            ++zcount;
        }
        if (zcount == 0) {
            return SurfaceType.ONE_ONE_ONE;
        }
        if (zcount == 1) {
            return SurfaceType.ONE_ONE_ZERO;
        }
        if (zcount == 2) {
            return SurfaceType.ONE_ZERO_ZERO;
        }
        return SurfaceType.INVALID;
    }

    void rotate(int h, int k, int l) {
        SurfaceType styp = AtomicConfiguration.getSurfaceType(h, k, l);
        logger.debug((Object)("surface type " + (Object)((Object)styp)));
        int[] hkl = new int[]{h, k, l};
        if (styp == SurfaceType.ONE_ONE_ONE) {
            this.rotateSub(this.rotmat2, this.rotmat3, hkl);
            this.rotateSub(this.rotmat1, this.rotmat4, hkl);
        } else if (styp == SurfaceType.ONE_ONE_ZERO) {
            this.rotateSub(this.rotmat1, this.rotmat4, hkl);
        }
    }

    void rotateSub(int[][] rotmat, int[][] cellrotmat, int[] hkl) {
        int j;
        int[] pm = new int[]{1, 1, 1};
        int j2 = 0;
        while (j2 < 3) {
            if (hkl[j2] < 0) {
                pm[j2] = -1;
            }
            ++j2;
        }
        int iat = 0;
        while (iat < this.nat) {
            double[] opos = this.fractpos[iat];
            double[] pos = new double[3];
            int i = 0;
            while (i < 3) {
                pos[i] = 0.0;
                int j3 = 0;
                while (j3 < 3) {
                    int n = i;
                    pos[n] = pos[n] + (double)rotmat[i][j3] * opos[j3];
                    ++j3;
                }
                AtomicConfiguration.pack(pos);
                ++i;
            }
            this.fractpos[iat] = pos;
            ++iat;
        }
        double[][] cellvec = this.latvec;
        double[][] newcellvec = new double[3][3];
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                newcellvec[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    double[] dArray = newcellvec[i];
                    int n = j;
                    dArray[n] = dArray[n] + (double)cellrotmat[i][k] * cellvec[k][j] * (double)pm[j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.latvec = newcellvec;
        logger.debug((Object)this);
    }

    void rotateSub(int[][] rotmat, int[][] cellrotmat) {
        int j;
        int iat = 0;
        while (iat < this.nat) {
            double[] opos = this.fractpos[iat];
            double[] pos = new double[3];
            int i = 0;
            while (i < 3) {
                pos[i] = 0.0;
                int j2 = 0;
                while (j2 < 3) {
                    int n = i;
                    pos[n] = pos[n] + (double)rotmat[i][j2] * opos[j2];
                    ++j2;
                }
                AtomicConfiguration.pack(pos);
                ++i;
            }
            this.fractpos[iat] = pos;
            ++iat;
        }
        double[][] cellvec = this.latvec;
        double[][] newcellvec = new double[3][3];
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                newcellvec[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    double[] dArray = newcellvec[i];
                    int n = j;
                    dArray[n] = dArray[n] + (double)cellrotmat[i][k] * cellvec[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.latvec = newcellvec;
        logger.debug((Object)this);
    }

    void toSuper(int sx, int sy, int sz) {
        if (Math.abs(sx) <= 1 && Math.abs(sy) <= 1 && Math.abs(sz) <= 1) {
            return;
        }
        int asx = Math.abs(sx);
        int asy = Math.abs(sy);
        int asz = Math.abs(sz);
        double[][] tmplatvec = new double[3][3];
        int i = 0;
        while (i < 3) {
            tmplatvec[0][i] = (double)asx * this.latvec[0][i];
            tmplatvec[1][i] = (double)asy * this.latvec[1][i];
            tmplatvec[2][i] = (double)asz * this.latvec[2][i];
            ++i;
        }
        int natold = this.nat;
        logger.debug((Object)("sx, sy, sz " + asx + ", " + asy + ", " + asz));
        int i2 = 0;
        while (i2 < this.nat) {
            logger.debug((Object)("curr pos " + this.cartpos[i2][0] + " " + this.cartpos[i2][1] + " " + this.cartpos[i2][2]));
            ++i2;
        }
        double[][] tmpc = this.cartpos;
        String[] tmpe = this.elemname;
        this.setNumAt(this.nat * asx * asy * asz);
        int i3 = 0;
        while (i3 < natold) {
            this.elemname[i3] = tmpe[i3];
            int j = 0;
            while (j < 3) {
                this.cartpos[i3][j] = tmpc[i3][j];
                ++j;
            }
            ++i3;
        }
        int atmcount = natold;
        int iat = 0;
        while (iat < natold) {
            int i4 = 0;
            while (i4 < asx) {
                int j = 0;
                while (j < asy) {
                    int k = 0;
                    while (k < asz) {
                        if (i4 != 0 || j != 0 || k != 0) {
                            this.elemname[atmcount] = this.elemname[iat];
                            int l = 0;
                            while (l < 3) {
                                this.cartpos[atmcount][l] = this.cartpos[iat][l] + (double)i4 * this.latvec[0][l] + (double)j * this.latvec[1][l] + (double)k * this.latvec[2][l];
                                ++l;
                            }
                            ++atmcount;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i4;
            }
            ++iat;
        }
        this.latvec = tmplatvec;
        this.updateFract();
        this.updateLatticeConstant();
    }

    public String toString() {
        String ret = "latvec" + System.getProperty("line.separator");
        int i = 0;
        while (i < 3) {
            ret = String.valueOf(ret) + this.latvec[i][0] + " " + this.latvec[i][1] + " " + this.latvec[i][2] + System.getProperty("line.separator");
            ++i;
        }
        ret = String.valueOf(ret) + "latconst " + System.getProperty("line.separator");
        ret = String.valueOf(ret) + this.latconst[0] + " " + this.latconst[1] + " " + this.latconst[2] + " " + this.latconst[3] + " " + this.latconst[4] + " " + this.latconst[5] + System.getProperty("line.separator");
        ret = String.valueOf(ret) + "atomic coordinates " + System.getProperty("line.separator");
        i = 0;
        while (i < this.nat) {
            ret = String.valueOf(ret) + this.elemname[i] + " " + String.valueOf(this.cartpos[i][0]) + " " + String.valueOf(this.cartpos[i][1]) + " " + String.valueOf(this.cartpos[i][2]) + " " + String.valueOf(this.fractpos[i][0]) + " " + String.valueOf(this.fractpos[i][1]) + " " + String.valueOf(this.fractpos[i][2]) + System.getProperty("line.separator");
            ++i;
        }
        ret = String.valueOf(ret) + String.valueOf(this.nat) + System.getProperty("line.separator");
        ret = String.valueOf(ret) + "debug output" + System.getProperty("line.separator");
        i = 0;
        while (i < this.nat) {
            ret = String.valueOf(ret) + this.elemname[i] + " " + String.valueOf(this.cartpos[i][0]) + " " + String.valueOf(this.cartpos[i][1]) + " " + String.valueOf(this.cartpos[i][2]) + System.getProperty("line.separator");
            ++i;
        }
        return ret;
    }

    void setLatticeVector(double[][] latvec) {
        this.latvec = latvec;
    }

    void setLatticeConstant(double[] latconst) {
        this.latconst = latconst;
    }

    double[][] getNormalizedLatticeVector() {
        double[][] ret = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                ret[i][j] = this.latvec[i][j] / this.latconst[i];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    void updateFract(int ii) {
        double[][] latvect = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                latvect[i][j] = this.latvec[j][i];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nat) {
            double[] Dpos = this.cartpos[i];
            double[][] bvec = new double[3][1];
            int i1 = 0;
            while (i1 < 3) {
                bvec[i1][0] = Dpos[i1];
                ++i1;
            }
            Matrix A = new Matrix(latvect);
            Matrix b = new Matrix(bvec);
            Matrix x = A.solve(b);
            this.fractpos[i][ii] = x.get(ii, 0);
            ++i;
        }
    }

    static double[][] getCart(int nat, double[][] fract, double[][] latvec) {
        double[][] cart = new double[nat][3];
        double[] cp = new double[3];
        int i = 0;
        while (i < nat) {
            int ii = 0;
            while (ii < 3) {
                cp[ii] = 0.0;
                int k = 0;
                while (k < 3) {
                    int n = ii;
                    cp[n] = cp[n] + fract[i][k] * latvec[k][ii];
                    ++k;
                }
                cart[i][ii] = cp[ii];
                ++ii;
            }
            ++i;
        }
        return cart;
    }

    static double[][] getFract(int nat, double[][] cart, double[][] latvec) {
        double[][] latvect = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                latvect[i][j] = latvec[j][i];
                ++j;
            }
            ++i;
        }
        double[][] fractpos = new double[nat][3];
        int i2 = 0;
        while (i2 < nat) {
            double[] Dpos = cart[i2];
            double[][] bvec = new double[3][1];
            int i1 = 0;
            while (i1 < 3) {
                bvec[i1][0] = Dpos[i1];
                ++i1;
            }
            Matrix A = new Matrix(latvect);
            Matrix b = new Matrix(bvec);
            Matrix x = A.solve(b);
            int j = 0;
            while (j < 3) {
                fractpos[i2][j] = x.get(j, 0);
                ++j;
            }
            ++i2;
        }
        return fractpos;
    }

    static void pack(double[] fr) {
        if (fr[2] > 1.0) {
            fr[2] = fr[2] - Math.floor(fr[2]);
        } else if (fr[2] < 0.0) {
            fr[2] = fr[2] + Math.ceil(-fr[2]);
        }
    }

    void updateFract() {
        double[][] latvect = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                latvect[i][j] = this.latvec[j][i];
                ++j;
            }
            ++i;
        }
        this.fractpos = new double[this.nat][3];
        i = 0;
        while (i < this.nat) {
            double[] Dpos = this.cartpos[i];
            double[][] bvec = new double[3][1];
            int i1 = 0;
            while (i1 < 3) {
                bvec[i1][0] = Dpos[i1];
                ++i1;
            }
            Matrix A = new Matrix(latvect);
            Matrix b = new Matrix(bvec);
            Matrix x = A.solve(b);
            int i12 = 0;
            while (i12 < 3) {
                this.fractpos[i][i12] = x.get(i12, 0);
                ++i12;
            }
            ++i;
        }
    }

    void updateCart(int ii) {
        int i = 0;
        while (i < this.nat) {
            double[] cp = new double[3];
            cp[ii] = 0.0;
            int k = 0;
            while (k < 3) {
                int n = ii;
                cp[n] = cp[n] + this.fractpos[i][k] * this.latvec[k][ii];
                ++k;
            }
            this.cartpos[i][ii] = cp[ii];
            ++i;
        }
    }

    void updateCart() {
        this.cartpos = new double[this.nat][3];
        int i = 0;
        while (i < this.nat) {
            double[] cp = new double[3];
            int j = 0;
            while (j < 3) {
                cp[j] = 0.0;
                int k = 0;
                while (k < 3) {
                    int n = j;
                    cp[n] = cp[n] + this.fractpos[i][k] * this.latvec[k][j];
                    ++k;
                }
                ++j;
            }
            this.cartpos[i] = cp;
            ++i;
        }
    }

    void updateLatticeConstant() {
        double[] avec = this.latvec[0];
        double[] bvec = this.latvec[1];
        double[] cvec = this.latvec[2];
        double ar = 0.0;
        double br = 0.0;
        double cr = 0.0;
        int i = 0;
        while (i < 3) {
            ar += Math.pow(avec[i], 2.0);
            br += Math.pow(bvec[i], 2.0);
            cr += Math.pow(cvec[i], 2.0);
            ++i;
        }
        ar = Math.sqrt(ar);
        br = Math.sqrt(br);
        cr = Math.sqrt(cr);
        double cda = 0.0;
        double cdb = 0.0;
        double adb = 0.0;
        int i2 = 0;
        while (i2 < 3) {
            cda += cvec[i2] * avec[i2];
            cdb += cvec[i2] * bvec[i2];
            adb += avec[i2] * bvec[i2];
            ++i2;
        }
        double cosbeta = 0.0;
        double cosalph = 0.0;
        double cosgamm = 0.0;
        double beta = 0.0;
        double alph = 0.0;
        double gamm = 0.0;
        try {
            cosbeta = cda / (cr * ar);
            cosalph = cdb / (cr * br);
            cosgamm = adb / (ar * br);
            beta = Math.acos(cosbeta) * 57.29577951308232;
            alph = Math.acos(cosalph) * 57.29577951308232;
            gamm = Math.acos(cosgamm) * 57.29577951308232;
        }
        catch (Exception e) {
            logger.error((Object)"failed to generate lattice constants");
            return;
        }
        this.latconst = new double[]{ar, br, cr, alph, beta, gamm};
    }

    void updateLatticeVector() {
        double[] cellLength = new double[]{this.latconst[0], this.latconst[1], this.latconst[2]};
        double alpha = this.latconst[3] * (Math.PI / 180);
        double beta = this.latconst[4] * (Math.PI / 180);
        double gamma = this.latconst[5] * (Math.PI / 180);
        double temp = 0.0;
        try {
            int j;
            int i = 0;
            while (i < 3) {
                j = 0;
                while (j < 3) {
                    this.latvec[i][j] = 0.0;
                    ++j;
                }
                ++i;
            }
            this.latvec[0][0] = 1.0;
            this.latvec[1][0] = Math.cos(gamma);
            this.latvec[2][0] = Math.cos(beta);
            this.latvec[1][1] = Math.sin(gamma);
            this.latvec[2][1] = temp = (Math.cos(alpha) - Math.cos(beta) * Math.cos(gamma)) / Math.sin(gamma);
            this.latvec[2][2] = Math.sqrt(Math.sin(beta) * Math.sin(beta) - temp * temp);
            i = 0;
            while (i < 3) {
                j = 0;
                while (j < 3) {
                    double[] dArray = this.latvec[j];
                    int n = i;
                    dArray[n] = dArray[n] * cellLength[j];
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)"failed to generate lattice vectors");
            return;
        }
        logger.debug((Object)(String.valueOf(this.latvec[0][0]) + ", " + this.latvec[0][1] + ", " + this.latvec[0][2]));
        logger.debug((Object)(String.valueOf(this.latvec[1][0]) + ", " + this.latvec[1][1] + ", " + this.latvec[1][2]));
        logger.debug((Object)(String.valueOf(this.latvec[2][0]) + ", " + this.latvec[2][1] + ", " + this.latvec[2][2]));
    }

    void setCartPos(double[][] cartpos) {
        this.setCartPos(cartpos, true, true);
    }

    void setCartPos(double[][] cartpos, boolean updateFract, boolean pack) {
        if (cartpos.length != this.nat) {
            logger.error((Object)("inconsistent number of atoms : " + this.nat + " " + cartpos.length));
            return;
        }
        this.cartpos = cartpos;
        if (updateFract) {
            this.updateFract();
        }
        if (pack) {
            this.pack();
        }
    }

    static enum SurfaceType {
        ONE_ZERO_ZERO,
        ONE_ONE_ZERO,
        ONE_ONE_ONE,
        INVALID;

    }
}

