/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.edit;

import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.ACVAtomEditor;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomSelectionCanvas;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomEditor;
import ciss.phase_viewer.atomcoord.AtomEvent;
import ciss.phase_viewer.atomcoord.AtomListener;
import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.MyJMenu;
import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.viewer.edit.CellPanel;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableRightClickListener;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class AtomConfigPanel
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)AtomConfigPanel.class.getName());
    private MainPanel parent;
    private AtomCoordinatesPanel acp;

    public AtomConfigPanel(MainPanel parent) {
        super("view/edit atomic coordinates", new Dimension(570, 530));
        this.parent = parent;
        parent.addDisposeOnExit(this);
        this.init();
    }

    private void init() {
        Container cont = this.getContentPane();
        cont.setLayout(new BoxLayout(cont, 1));
        JTabbedPane tp = new JTabbedPane();
        this.acp = new AtomCoordinatesPanel(this.parent);
        tp.addTab("atomic configuration", this.acp);
        tp.addTab("unit cell", new CellPanel(this.parent));
        cont.add(tp);
        this.setJMenuBar(new MenuBar(this));
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        ((TGAtom)this.parent.getRootTransform()).removeAtomSelectionCanvas(this.acp);
    }

    class AtomCoordinatesPanel
    extends JPanel
    implements TableModelListener,
    ListSelectionListener,
    TableRightClickListener,
    AtomListener,
    AtomSelectionCanvas,
    ConfigData {
        private Logger logger = Logger.getLogger((String)AtomCoordinatesPanel.class.getName());
        private MainPanel parent;
        private InputInterface inputInterface;
        private ACVData data;
        private TableForInputInterface tfatom;
        private AtomCoords coords;
        private JScrollPane scrPane;
        private JTextField textselect;
        private boolean selecting = false;

        protected AtomCoordinatesPanel(MainPanel parent) {
            this.parent = parent;
            this.data = parent.getData();
            this.inputInterface = this.data.getInputInterface();
            ((TGAtom)this.parent.getRootTransform()).addAtomSelectionCanvas(this);
            this.coords = parent.getCD().getAtomCoords();
            this.setLayout(new BoxLayout(this, 1));
            this.logger.debug((Object)"at AtomCoordinatesPanel.init()");
            try {
                this.init();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            this.logger.debug((Object)"AtomCoordinatesPanel initialized.");
        }

        private void init() {
            this.parent.getCD().register(this);
            this.add(this.createAtomTable());
            this.add(this.createButtons());
        }

        private JPanel createAtomTable() {
            JPanel p_atom_all = new JPanel();
            p_atom_all.setLayout(new BoxLayout(p_atom_all, 1));
            String[] atmtag = new String[]{this.data.getTag()};
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            int[] map = nArray;
            this.tfatom = new TableForInputInterface(this.coords, atmtag, this.inputInterface, map, this);
            ((DefaultTableModel)this.tfatom.getModel()).addTableModelListener(this);
            JPanel panelAtom = new JPanel();
            panelAtom.setLayout(new BoxLayout(panelAtom, 1));
            panelAtom.add(this.tfatom.getPanel());
            this.scrPane = new JScrollPane();
            this.scrPane.getViewport().setView(this.tfatom.getPanel());
            p_atom_all.add(this.scrPane);
            this.tfatom.addTableRightClickListener(this);
            return p_atom_all;
        }

        private JPanel createButtons() {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.add(this.buttons1());
            return p;
        }

        private JPanel buttons1() {
            this.textselect = new JTextField(7);
            JButton btnselect = new JButton("select");
            JPanel pselect = new JPanel();
            pselect.setLayout(new BoxLayout(pselect, 0));
            pselect.add(this.textselect);
            pselect.add(btnselect);
            btnselect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String foo = AtomCoordinatesPanel.this.textselect.getText();
                    if (foo == null || foo.trim().length() == 0) {
                        return;
                    }
                    if (!Utils.isNumber(foo)) {
                        AtomCoordinatesPanel.this.logger.error((Object)"enter a positve integer.");
                        return;
                    }
                    AtomCoordinatesPanel.this.selectAtomTableRow(AtomCoordinatesPanel.this.tfatom.getLocation(), Integer.parseInt(foo));
                }
            });
            JButton btneditatom = new JButton("edit selected atom");
            btneditatom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AtomCoordinatesPanel.this.tfatom.getSelectedRow();
                    if (row >= 0) {
                        AtomCoordinatesPanel.this.bootAtomEditor(row);
                    } else {
                        AtomCoordinatesPanel.this.logger.info((Object)"no atom selected.");
                    }
                }
            });
            JButton btnremove = new JButton("remove selected atom");
            btnremove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomCoordinatesPanel.this.removeSelectedAtom();
                }
            });
            JButton btnadd = new JButton("add new atom");
            btnadd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomCoordinatesPanel.this.addNewAtom();
                }
            });
            JPanel paneledit = new JPanel();
            paneledit.setLayout(new BoxLayout(paneledit, 0));
            paneledit.setBorder(new TitledBorder("edit atomic configuration"));
            paneledit.add(pselect);
            paneledit.add(btneditatom);
            paneledit.add(btnadd);
            paneledit.add(btnremove);
            return paneledit;
        }

        private JPanel buttons2() {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            JButton btnsave = new JButton("save");
            btnsave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomCoordinatesPanel.this.coords.atomCoords2InputInterface(AtomCoordinatesPanel.this.parent.getData().getInputInterface(), AtomCoordinatesPanel.this.parent.getData().getTag());
                }
            });
            panel.add(btnsave);
            JButton btnundo = new JButton("undo");
            btnundo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomCoordinatesPanel.this.coords.getAtomList().undo();
                }
            });
            panel.add(btnundo);
            JButton btnredo = new JButton("redo");
            btnredo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomCoordinatesPanel.this.coords.getAtomList().redo();
                }
            });
            panel.add(btnredo);
            return panel;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            Command command = (Command)e.getSource();
            command.execute(e);
            this.logger.debug((Object)("coords: " + this.coords));
            this.parent.getCD().setCoords(this.coords);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.selecting) {
                return;
            }
            this.logger.debug((Object)"list selection!");
            this.logger.debug((Object)e);
            int last = e.getLastIndex();
            this.parent.selectedRow(this.tfatom.getSelectedRow());
        }

        @Override
        public void tableRightClicked(Point point, String command) {
            if (command.equals("edit")) {
                this.bootAtomEditor(this.tfatom.rowAtPoint(point));
            } else if (command.equals("delete")) {
                ((DefaultTableModel)this.tfatom.getModel()).removeRow(this.tfatom.rowAtPoint(point));
            } else if (command.equals("select")) {
                String res = JOptionPane.showInputDialog(Desk.getDesktop(), "enter a row number", "row selection", 1);
                if (!Utils.isNumber(res)) {
                    this.logger.error((Object)"enter a positve integer.");
                    return;
                }
                this.selectAtomTableRow(point, Integer.parseInt(res));
            } else if (command.equals("new")) {
                this.bootAtomEditor(this.tfatom.rowAtPoint(point), true);
            }
        }

        private void bootAtomEditor(int row) {
            this.bootAtomEditor(row, false);
        }

        private void bootAtomEditor(int row, boolean newAtom) {
            Atom atom = this.coords.getAtomList().getAtomAt(row);
            this.logger.debug((Object)atom);
            ACVAtomEditor editor = new ACVAtomEditor(this.inputInterface.getInputInterfaceTableSpecManager().getTableSpec(this.data.getTag()).getTableColumns(), atom, newAtom, row, "edit attributes for atom no. " + new Integer(row + 1), new Dimension(400, 250), this.parent);
            editor.addAtomListener(this);
            this.parent.addDisposeOnExit(editor);
        }

        private void selectAtomTableRow(Point point, int num) {
            int old = this.tfatom.rowAtPoint(point);
            if (num == 0) {
                num = 1;
            }
            if (num >= this.tfatom.getRowCount()) {
                this.logger.error((Object)"exceeded max. row number.");
                return;
            }
            this.tfatom.setRowSelectionInterval(num - 1, num - 1);
            int rowHeight = this.tfatom.getRowHeight();
            int geta = rowHeight * (this.tfatom.getSelectedRow() - old);
            Point newPoint = new Point(point.x, point.y + geta);
            this.scrPane.getViewport().setViewPosition(newPoint);
            this.revalidate();
        }

        @Override
        public void atomStateChanged(AtomEvent e) {
            this.coords.saveState();
            Atom atom = e.getAtom();
            int ind = e.getIndex();
            if (ind < 0) {
                try {
                    ind = this.coords.getAtomList().size();
                }
                catch (Exception exc) {
                    this.logger.error((Object)"atom coords not allocated?");
                }
            }
            if (ind < this.coords.getNumAt()) {
                this.coords.getAtomList().replaceAtomAt(ind, atom);
            } else {
                this.coords.getAtomList().addAtom(atom);
            }
            this.logger.debug((Object)("atom now: " + this.coords.getAtomList().getAtomAt(ind)));
            this.logger.debug((Object)e);
            this.parent.getCD().setCoords(this.coords);
            this.selectAtomTableRow(this.tfatom.getLocation(), ind + 1);
            this.coords.finalizeState();
        }

        private void addNewAtom() {
            AtomEditor editor = new AtomEditor(this.inputInterface.getInputInterfaceTableSpecManager().getTableSpec(this.data.getTag()).getTableColumns(), "edit attributes for new atom", new Dimension(400, 250));
            editor.addAtomListener(this);
        }

        private void removeSelectedAtom() {
            int[] rows = this.tfatom.getSelectedRows();
            if (rows != null) {
                int i = 0;
                while (i < rows.length) {
                    int targetRow = rows[i];
                    ((DefaultTableModel)this.tfatom.getModel()).removeRow(targetRow);
                    ++i;
                }
            }
        }

        @Override
        public void configDataUpdate() {
            if (this.tfatom != null) {
                this.coords = this.parent.getCD().getAtomCoords();
                this.tfatom.removeListeners();
                this.coords.updateTable(this.tfatom.getModel(), null);
                this.tfatom.restoreListeners();
            }
        }

        @Override
        public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
            this.configDataUpdate();
        }

        @Override
        public boolean needsUpdate() {
            return true;
        }

        @Override
        public void selected(AtomObject obj) {
            this.logger.debug((Object)("selected atom: " + obj.getIDint()));
            this.selecting = true;
            this.selectAtomTableRow(this.tfatom.getLocation(), obj.getIDint());
            this.selecting = false;
        }

        @Override
        public void deselected(AtomObject obj) {
        }

        @Override
        public void deselectAll() {
        }
    }

    class MenuBar
    extends JMenuBar {
        private JInternalFrame frame;

        protected MenuBar(JInternalFrame frame) {
            this.frame = frame;
            this.init();
        }

        private void init() {
            MyJMenu file = new MyJMenu("File", 70);
            MyJMenuItem exit = new MyJMenuItem("exit", 88);
            file.add(exit);
            this.add(file);
            exit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuBar.this.frame.dispose();
                }
            });
        }
    }
}

