/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.resultsviewerpanel;

import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class EpsOutPanel
extends ProjectManipulator
implements OutputParserListener {
    private Logger logger = Logger.getLogger((String)EpsOutPanel.class.getName());
    private OutputParser parser;

    public EpsOutPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        this.setLayout(new BoxLayout(this, 1));
    }

    @Override
    public void recreate() {
        this.projectInfo.getOutputInterface().initCache();
        this.init();
        this.revalidate();
    }

    @Override
    public void parseFinished() {
        this.removeAll();
        JPanel button = new JPanel();
        button.setBorder(new TitledBorder("eps.pl"));
        button.setLayout(new FlowLayout());
        JButton btnepspl = new JButton("run eps.pl");
        JPanel dataPanel = this.projectInfo.getOutputInterface().getDataPanel("F_EPSOUT");
        this.add(dataPanel);
        this.revalidate();
        btnepspl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EpsOutPanel.this.bootEpsPlPanel();
            }
        });
    }

    @Override
    public void initializeProject() {
    }

    @Override
    public void init() {
        this.removeAll();
        String fname = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.projectInfo.getChaseFileManager().getFile("F_EPSOUT").getFileName();
        if (!new File(fname).exists()) {
            this.add(new NoFilePanel("F_EPSOUT"));
            return;
        }
        this.add(new LoadingFilePanel("F_EPSOUT"));
        if (this.parser == null) {
            this.parser = this.projectInfo.getOutputInterface().getParser("F_EPSOUT", this);
        }
        this.parser.setParsed(false);
        this.parser.doParse();
    }

    private JPanel createEpsOutPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel panelmode = new JPanel();
        panelmode.setLayout(new BoxLayout(panelmode, 0));
        String[] modes = new String[]{"total", "atom", "layer"};
        JComboBox<String> checkMode = new JComboBox<String>(modes);
        InputPanel width = new InputPanel("width", 0, 5);
        JCheckBox checkFermi = new JCheckBox("with_fermi");
        JCheckBox checkColor = new JCheckBox("");
        return panel;
    }

    private void bootEpsPlPanel() {
    }
}

