/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.stdout;

import ciss.phase_viewer.plugins.projectmanipulator.stdout.JobStatusMonitor;
import ciss.phase_viewer.plugins.projectmanipulator.stdout.StdoutUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class JobStatusPanel
extends JPanel {
    private Logger logger = Logger.getLogger((String)JobStatusPanel.class.getName());
    private ProjectInfo projectInfo;
    private String baseDir;
    private String jobstatusPrefix = "jobstatus";
    private JComboBox jobnoCombo;
    private JPanel timePanel;
    private boolean bjobs = true;
    private JobStatusMonitor monitor;

    public JobStatusPanel(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
        this.baseDir = String.valueOf(projectInfo.getProjectDirectory()) + System.getProperty("file.separator");
        this.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        Vector jobs = StdoutUtils.getStdoutFiles(this.baseDir);
        boolean bl = this.bjobs = jobs.size() != 0;
        if (this.bjobs) {
            JPanel general = new JPanel();
            general.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            Vector<String> extensions = new Vector<String>();
            int i = 0;
            while (i < jobs.size()) {
                extensions.addElement(StdoutUtils.getExtensionOfStdout((String)jobs.elementAt(i)));
                ++i;
            }
            this.jobnoCombo = new JComboBox(extensions);
            JPanel pjobnoCombo = new JPanel();
            pjobnoCombo.setBorder(new TitledBorder("job no."));
            pjobnoCombo.add(this.jobnoCombo);
            this.timePanel = new JPanel();
            this.timePanel.setBorder(new TitledBorder("program start time"));
            this.timePanel.setLayout(new FlowLayout());
            c.fill = 2;
            c.weightx = 0.1;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.gridx = 1;
            c.gridy = 0;
            general.add((Component)this.timePanel, c);
            JPanel jstat = new JPanel();
            if (!this.checkJobStatusFiles()) {
                JLabel nojs = new JLabel("(no job status file)");
                jstat.add(nojs);
            } else {
                this.monitor = new JobStatusMonitor(projectInfo);
                jstat.add(this.monitor);
            }
            cons.weightx = 1.0;
            cons.gridx = 0;
            cons.gridy = 0;
            this.add((Component)general, cons);
            cons.gridx = 0;
            cons.gridy = 1;
            this.add((Component)jstat, cons);
            this.jobnoCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String output = "output" + (String)JobStatusPanel.this.jobnoCombo.getSelectedItem();
                    JobStatusPanel.this.recreate(output);
                }
            });
            try {
                this.jobnoCombo.setSelectedIndex(this.jobnoCombo.getItemCount() - 1);
            }
            catch (Exception exc) {
                this.logger.error((Object)"operation failed...");
                exc.printStackTrace();
            }
        } else {
            JLabel not_available = new JLabel("(log file not available)");
            this.add(not_available);
            this.add(new JPanel());
            this.revalidate();
        }
    }

    public void setFileName(String output) {
        this.recreate(output);
    }

    private void recreate(String output) {
        String path = String.valueOf(this.baseDir) + output;
        String name = output;
        if (new File(output).isAbsolute()) {
            path = output;
            name = new File(output).getName();
        }
        String time = StdoutUtils.getTimeFrom(path);
        JLabel timeLabel = new JLabel(time);
        this.logger.debug((Object)("time: " + time));
        this.timePanel.removeAll();
        this.timePanel.add(timeLabel);
        if (this.monitor != null) {
            this.monitor.setExtension(StdoutUtils.getExtensionOfStdout(name));
        }
        this.revalidate();
    }

    private boolean checkJobStatusFiles() {
        File baseFile = new File(this.baseDir);
        File[] files = baseFile.listFiles();
        if (files == null || files.length == 0) {
            this.logger.warn((Object)("no files in project directory: " + this.baseDir));
            return false;
        }
        String jobstatReg = String.valueOf(this.jobstatusPrefix) + "\\d+";
        Vector<String> jobstatusFiles = new Vector<String>();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            this.logger.debug((Object)("file.getName, reg: " + file.getName() + " " + jobstatReg));
            if (file.getName().matches(jobstatReg)) {
                jobstatusFiles.addElement(file.getName());
            }
            ++i;
        }
        return jobstatusFiles.size() != 0;
    }
}

