/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.parsers;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Output000Parser
extends OutputParser {
    private Logger logger = Logger.getLogger((String)Output000Parser.class.getName());
    private Vector energyData = new Vector();
    private Vector chargeData = new Vector();
    private Vector cpuData = new Vector();
    private Vector stressData = new Vector();
    private String energy_start_tag = "TOTAL ENERGY FOR";
    private String energy_start_tag2 = "KI=";
    private String energy_start_tag3 = "NL=";
    private String energy_start_tag4 = "PHYSICALLY CORRECT";
    private String CPU_start_tag = "<< CPU";
    private String CPU_end_tag = "Total cpu";
    private String charge_start_tag = "!NEW total charge";
    private String stress_start_tag = "STRESS TENSOR";
    private boolean in_energy = false;
    private boolean in_cpu = false;
    private String npes_start = "npes =";
    private String neg_kv3_start = "!|| neg";
    private String fermi_start = "EFermi";
    private String is_metallic_start = "--- The system is";
    private String eigen_start = "======  Energy Eigen Values ======";
    private String occup_start = "======  Occupations ======";
    private String num_bands_start = "!** num_bands";
    private String num_kpoints_in_irrbz = "number of k-points in irreducible BZ";
    private String kpoints_generated_tag = "=== k-points generated";
    private String[] kind;
    private String[][] kpoint;
    private String[][] eigen_values;
    private String[][] occupations;
    int num_bands = 0;
    int num_kpoints = 0;
    private String NA;
    private String neg = this.NA = "(not available)";
    private String kv3 = this.NA;
    private String fermi = this.NA;
    private String is_metallic = this.NA;
    private String npes = "---";
    private String nk = "---";
    private String ne = "---";
    private String[] charge_ident = new String[]{"iteration", "up", "down", "sum"};
    private String[] stress_ident = new String[]{"xx,xy,xz", "yx,yy,yz", "zx,zy,zz"};
    private String iter;
    private String total_energy;
    private String edelt;
    private String KI;
    private String HA;
    private String XC;
    private String LO;
    private String NL;
    private String EW;
    private String PC;
    private String EN;
    private String physically_correct_energy;
    private String[] energy_ident = new String[]{"iteration", "total energy", "edelt", "KI", "HA", "XC", "LO", "NL", "EW", "PC", "EN", "corrected energy"};
    private String[] cpu_idents = new String[]{"iter", "rank", "sub.name", "(sec.)", "(%)", "count"};

    public Output000Parser(String fileName) {
        super(fileName);
        this.invokeNewThread = false;
    }

    @Override
    protected boolean parse() {
        block11: {
            block10: {
                String line = "";
                try {
                    FileReader freader = new FileReader(this.fileName);
                    this.reader = new LineNumberReader(freader);
                    while ((line = this.reader.readLine()) != null) {
                        this.parseLine(line.trim());
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    this.isDone = true;
                    break block10;
                }
                catch (Exception exc) {
                    try {
                        exc.printStackTrace();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.isDone = true;
                    }
                }
                this.isDone = true;
            }
            super.initializeOutputDataVector();
            String[][] energy2d = null;
            if (this.energyData.size() == 0) break block11;
            energy2d = new String[this.energyData.size()][this.energy_ident.length];
            this.energyData.copyInto((Object[])energy2d);
            this.energyData = new Vector();
            OutputData energy = new OutputData("stdout(energy)", "energy at each SCF step", this.energy_ident, energy2d, "");
            energy.setFileName(this.fileName);
            super.addOutputData(energy);
        }
        String[][] cpu2d = null;
        if (this.cpuData.size() != 0) {
            cpu2d = new String[this.cpuData.size()][this.cpu_idents.length];
            this.cpuData.copyInto((Object[])cpu2d);
            this.cpuData = new Vector();
            OutputData cpu = new OutputData("stdout(time)", "cpu statistics", this.cpu_idents, cpu2d, "");
            cpu.setFileName(this.fileName);
            super.addOutputData(cpu);
        }
        if (this.chargeData.size() != 0) {
            String[][] charge2d = new String[this.chargeData.size()][this.charge_ident.length];
            this.chargeData.copyInto((Object[])charge2d);
            this.chargeData = new Vector();
            OutputData outputData = new OutputData("spin density", "spin density at each SCF step", this.charge_ident, charge2d, "");
            outputData.setFileName(this.fileName);
            super.addOutputData(outputData);
        }
        return true;
    }

    private void parseLine(String line) {
        if (line.startsWith(this.energy_start_tag)) {
            this.in_energy = true;
        }
        if (line.startsWith(this.CPU_start_tag)) {
            this.in_cpu = true;
        }
        if (this.in_energy) {
            this.parseEnergy(line);
        }
        if (this.in_cpu) {
            this.parseCPU(line);
        }
        if (line.equals(this.stress_start_tag)) {
            this.parseStress(line);
        }
        if (line.startsWith(this.charge_start_tag)) {
            this.parseCharge(line);
        }
        if (line.startsWith(this.npes_start)) {
            this.parseNproc(line);
        }
        if (line.startsWith(this.neg_kv3_start)) {
            this.parseNeKv3(line);
        }
        if (line.startsWith(this.num_bands_start)) {
            this.parseNumBands(line);
        }
        if (line.startsWith(this.is_metallic_start)) {
            this.parseIsMetallic(line);
        }
        if (line.startsWith(this.fermi_start)) {
            this.parseFermi(line);
        }
        if (line.startsWith(this.eigen_start)) {
            this.parseEigen(line);
        }
        if (line.startsWith(this.occup_start)) {
            this.parseOccup(line);
        }
        if (line.startsWith(this.num_kpoints_in_irrbz)) {
            this.parseNumKpoints(line);
        }
        if (line.startsWith(this.kpoints_generated_tag)) {
            this.parseKpointsGenerated(line);
        }
    }

    private void parseKpointsGenerated(String line) {
        try {
            String li;
            int nkp = -1;
            this.reader.readLine();
            while ((li = this.reader.readLine()) != null) {
                String[] kpoints = li.trim().split("\\s+");
                this.logger.debug((Object)("kpoints[0]: " + kpoints[0]));
                try {
                    nkp = Integer.parseInt(kpoints[0]);
                }
                catch (NumberFormatException nfe) {
                    if (nkp > 0) {
                        this.kv3 = String.valueOf(nkp);
                    }
                    break;
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void parseNumBands(String line) {
        String[] arline = line.split("\\s+");
        if (arline == null || arline.length < 4) {
            return;
        }
        this.neg = arline[3];
    }

    private void parseEigen(String line) {
        this.logger.debug((Object)"eigenparse start");
        try {
            this.logger.debug((Object)("neg, kv3 prior to parseInt: " + this.neg + ", " + this.kv3));
            this.num_bands = Integer.parseInt(this.neg);
            this.num_kpoints = Integer.parseInt(this.kv3);
            this.logger.debug((Object)("num_bands & num_kpoints: " + this.num_bands + " " + this.num_kpoints));
        }
        catch (NumberFormatException npe) {
            return;
        }
        if (this.num_bands == 0 || this.num_kpoints == 0) {
            return;
        }
        this.kpoint = new String[this.num_kpoints][4];
        this.eigen_values = new String[this.num_kpoints][this.num_bands];
        this.parseEachNegandKpoint(this.eigen_values);
    }

    private void parseOccup(String line) {
        if (this.num_bands == 0 || this.num_kpoints == 0) {
            return;
        }
        this.occupations = new String[this.num_kpoints][this.num_bands];
        this.parseEachNegandKpoint(this.occupations);
    }

    private void parseEachNegandKpoint(String[][] array2d) {
        String[] ark = null;
        int bandCount = 0;
        int kpointCount = 0;
        boolean readKpoint = false;
        try {
            String foo;
            block3: while ((foo = this.reader.readLine()) != null && foo.trim().length() != 0) {
                ark = foo.trim().split("\\s+");
                if (ark == null) {
                    return;
                }
                if (!readKpoint) {
                    if (ark.length == 4) {
                        this.kpoint[kpointCount][0] = "    ";
                        this.kpoint[kpointCount][1] = ark[1];
                        this.kpoint[kpointCount][2] = ark[2];
                        this.kpoint[kpointCount][3] = ark[3];
                    } else if (ark.length == 5) {
                        String WS = "";
                        if (ark[1].equals("UP")) {
                            WS = "      ";
                        }
                        this.kpoint[kpointCount][0] = String.valueOf(ark[1]) + WS;
                        this.kpoint[kpointCount][1] = ark[2];
                        this.kpoint[kpointCount][2] = ark[3];
                        this.kpoint[kpointCount][3] = ark[4];
                    }
                    readKpoint = true;
                    continue;
                }
                int i = 0;
                while (i < ark.length) {
                    array2d[kpointCount][bandCount] = ark[i];
                    if (++bandCount == this.num_bands) {
                        bandCount = 0;
                        readKpoint = false;
                        if (++kpointCount != this.num_kpoints) continue block3;
                        return;
                    }
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            this.logger.error((Object)"failed read");
            ioe.printStackTrace();
            return;
        }
        catch (ArrayIndexOutOfBoundsException aio) {
            this.logger.error((Object)"inconsistent neg/kv3");
            aio.printStackTrace();
            return;
        }
    }

    private void parseNeKv3(String line) {
        String[] arline = line.split("\\s+");
        if (arline.length < 6) {
            return;
        }
        this.neg = arline[4];
        this.kv3 = arline[5];
    }

    private void parseNumKpoints(String line) {
        String[] arline = line.split("=");
        if (arline.length < 2) {
            return;
        }
        this.kv3 = arline[1].trim();
    }

    private void parseFermi(String line) {
        String[] arline = line.split("\\s+");
        if (arline.length < 3) {
            return;
        }
        this.fermi = arline[2];
    }

    private void parseIsMetallic(String line) {
        String[] arline = line.split("\\s+");
        if (arline.length < 5) {
            return;
        }
        if (arline[4].startsWith("meta")) {
            this.is_metallic = "yes";
        } else if (arline[4].startsWith("insu")) {
            this.is_metallic = "no";
        }
    }

    @Override
    public String[] getGenericData(String key) {
        try {
            int index;
            String[] foo;
            if (key.equals("nproc")) {
                return this.getNpNeNk();
            }
            if (key.equals("negkv3")) {
                return new String[]{this.neg, this.kv3};
            }
            if (key.equals("fermi")) {
                return new String[]{this.fermi, this.is_metallic};
            }
            if (key.startsWith("kpoint_")) {
                String[] foo2 = key.split("_");
                int index2 = Integer.parseInt(foo2[1]);
                return this.kpoint[index2];
            }
            if (key.startsWith("occup_")) {
                foo = key.split("_");
                index = Integer.parseInt(foo[1]);
                if (this.occupations != null) {
                    return this.occupations[index];
                }
            }
            if (key.startsWith("eigen_")) {
                foo = key.split("_");
                index = Integer.parseInt(foo[1]);
                return this.eigen_values[index];
            }
            if (key.startsWith("num_kpoints")) {
                return new String[]{String.valueOf(this.num_kpoints)};
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return super.getGenericData(key);
    }

    @Override
    public String[][] getGenericData2D(String key) {
        if (key.equals("stress") && this.stressData.size() != 0) {
            String[][] stress2d = new String[this.stressData.size()][this.stress_ident.length];
            this.stressData.copyInto((Object[])stress2d);
            return stress2d;
        }
        return super.getGenericData2D(key);
    }

    private void parseNproc(String line) {
        String[] arline = line.split("\\s+");
        int readCount = 0;
        if (line.startsWith(this.npes_start) && arline.length >= 3) {
            this.npes = arline[2];
        }
        String tmpline = "";
        try {
            do {
                if (!(tmpline = this.reader.readLine().trim()).trim().startsWith("ne")) continue;
                String[] ar = tmpline.split("\\s+");
                if (ar == null || ar.length < 5) {
                    return;
                }
                this.ne = ar[3];
                this.nk = ar[4];
                return;
            } while (++readCount < 10);
            return;
        }
        catch (IOException ioe) {
            this.logger.error((Object)"failed to parse np, ne and nk");
            return;
        }
    }

    public String[] getNpNeNk() {
        return new String[]{this.npes, this.ne, this.nk};
    }

    private void parseCharge(String line) {
        String[] chdata = line.split("\\s+");
        if (chdata.length < 12) {
            return;
        }
        String[] ch = new String[]{this.iter, chdata[7], chdata[9], chdata[11]};
        this.chargeData.addElement(ch);
    }

    private void parseStress(String line) {
        this.stressData = new Vector();
        try {
            String xstr = this.reader.readLine().trim();
            String ystr = this.reader.readLine().trim();
            String zstr = this.reader.readLine().trim();
            this.logger.debug((Object)"xstr,ystr,zstr");
            this.logger.debug((Object)xstr);
            this.logger.debug((Object)ystr);
            this.logger.debug((Object)zstr);
            String[] x = xstr.split("\\s+");
            String[] y = ystr.split("\\s+");
            String[] z = zstr.split("\\s+");
            this.stressData.addElement(x);
            this.stressData.addElement(y);
            this.stressData.addElement(z);
        }
        catch (Exception exc) {
            this.logger.error((Object)"failed to parse stress tensor.");
            exc.printStackTrace();
        }
    }

    private void parseEnergy(String line) {
        String[] arline = line.split("\\s+");
        if (line.startsWith(this.energy_start_tag)) {
            if (arline.length >= 10) {
                this.iter = arline[3];
                this.total_energy = arline[6];
                this.edelt = arline[9];
            }
            return;
        }
        if (line.startsWith(this.energy_start_tag2)) {
            if (arline.length >= 8) {
                this.KI = arline[1];
                this.HA = arline[3];
                this.XC = arline[5];
                this.LO = arline[7];
            }
            return;
        }
        if (line.startsWith(this.energy_start_tag3)) {
            if (arline.length >= 8) {
                this.NL = arline[1];
                this.EW = arline[3];
                this.PC = arline[5];
                this.EN = arline[7];
            }
            return;
        }
        if (line.startsWith(this.energy_start_tag4) && arline.length >= 5) {
            this.physically_correct_energy = arline[4];
        }
        this.in_energy = false;
        String[] rowData = new String[]{this.iter, this.total_energy, this.edelt, this.KI, this.HA, this.XC, this.LO, this.NL, this.EW, this.PC, this.EN, this.physically_correct_energy};
        this.energyData.addElement(rowData);
    }

    private void parseCPU(String line) {
        String newLine = "";
        int num_line = 0;
        int max_line = 12;
        try {
            String newL;
            while ((newL = this.reader.readLine()) != null && newL.trim().length() != 0) {
                String[] arline;
                newLine = newL.trim();
                ++num_line;
                String iter_cpu = "";
                String total = "";
                String total_accum = "";
                String rank = "";
                String subname = "";
                String sec = "";
                String percentage = "";
                String occurance = "";
                if (newLine.startsWith("no") || (arline = newLine.split("\\s+")).length < 6) continue;
                if (Utils.isNumber(arline[0])) {
                    rank = arline[0];
                    int nextind = 4;
                    int i = 2;
                    block5: while (i < arline.length) {
                        char[] chary = arline[i].toCharArray();
                        int j = 0;
                        while (j < chary.length) {
                            if (Character.isDigit(chary[j])) {
                                nextind = i;
                                break block5;
                            }
                            ++j;
                        }
                        subname = String.valueOf(subname) + arline[i];
                        ++i;
                    }
                    String tmp = arline[nextind];
                    if (tmp.indexOf("sec") > 0) {
                        char[] tmpar = tmp.toCharArray();
                        this.logger.debug((Object)("tmp str here: " + tmp));
                        sec = new String(tmpar, 0, tmpar.length - 6);
                    } else {
                        sec = tmp;
                    }
                    String tmpper = arline[nextind + 1];
                    this.logger.debug((Object)("and tmp str here: " + tmpper));
                    if (tmpper.indexOf("%") > 0) {
                        char[] tmpar2 = tmpper.toCharArray();
                        percentage = new String(tmpar2, 0, tmpar2.length - 3);
                    } else {
                        percentage = tmpper;
                    }
                    occurance = arline[nextind + 2];
                }
                if (newLine.startsWith(this.CPU_end_tag) || num_line >= max_line) {
                    if (arline.length <= 5) break;
                    this.iter = arline[5];
                    break;
                }
                String[] row_cpu = new String[]{this.iter, rank, subname, sec, percentage, occurance};
                this.cpuData.addElement(row_cpu);
            }
            this.in_cpu = false;
        }
        catch (IOException ioe) {
            this.logger.error((Object)"failed to extract 'CPU statistics' from stdout file.");
        }
        catch (ArrayIndexOutOfBoundsException aiob) {
            aiob.printStackTrace();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    @Override
    public String getCurrentMessage() {
        return null;
    }
}

