/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel;

import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cube2AtomCoords;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.common.CoordsViewerBooter;
import ciss.phase_viewer.common.MyThread;
import ciss.phase_viewer.common.MyThreadListener;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class WorkFuncPanel
extends ProjectManipulator {
    private Logger logger = Logger.getLogger((String)WorkFuncPanel.class.getName());
    private String nfvlc = "nfvlc.data";
    private String nfcntn = "continue_bin_stm.data";
    private String vlcav = "nfvlcr_av.data";
    private String vlcr = "nfvlcr.cube";
    private File nfvlcFile;
    private File nfcntnFile;
    private File vlcavFile;
    private File vlcrFile;
    private OutputParser parser;

    public WorkFuncPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public void initializeProject() {
    }

    @Override
    public void init() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.add(new WorkFuncPanelPanel());
    }

    class WorkFuncPanelPanel
    extends JPanel
    implements ACVCaller,
    OutputParserListener,
    MyThreadListener {
        private JPanel pres;
        private JComboBox axisCombo;
        private String[] axisChoice = new String[]{"               x               ", "               y               ", "               z               "};
        private JComboBox spinCombo;
        private String[] spinChoice = new String[]{"1", "2"};
        private JButton runWFButton;

        WorkFuncPanelPanel() {
            this.setLayout(new BorderLayout());
            WorkFuncPanel.this.nfvlcFile = new File(String.valueOf(WorkFuncPanel.this.projectInfo.getProjectDirectory()) + FS + WorkFuncPanel.this.nfvlc);
            WorkFuncPanel.this.nfcntnFile = new File(String.valueOf(WorkFuncPanel.this.projectInfo.getProjectDirectory()) + FS + WorkFuncPanel.this.nfcntn);
            WorkFuncPanel.this.vlcavFile = new File(String.valueOf(WorkFuncPanel.this.projectInfo.getProjectDirectory()) + FS + WorkFuncPanel.this.vlcav);
            WorkFuncPanel.this.vlcrFile = new File(String.valueOf(WorkFuncPanel.this.projectInfo.getProjectDirectory()) + FS + WorkFuncPanel.this.vlcr);
            this.init();
            if (WorkFuncPanel.this.vlcavFile.exists()) {
                if (WorkFuncPanel.this.parser == null) {
                    WorkFuncPanel.this.parser = WorkFuncPanel.this.projectInfo.getOutputInterface().getParser("F_VLCRAV", this);
                }
                WorkFuncPanel.this.parser.setParsed(false);
                WorkFuncPanel.this.parser.doParse();
            }
        }

        private void addVLCAVPanel() {
            this.pres.add(this.createVLCAVPanel());
        }

        private void init() {
            this.removeAll();
            try {
                JPanel pp = new JPanel();
                pp.add(this.createRunWFPanel());
                this.add((Component)pp, "North");
                this.pres = new JPanel();
                this.pres.setLayout(new BoxLayout(this.pres, 1));
                JPanel p = new JPanel();
                p.add(this.createViewVLCRPanel());
                this.pres.add(p);
                this.add((Component)this.pres, "Center");
                this.revalidate();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }

        @Override
        public void done() {
            WorkFuncPanel.this.logger.info((Object)"... done.");
            this.init();
            if (WorkFuncPanel.this.vlcavFile.exists()) {
                if (WorkFuncPanel.this.parser == null) {
                    WorkFuncPanel.this.parser = WorkFuncPanel.this.projectInfo.getOutputInterface().getParser("F_VLCRAV", this);
                }
                WorkFuncPanel.this.parser.setParsed(false);
                WorkFuncPanel.this.parser.doParse();
            }
        }

        private JPanel createRunWFPanel() {
            JPanel ret = new JPanel();
            ret.setBorder(new TitledBorder("run the 'workfunc' program"));
            ret.setLayout(new BoxLayout(ret, 0));
            this.axisCombo = new JComboBox<String>(this.axisChoice);
            this.spinCombo = new JComboBox<String>(this.spinChoice);
            this.runWFButton = new JButton("run");
            JPanel paxis = new JPanel();
            paxis.setLayout(new BoxLayout(paxis, 0));
            paxis.setBorder(new TitledBorder("select axis"));
            JPanel pspin = new JPanel();
            pspin.setLayout(new BoxLayout(pspin, 0));
            pspin.setBorder(new TitledBorder("spin"));
            paxis.add(this.axisCombo);
            ret.add(paxis);
            ret.add(this.runWFButton);
            this.axisCombo.setSelectedIndex(2);
            this.spinCombo.setSelectedIndex(0);
            this.runWFButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WorkFuncPanelPanel.this.runWF();
                }
            });
            if (!WorkFuncPanel.this.nfvlcFile.exists() || !WorkFuncPanel.this.nfcntnFile.exists()) {
                this.axisCombo.setEnabled(false);
                this.spinCombo.setEnabled(false);
                this.runWFButton.setEnabled(false);
            }
            return ret;
        }

        private JPanel createViewVLCRPanel() {
            JPanel ret = new JPanel();
            if (!WorkFuncPanel.this.vlcrFile.exists() || WorkFuncPanel.this.vlcrFile.length() == 0L) {
                return ret;
            }
            ret.setLayout(new GridLayout());
            ret.setBorder(new TitledBorder("local potential"));
            JLabel label = new JLabel("local potential file : nfvlcr.cube      ");
            ret.add(label);
            JButton view = new JButton("view");
            ret.add(view);
            view.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WorkFuncPanelPanel.this.bootViewer();
                }
            });
            return ret;
        }

        private void bootViewer() {
            Cube2AtomCoords c2a = new Cube2AtomCoords(WorkFuncPanel.this.vlcrFile.getAbsolutePath());
            AtomCoords coords = c2a.getAtomCoords();
            coords.getChargeDensity().setInterpolationScheme(VolumetricData.LINEAR);
            Vector<AtomCoords> vec = new Vector<AtomCoords>();
            vec.addElement(coords);
            DataManager manager = new DataManager("foo", PhaseConstants.TABLESPEC, false);
            manager.parse();
            ACVData acvdata = new ACVData((ACVCaller)this, vec, WorkFuncPanel.this.projectInfo.getProjectDirectory(), manager.getInputInterface(), StringConstants.phase_atom_tag);
            acvdata.setFileName(WorkFuncPanel.this.vlcrFile.getAbsolutePath());
            CoordsViewerBooter cvb = new CoordsViewerBooter(acvdata, 0);
            cvb.boot();
        }

        private JPanel createVLCAVPanel() {
            if (!WorkFuncPanel.this.vlcavFile.exists() || WorkFuncPanel.this.vlcavFile.length() == 0L) {
                return new JPanel();
            }
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            JPanel pdata = WorkFuncPanel.this.projectInfo.getOutputInterface().getDataPanel("F_VLCRAV");
            p.add(pdata);
            return p;
        }

        @Override
        public void save(AtomCoords coords) {
        }

        @Override
        public void parseFinished() {
            this.addVLCAVPanel();
        }

        private void runWF() {
            WorkFuncPanel.this.logger.info((Object)"running the 'workfunc' program");
            String wfPath = String.valueOf(System.getProperty("pviewer.home")) + FS + "bin" + FS + "workfunc";
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                wfPath = String.valueOf(wfPath) + ".exe";
            }
            if (!new File(wfPath).exists()) {
                WorkFuncPanel.this.logger.error((Object)"'workfunc' program not found.");
                WorkFuncPanel.this.logger.error((Object)"put it under PHASE_VIEWER_HOME/bin");
                return;
            }
            int intaxis = this.axisCombo.getSelectedIndex();
            int intspin = this.spinCombo.getSelectedIndex();
            try {
                wfPath = String.valueOf(wfPath) + " -z " + String.valueOf(intaxis + 1);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                WorkFuncPanel.this.logger.error((Object)"failed creation of input file for the worcfunc program.");
                return;
            }
            MyThread mt = new MyThread(wfPath, this, new File(WorkFuncPanel.this.projectInfo.getProjectDirectory()));
        }
    }
}

