/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel;

import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Nfdynm2AtomCoords;
import ciss.phase_viewer.atomcoord.io.ExportFileChooser;
import ciss.phase_viewer.atomcoord.io.Exportable;
import ciss.phase_viewer.common.CoordsViewerBooter;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.tools.AnimDynmPlPanel;
import ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.tools.DynmDiffPanel;
import ciss.phase_viewer.primitiveguis.ComboButton;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

class TrajectoryPanelPanel
extends JPanel
implements ACVCaller,
OutputParserListener,
Exportable {
    private Logger logger = Logger.getLogger((String)TrajectoryPanelPanel.class.getName());
    private ChaseFileManager cfManager;
    private ProjectInfo projectInfo;
    private String projDir;
    private String nfdynmdata;
    private File nfdynmFile;
    private boolean fileExists;
    private Nfdynm2AtomCoords dynmParser;
    private Nfdynm2AtomCoords[] dynmParsers;
    private OutputParser parser;
    private ChaseFile cf;
    private boolean reac = false;
    private String[] reacfiles;
    private JComboBox comboFrame;
    private JLabel numframes;
    private JLabel path;
    private JComboBox combopath;
    private JTextField tfstart;
    private JTextField tfend;
    private JTextField tfgap;
    private JPanel pframe;

    protected TrajectoryPanelPanel(ProjectInfo projectInfo) {
        this.setLayout(new BoxLayout(this, 1));
        this.projectInfo = projectInfo;
        this.cfManager = projectInfo.getChaseFileManager();
        this.projDir = projectInfo.getProjectDirectory();
        this.nfdynmdata = this.cfManager.getFile("F_DYNM").getFileName();
        this.nfdynmFile = new File(String.valueOf(this.projDir) + System.getProperty("file.separator") + this.nfdynmdata);
        this.fileExists = this.nfdynmFile.exists();
        this.init();
    }

    private void init() {
        if (!this.fileExists) {
            this.add(new NoFilePanel("F_DYNM"));
            return;
        }
        this.cf = this.projectInfo.getChaseFileManager().getFile("F_DYNM");
        if (this.nfdynmFile.length() == 0L) {
            this.add(new NoFilePanel("F_DYNM", "is invalid"));
        }
        this.dynmParser = new Nfdynm2AtomCoords(String.valueOf(this.projDir) + System.getProperty("file.separator") + this.nfdynmdata);
        this.add(new LoadingFilePanel("F_DYNM"));
        if (this.parser == null) {
            this.parser = this.projectInfo.getOutputInterface().getParser("F_DYNM", this);
        }
        this.reacfiles = new File(this.projectInfo.getProjectDirectory()).list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                if (arg1.matches(String.valueOf(TrajectoryPanelPanel.this.cf.getFileName()) + ".reac\\d+")) {
                    return true;
                }
                return arg1.matches(String.valueOf(TrajectoryPanelPanel.this.cf.getFileName()) + ".converged");
            }
        });
        if (this.reacfiles != null && this.reacfiles.length != 0) {
            this.reac = true;
            this.logger.info((Object)"found multiple F_DYNM files.");
            this.parser.resetFiles();
            this.dynmParsers = new Nfdynm2AtomCoords[this.reacfiles.length];
            int i = 0;
            while (i < this.reacfiles.length) {
                this.logger.debug((Object)("F_ENF file: " + this.reacfiles[i]));
                String dynmdata = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.reacfiles[i];
                this.parser.addFile(dynmdata);
                this.dynmParsers[i] = new Nfdynm2AtomCoords(dynmdata);
                ++i;
            }
        }
        this.parser.setParsed(false);
        this.parser.doParse();
    }

    private JPanel firstRow() {
        Nfdynm2AtomCoords dynm = this.dynmParser;
        if (this.reac) {
            dynm = this.dynmParsers[0];
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JPanel ppath = new JPanel();
        ppath.setBorder(new TitledBorder("file name"));
        if (!this.reac) {
            this.path = new JLabel(this.nfdynmFile.getName());
            ppath.add(this.path);
        } else {
            this.combopath = new JComboBox<String>(this.reacfiles);
            JPanel pc = new JPanel();
            pc.add(this.combopath);
            ppath.add(pc);
        }
        String[] choices = new String[dynm.getNumFrames() + 1];
        choices[0] = "all";
        int i = 0;
        while (i < dynm.getNumFrames()) {
            choices[i + 1] = String.valueOf(i);
            ++i;
        }
        this.comboFrame = new JComboBox<String>(choices);
        this.comboFrame.setEditable(true);
        this.pframe = new JPanel();
        this.pframe.setBorder(new TitledBorder("select frame (num. frames: " + String.valueOf(dynm.getNumFrames()) + ")"));
        this.pframe.add(this.comboFrame);
        this.tfstart = new JTextField(4);
        this.tfstart.setText("0");
        JPanel pstart = new JPanel();
        pstart.setBorder(new TitledBorder("start"));
        pstart.add(this.tfstart);
        this.tfend = new JTextField(4);
        this.tfend.setText(String.valueOf(dynm.getNumFrames() - 1));
        JPanel pend = new JPanel();
        pend.setBorder(new TitledBorder("end"));
        pend.add(this.tfend);
        this.tfgap = new JTextField(4);
        this.tfgap.setText("1");
        JPanel pgap = new JPanel();
        pgap.setBorder(new TitledBorder("gap"));
        pgap.add(this.tfgap);
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new BoxLayout(btnpanel, 0));
        JButton bootEditor = new JButton("boot editor");
        JButton bootViewer = new JButton("viewer");
        JButton btnexport = new JButton("export");
        btnpanel.add(bootViewer);
        btnpanel.add(btnexport);
        JButton diff = new JButton("diff");
        diff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fil = TrajectoryPanelPanel.this.nfdynmFile.getAbsolutePath();
                if (TrajectoryPanelPanel.this.reac) {
                    fil = String.valueOf(TrajectoryPanelPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + TrajectoryPanelPanel.this.reacfiles[TrajectoryPanelPanel.this.combopath.getSelectedIndex()];
                }
                DynmDiffPanel diff = new DynmDiffPanel(fil, fil);
            }
        });
        if (this.reac) {
            this.combopath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int index = TrajectoryPanelPanel.this.combopath.getSelectedIndex();
                    Nfdynm2AtomCoords dynm = TrajectoryPanelPanel.this.dynmParsers[index];
                    TrajectoryPanelPanel.this.tfend.setText(String.valueOf(dynm.getNumFrames()));
                    ((DefaultComboBoxModel)TrajectoryPanelPanel.this.comboFrame.getModel()).removeAllElements();
                    ((DefaultComboBoxModel)TrajectoryPanelPanel.this.comboFrame.getModel()).addElement("all");
                    int i = 0;
                    while (i < TrajectoryPanelPanel.this.dynmParsers[index].getNumFrames()) {
                        ((DefaultComboBoxModel)TrajectoryPanelPanel.this.comboFrame.getModel()).addElement(String.valueOf(i));
                        ++i;
                    }
                    TrajectoryPanelPanel.this.pframe.setBorder(new TitledBorder("select frame (num. frames: " + String.valueOf(dynm.getNumFrames()) + ")"));
                    TrajectoryPanelPanel.this.revalidate();
                }
            });
            this.combopath.setSelectedIndex(0);
        }
        btnpanel.add(diff);
        bootViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TrajectoryPanelPanel.this.bootViewerBooter();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        });
        btnexport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrajectoryPanelPanel.this.bootExporter();
            }
        });
        JPanel paa = new JPanel();
        paa.setLayout(new GridLayout(1, 3));
        paa.add(ppath);
        paa.add(this.pframe);
        JPanel pse = new JPanel();
        pse.setLayout(new BoxLayout(pse, 0));
        pse.add(pstart);
        pse.add(pend);
        pse.add(pgap);
        paa.add(pse);
        JPanel ppp = new JPanel();
        ppp.setLayout(new BoxLayout(ppp, 1));
        ppp.add(paa);
        ppp.add(btnpanel);
        p.add(ppp);
        return p;
    }

    private void bootExporter() {
        ExportFileChooser efc = new ExportFileChooser(this, this);
    }

    private void bootViewerBooter() {
        String choi;
        Vector<AtomCoords> frames = null;
        Nfdynm2AtomCoords dynm = this.dynmParser;
        String fname = this.nfdynmdata;
        if (this.reac) {
            dynm = this.dynmParsers[this.combopath.getSelectedIndex()];
            fname = this.reacfiles[this.combopath.getSelectedIndex()];
        }
        if ((choi = (String)this.comboFrame.getSelectedItem()) == null || choi.length() == 0) {
            this.logger.error((Object)"invalid choice.");
            return;
        }
        if (choi.equals("all")) {
            try {
                int istart = Integer.parseInt(this.tfstart.getText().trim());
                int iend = Integer.parseInt(this.tfend.getText().trim());
                int igap = Integer.parseInt(this.tfgap.getText().trim());
                if (istart < 0 || igap > iend) {
                    this.logger.error((Object)"invalid specifcation for the start, end or gap parameter");
                    this.logger.error((Object)"using the default values");
                } else {
                    dynm.setStartEndGap(istart, iend, igap);
                }
            }
            catch (NumberFormatException nfe) {
                this.logger.error((Object)"invalid specifcation for the start, end or gap parameter");
                this.logger.error((Object)"using the default values");
            }
            frames = dynm.getFrames();
        } else {
            int framenum = 0;
            try {
                framenum = Integer.parseInt(choi);
            }
            catch (NumberFormatException npe) {
                this.logger.error((Object)"enter an integer value for 'select frame'");
                return;
            }
            AtomCoords ac = dynm.getFrameAt(framenum);
            frames = new Vector<AtomCoords>();
            frames.add(ac);
        }
        DataManager manager = new DataManager("foo", PhaseConstants.TABLESPEC, false);
        manager.parse();
        ACVData acvdata = new ACVData((ACVCaller)this, frames, this.projDir, manager.getInputInterface(), StringConstants.phase_atom_tag);
        acvdata.setFileName(fname);
        CoordsViewerBooter cvb = new CoordsViewerBooter(acvdata, 0);
        cvb.boot();
    }

    private JPanel secondRow() {
        JPanel ret = new JPanel();
        ret.setBorder(new TitledBorder("dynm2tr2"));
        ret.setLayout(new BoxLayout(ret, 0));
        JButton btn = new JButton("run dynm2tr2");
        ComboButton cb = new ComboButton(this.projectInfo.getProjectDirectory(), "dynm.tr2");
        ret.add(btn);
        ret.add(cb);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimDynmPlPanel panel = new AnimDynmPlPanel(TrajectoryPanelPanel.this.projectInfo.getProjectDirectory(), TrajectoryPanelPanel.this.nfdynmdata, "dynm2tr2.pl", new String[]{"dynm.tr2", "grid.mol2"});
            }
        });
        return ret;
    }

    public boolean save(AtomCoords[] coords) {
        return false;
    }

    @Override
    public void save(AtomCoords coords) {
    }

    @Override
    public void parseFinished() {
        this.removeAll();
        this.add(this.firstRow());
        this.add(this.projectInfo.getOutputInterface().getDataPanel("F_DYNM"));
        this.revalidate();
    }

    @Override
    public AtomCoords[] getCoordsToExport() {
        Vector vec = null;
        vec = !this.reac ? this.dynmParser.getFrames() : this.dynmParsers[this.combopath.getSelectedIndex()].getFrames();
        Object[] cds = new AtomCoords[vec.size()];
        vec.copyInto(cds);
        return cds;
    }

    @Override
    public void coordsExported(AtomCoords[] coords, String type, String fileName) {
    }
}

