/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class EnergyPanel
extends ProjectManipulator
implements OutputParserListener {
    private Logger logger = Logger.getLogger((String)EnergyPanel.class.getName());
    private OutputData output;
    private OutputData[] outputs;
    private OutputParser parser;
    private ChaseFile cf;
    private boolean reac = false;
    private String[] reacfiles = null;
    private JComboBox combofiles;
    private JLabel type;
    private JLabel numsteps;

    public EnergyPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public void parseFinished() {
        this.removeAll();
        try {
            this.output = this.projectInfo.getOutputInterface().getParser("F_ENF", this).getOutputData()[0];
            if (this.reac) {
                this.outputs = this.projectInfo.getOutputInterface().getParser("F_ENF", this).getOutputData();
            }
        }
        catch (NullPointerException npe) {
            return;
        }
        if (this.output == null) {
            return;
        }
        this.add(this.firstRow());
        this.add(this.projectInfo.getOutputInterface().getDataPanel("F_ENF"));
        this.revalidate();
    }

    @Override
    public void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.cf = this.projectInfo.getChaseFileManager().getFile("F_ENF");
        String fname = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.cf.getFileName();
        this.logger.debug((Object)("at Energy Panel: fname: " + fname));
        if (!new File(fname).exists()) {
            this.add(new NoFilePanel("F_ENF"));
            return;
        }
        this.add(new LoadingFilePanel("F_ENF"));
        if (this.parser == null) {
            this.parser = this.projectInfo.getOutputInterface().getParser("F_ENF", this);
        }
        this.reacfiles = new File(this.projectInfo.getProjectDirectory()).list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                if (arg1.matches(String.valueOf(EnergyPanel.this.cf.getFileName()) + ".reac\\d+")) {
                    return true;
                }
                return arg1.matches(String.valueOf(EnergyPanel.this.cf.getFileName()) + ".converged");
            }
        });
        if (this.reacfiles != null && this.reacfiles.length != 0) {
            this.reac = true;
            this.logger.info((Object)"found multiple F_ENF files.");
            this.parser.resetFiles();
            int i = 0;
            while (i < this.reacfiles.length) {
                this.logger.debug((Object)("F_ENF file: " + this.reacfiles[i]));
                this.parser.addFile(String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.reacfiles[i]);
                ++i;
            }
        }
        this.parser.setParsed(false);
        this.parser.doParse();
    }

    @Override
    public void initializeProject() {
    }

    private JPanel firstRow() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("info"));
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel pfile = new JPanel();
        pfile.setBorder(new TitledBorder("file name"));
        if (!this.reac) {
            this.cf = this.projectInfo.getChaseFileManager().getFile("F_ENF");
            JLabel file = new JLabel(this.cf.getFileName());
            pfile.add(file);
        } else {
            this.combofiles = new JComboBox<String>(this.reacfiles);
            pfile.add(this.combofiles);
        }
        int nsteps = this.output.getData2D().length;
        int ndata = this.output.getIdentifier().length;
        JPanel pnumsteps = new JPanel();
        pnumsteps.setBorder(new TitledBorder("nsteps"));
        this.numsteps = new JLabel(String.valueOf(nsteps));
        pnumsteps.add(this.numsteps);
        JPanel ptype = new JPanel();
        ptype.setBorder(new TitledBorder("type"));
        String strtype = this.getDynamicsType(this.output);
        if (strtype.equals("NEB")) {
            pnumsteps.setBorder(new TitledBorder("nreplicas"));
        }
        this.type = new JLabel(strtype);
        ptype.add(this.type);
        JButton btn = new JButton("boot editor");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fname = String.valueOf(EnergyPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + EnergyPanel.this.cf.getFileName();
                if (EnergyPanel.this.reac) {
                    fname = String.valueOf(EnergyPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + EnergyPanel.this.combofiles.getSelectedItem().toString();
                }
                ProjectBrowserUtils.bootTextViewer(fname);
            }
        });
        if (this.combofiles != null) {
            this.combofiles.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    OutputData out = EnergyPanel.this.outputs[EnergyPanel.this.combofiles.getSelectedIndex()];
                    EnergyPanel.this.type.setText(EnergyPanel.this.getDynamicsType(out));
                }
            });
            this.combofiles.setSelectedIndex(0);
        }
        panel.add(pfile);
        panel.add(pnumsteps);
        panel.add(ptype);
        panel.add(btn);
        return panel;
    }

    private String getDynamicsType(OutputData out) {
        int nsteps = out.getData2D().length;
        int ndata = out.getIdentifier().length;
        this.numsteps.setText(String.valueOf(nsteps));
        String strtype = "static calculation";
        if (nsteps > 1 && ndata == 4) {
            strtype = "geom. optimization";
        }
        if (nsteps > 1 && ndata > 4 && !out.getIdentifier()[0].startsWith("#step")) {
            strtype = "molecular dynamics";
        }
        if (nsteps > 1 && ndata > 4 && out.getIdentifier()[0].startsWith("#step")) {
            strtype = "NEB";
        }
        if (this.combofiles != null && this.combofiles.getSelectedItem().toString().endsWith("converged")) {
            strtype = "geom. opt at each reac coord";
        }
        return strtype;
    }
}

