/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig;

import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.acviewer.fbz.FBZData;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomEditor;
import ciss.phase_viewer.atomcoord.AtomEvent;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.AtomListener;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.Exportable;
import ciss.phase_viewer.atomcoord.io.Importable;
import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.CoordsViewerBooter;
import ciss.phase_viewer.common.MyMessageBox;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceBlockChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceBlockChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhaseUnit;
import ciss.phase_viewer.primitiveguis.ExportButton;
import ciss.phase_viewer.primitiveguis.ImportButton;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableModelForInputInterface;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableRightClickListener;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class AtomConfigPanel
extends JPanel
implements TableModelListener,
ActionListener,
PopupMenuListener,
InputInterfaceEntryChangeListener,
InputInterfaceBlockChangeListener,
AtomListener,
TableRightClickListener,
ACVCaller,
Importable,
Exportable {
    private static Logger logger = Logger.getLogger((String)AtomConfigPanel.class.getName());
    private InputInterface inputInterface;
    private ChoicePanelPhase p_coord;
    private String[] coordsys;
    private MyMessageBox mbox;
    private boolean validcell = true;
    private AtomCoords coords;
    private JComboBox p_cell_scheme;
    private int icellscheme;
    private JScrollPane[] scr;
    private JPanel[] pane;
    private String[] inputSpecs0;
    private String[] inputSpecs1;
    private Vector fullNameVector0;
    private Vector fullNameVector1;
    private JPanel p_cell;
    private TableModel[] tblmod_cell = new TableModel[2];
    private JCheckBox cbautoconvert;
    private JCheckBox cbautoconvertCoordSys;
    private JCheckBox cbautoconvertLength;
    private TableForInputInterface[] tfcell = new TableForInputInterface[2];
    private TableForInputInterface tfatom;
    private JComboBox cpViewer;
    private ChoicePanelPhaseUnit unitchoice;
    private String atomtag = StringConstants.phase_atom_tag;
    private int unitOld = 0;
    private String[] unitChoice = new String[]{ConstParameters.NO_SELECTION, "bohr", "angstrom", "nm"};
    private int oldunit = 0;
    private JButton fbzbutton;
    private boolean iscartOld = false;
    private JScrollPane scrPane;
    private JTextField textselect;
    private Font cellFont = new Font("Serif", 0, 10);

    public AtomConfigPanel(InputInterface inputInterface, AtomCoords coords) {
        this.inputInterface = inputInterface;
        this.coords = coords;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.createUpperPanel();
        this.createCellPanel();
        this.createAtomConfigPanel();
        this.createButtons();
        this.post();
        this.inputInterface.addInputInterfaceEntryChangeListener(this);
        this.inputInterface.addInputInterfaceBlockChangeListener(this);
        this.createCoords();
    }

    private void post() {
        this.p_cell_scheme.setSelectedIndex(0);
        boolean[] btmp = new boolean[this.tfcell[1].getColumnCount()];
        btmp[0] = true;
        int i = 1;
        while (i < this.tfcell[1].getColumnCount()) {
            btmp[i] = false;
            ++i;
        }
        if (this.tfcell[1].hasData(btmp)) {
            this.p_cell_scheme.setSelectedIndex(1);
        }
    }

    private void createUpperPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        String struc = "structure.";
        String[] unitspec = new String[]{String.valueOf(struc) + "unit_cell.units", String.valueOf(struc) + "atom_list.atoms.units"};
        JPanel punit = new JPanel();
        punit.setLayout(new BoxLayout(punit, 0));
        punit.setBorder(new TitledBorder("length unit"));
        this.unitchoice = new ChoicePanelPhaseUnit(unitspec, this.inputInterface, null, this.unitChoice, this);
        JPanel pch = new JPanel();
        pch.add(this.unitchoice);
        punit.add(pch);
        this.unitchoice.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (AtomConfigPanel.this.cbautoconvertLength.isSelected()) {
                    AtomConfigPanel.this.autoConvertUnit();
                }
                AtomConfigPanel.this.oldunit = AtomConfigPanel.this.unitchoice.getComboBox().getSelectedIndex();
            }
        });
        this.oldunit = this.unitchoice.getComboBox().getSelectedIndex();
        this.cbautoconvertLength = new JCheckBox("convert");
        punit.add(pch);
        punit.add(this.cbautoconvertLength);
        p.add(punit);
        JPanel pcellscheme = new JPanel();
        pcellscheme.setLayout(new BoxLayout(pcellscheme, 0));
        pcellscheme.setBorder(new TitledBorder("cell scheme"));
        this.cbautoconvert = new JCheckBox("convert");
        String[] cell_scheme = new String[]{"a_vector,b_vector,c_vector", "a,b,c,alpha,beta,gamma"};
        this.p_cell_scheme = new JComboBox<String>(cell_scheme);
        this.p_cell_scheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtomConfigPanel.this.icellscheme = AtomConfigPanel.this.p_cell_scheme.getSelectedIndex();
                logger.debug((Object)("changing cell scheme to no. " + AtomConfigPanel.this.icellscheme));
                if (AtomConfigPanel.this.cbautoconvert.isSelected()) {
                    AtomConfigPanel.this.autoConvert();
                }
                AtomConfigPanel.this.updateTableCell();
            }
        });
        pcellscheme.add(this.p_cell_scheme);
        pcellscheme.add(this.cbautoconvert);
        JPanel pcelltmp = new JPanel();
        pcelltmp.add(pcellscheme);
        p.add(pcelltmp);
        this.add(p);
    }

    private void bootFBZViewer() {
        this.coords.createCellFromTableModel(this.tblmod_cell);
        double[][] rlat = this.coords.getReciprocalLattice(this.inputInterface);
        if (rlat == null) {
            logger.error((Object)"invalid lattice...");
            return;
        }
        FBZData fbzdata = new FBZData();
        fbzdata.reciprocalLattice = rlat;
        fbzdata.baseDir = new File(this.inputInterface.getFileName()).getParent();
        fbzdata.bravaisLattice = this.coords.getBravaisLattice();
        FBZ fbz = new FBZ(fbzdata);
    }

    private void autoConvertCoordSys() {
        boolean cartNow = this.p_coord.getComboBox().getSelectedIndex() == 2;
        this.createCoords();
        this.coords.setUnit(this.oldunit);
        this.coords.isCart(this.iscartOld);
        int conv = 7;
        if (cartNow) {
            conv = 6;
        }
        this.coords.convert(conv, -1);
        this.coords.atomCoords2InputInterface(this.inputInterface, this.atomtag);
        this.doCell(this.coords);
    }

    private void autoConvertUnit() {
        this.createCoords();
        boolean iscart = this.p_coord.getComboBox().getSelectedIndex() == 2;
        this.coords.isCart(iscart);
        this.coords.setUnit(this.oldunit);
        int newunit = this.unitchoice.getComboBox().getSelectedIndex();
        int conv = 8;
        if (newunit == 0 || newunit == 1) {
            conv = 9;
        }
        if (newunit == 3) {
            conv = 10;
        }
        this.coords.convert(-1, conv);
        AtomList list = this.coords.getAtomList();
        int i = 0;
        while (i < list.size()) {
            logger.debug((Object)list.getAtomAt(i));
            ++i;
        }
        this.coords.atomCoords2InputInterface(this.inputInterface, this.atomtag);
        this.doCell(this.coords);
        this.tfatom.revalidate();
        this.tfatom.repaint();
    }

    private void createCoords() {
        this.coords = new AtomCoords();
        this.coords.createCellFromTableModel(this.tblmod_cell);
        this.coords.inputInterface2AtomCoords(this.inputInterface, this.atomtag);
        int choi = this.unitchoice.getComboBox().getSelectedIndex();
        this.coords.setUnit(choi);
        String cart = (String)this.p_coord.getComboBox().getSelectedItem();
        if (cart.equals(this.coordsys[2])) {
            this.coords.isCart(true);
        } else {
            this.coords.isCart(false);
        }
    }

    private void autoConvert() {
        this.toCoords();
        this.createCoords();
        if (!this.coords.convertCell(this.p_cell_scheme.getSelectedIndex())) {
            logger.warn((Object)"failed to convert cell");
        }
        DecimalFormat dformat = new DecimalFormat("#.##########");
        Cell cellvec = this.coords.getCell(0);
        Cell cellabc = this.coords.getCell(1);
        try {
            String[][] dat;
            if (cellvec != null) {
                dat = cellvec.getCell();
                int i = 0;
                while (i < 3) {
                    int j = 0;
                    while (j < 3) {
                        this.tblmod_cell[0].setValueAt(dformat.format(Double.parseDouble(dat[i][j])), i, j + 1);
                        ++j;
                    }
                    ++i;
                }
            }
            if (cellabc != null) {
                dat = cellabc.getCell();
                int count = 0;
                int i = 0;
                while (i < 2) {
                    int j = 0;
                    while (j < 3) {
                        this.tblmod_cell[1].setValueAt(dformat.format(Double.parseDouble(dat[i][j])), 0, count + 1);
                        ++count;
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.error((Object)"enter a double value for cell parameters.");
            e.printStackTrace();
        }
    }

    private void createAtomConfigPanel() {
        String[] atmtable = new String[]{this.atomtag};
        this.inputInterface.addInputInterfaceEntryChangeListener(this.coords);
        JPanel p_atom_all = new JPanel();
        p_atom_all.setLayout(new BoxLayout(p_atom_all, 1));
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        int[] map = nArray;
        this.tfatom = new TableForInputInterface(atmtable, this.inputInterface, map, this);
        JPanel panelAtom = new JPanel();
        panelAtom.setLayout(new BoxLayout(panelAtom, 1));
        panelAtom.add(this.tfatom.getPanel());
        this.scrPane = new JScrollPane();
        this.scrPane.getViewport().setView(this.tfatom.getPanel());
        this.scrPane.setPreferredSize(new Dimension(500, 150));
        this.scrPane.getVerticalScrollBar().setUnitIncrement(20);
        p_atom_all.add(this.scrPane);
        p_atom_all.setBorder(new TitledBorder("atomic coordinates"));
        this.add(p_atom_all);
        this.coords.setModels(this.tfatom.getModel(), this.tblmod_cell);
        this.tfatom.addTableRightClickListener(this);
    }

    private void createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel p_strbtn = new JPanel();
        p_strbtn.setLayout(new FlowLayout(1));
        p_strbtn.setLayout(new BoxLayout(p_strbtn, 0));
        ImportButton imp2 = new ImportButton("Import", this, this);
        ExportButton exp = new ExportButton("Export", this, this);
        JButton btn = new JButton("from PHASE input");
        p_strbtn.add(imp2);
        p_strbtn.add(exp);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AtomConfigPanel.this.chooser();
            }
        });
        this.coordsys = new String[]{ConstParameters.NO_SELECTION, "internal", "cartesian"};
        String[] csspec = new String[]{"structure.atom_list.coordinate_system"};
        JPanel pcoordsys = new JPanel();
        pcoordsys.setLayout(new BoxLayout(pcoordsys, 0));
        pcoordsys.setBorder(new TitledBorder("coordinate system"));
        this.p_coord = new ChoicePanelPhase(csspec, this.inputInterface, null, this.coordsys, this);
        this.p_coord.setLayout(new FlowLayout());
        this.p_coord.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AtomConfigPanel.this.cbautoconvertCoordSys.isSelected()) {
                    AtomConfigPanel.this.autoConvertCoordSys();
                }
                AtomConfigPanel.this.coords.isCart(AtomConfigPanel.this.coordsys[AtomConfigPanel.this.p_coord.getComboBox().getSelectedIndex()].equals(AtomConfigPanel.this.coordsys[2]));
                logger.debug((Object)("isCart: " + AtomConfigPanel.this.coords.isCart()));
                AtomConfigPanel.this.iscartOld = AtomConfigPanel.this.p_coord.getComboBox().getSelectedIndex() == 2;
            }
        });
        this.coords.isCart(this.coordsys[this.p_coord.getComboBox().getSelectedIndex()].equals(this.coordsys[2]));
        this.cbautoconvertCoordSys = new JCheckBox("convert");
        pcoordsys.add(this.p_coord);
        pcoordsys.add(this.cbautoconvertCoordSys);
        this.iscartOld = this.p_coord.getComboBox().getSelectedIndex() == 2;
        p_strbtn.add(pcoordsys);
        JPanel viewerPanel = new JPanel();
        viewerPanel.setBorder(new TitledBorder("view configuration"));
        JButton viewerbtn = new JButton("View");
        String[] viewerChoice = new String[]{"internal viewer", "BioStationViewer"};
        this.cpViewer = new JComboBox<String>(viewerChoice);
        viewerPanel.add(viewerbtn);
        p_strbtn.add(viewerPanel);
        p.add(p_strbtn);
        viewerbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtomConfigPanel.this.bootViewerBooter();
            }
        });
        this.textselect = new JTextField(7);
        JButton btnselect = new JButton("select");
        JPanel pselect = new JPanel();
        pselect.setLayout(new BoxLayout(pselect, 0));
        pselect.add(this.textselect);
        pselect.add(btnselect);
        btnselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String foo = AtomConfigPanel.this.textselect.getText();
                if (foo == null || foo.trim().length() == 0) {
                    return;
                }
                if (!Utils.isNumber(foo)) {
                    logger.error((Object)"enter a positve integer.");
                    return;
                }
                AtomConfigPanel.this.selectAtomTableRow(AtomConfigPanel.this.tfatom.getLocation(), Integer.parseInt(foo));
            }
        });
        JButton btneditatom = new JButton("edit");
        btneditatom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AtomConfigPanel.this.tfatom.getSelectedRow();
                if (row >= 0) {
                    AtomConfigPanel.this.bootAtomEditor(row);
                } else {
                    logger.info((Object)"no atom selected.");
                }
            }
        });
        JButton btnremove = new JButton("remove");
        btnremove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtomConfigPanel.this.removeSelectedAtom();
            }
        });
        JButton btnadd = new JButton("add atom");
        btnadd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtomConfigPanel.this.addNewAtom();
            }
        });
        JPanel paneledit = new JPanel();
        paneledit.setLayout(new BoxLayout(paneledit, 0));
        paneledit.setBorder(new TitledBorder("edit atomic configuration"));
        paneledit.add(pselect);
        paneledit.add(btneditatom);
        paneledit.add(btnadd);
        paneledit.add(btnremove);
        p.add(paneledit);
        this.add(p);
    }

    @Override
    public void inputInterfaceBlockChanged(InputInterfaceBlockChangeEvent e) {
    }

    private void chooser() {
        ChaseFileChooser chooser = new ChaseFileChooser("input", true);
        chooser.setFileSelectionMode(0);
        if (chooser.showDialog(this, "open") != 0) {
            return;
        }
        String path = chooser.getSelectedFile().getAbsolutePath();
        DataManager manager = new DataManager(path, PhaseConstants.TABLESPEC, false);
        manager.parse();
        InputInterface inputFrom = manager.getInputInterface();
        this.inputInterface.swapBlock(InputInterface.__ROOT__, "structure", inputFrom, this);
        this.removeAll();
        this.init();
        this.revalidate();
    }

    private void bootViewerBooter() {
        String parentDir = new File(this.inputInterface.getFileName()).getParent();
        Vector<AtomCoords> cv = new Vector<AtomCoords>();
        this.toCoords();
        cv.addElement(this.coords);
        logger.debug((Object)"at bootViewerBooter()");
        this.coords.createBravaisLattice(this.inputInterface, !BravaisLattice.isBravais(this.inputInterface));
        BravaisLattice bl = this.coords.getBravaisLattice();
        if (bl != null) {
            bl.isBravais(BravaisLattice.isBravais(this.inputInterface));
        }
        if (bl == null) {
            logger.error((Object)"blat is null.");
        } else {
            logger.debug((Object)"blat is not null.");
        }
        ACVData acvdata = new ACVData((ACVCaller)this, cv, parentDir, this.inputInterface, this.atomtag);
        acvdata.setBravaisLattice(bl);
        CoordsViewerBooter cvb = new CoordsViewerBooter(acvdata, this.cpViewer.getSelectedIndex());
        try {
            cvb.boot();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateInputInterface();
    }

    private void addNewAtom() {
        AtomEditor editor = new AtomEditor(this.inputInterface.getInputInterfaceTableSpecManager().getTableSpec(this.atomtag).getTableColumns(), "edit attributes for new atom", new Dimension(400, 250));
        editor.addAtomListener(this);
    }

    private void removeSelectedAtom() {
        int[] rows = this.tfatom.getSelectedRows();
        if (rows != null) {
            int i = rows.length - 1;
            while (i >= 0) {
                int targetRow = rows[i];
                ((DefaultTableModel)this.tfatom.getModel()).removeRow(targetRow);
                --i;
            }
        }
    }

    private void toCoords() {
        this.coords = new AtomCoords();
        this.coords.createCellFromTableModel(this.tblmod_cell);
        this.coords.inputInterface2AtomCoords(this.inputInterface, this.atomtag);
        int choi = this.unitchoice.getComboBox().getSelectedIndex();
        this.coords.setUnit(choi);
        String cart = (String)this.p_coord.getComboBox().getSelectedItem();
        if (cart.equals(this.coordsys[2])) {
            this.coords.isCart(true);
        } else {
            this.coords.isCart(false);
        }
        this.coords.convert(6, 8);
    }

    private void createCellPanel() {
        String[] fullName;
        String inp;
        JPanel p_cell_all = new JPanel();
        p_cell_all.setLayout(new BoxLayout(p_cell_all, 1));
        this.p_cell = new JPanel();
        this.p_cell.setLayout(new BoxLayout(this.p_cell, 0));
        String uncell = "structure.unit_cell.";
        this.inputSpecs0 = new String[]{String.valueOf(uncell) + "a_vector", String.valueOf(uncell) + "b_vector", String.valueOf(uncell) + "c_vector"};
        this.inputSpecs1 = new String[]{String.valueOf(uncell) + "a", String.valueOf(uncell) + "b", String.valueOf(uncell) + "c", String.valueOf(uncell) + "alpha", String.valueOf(uncell) + "beta", String.valueOf(uncell) + "gamma"};
        this.fullNameVector0 = new Vector();
        int i = 0;
        while (i < this.inputSpecs0.length) {
            inp = this.inputSpecs0[i];
            logger.debug((Object)("inp: " + inp));
            fullName = inp.split("\\.");
            this.fullNameVector0.addElement(fullName);
            ++i;
        }
        this.fullNameVector1 = new Vector();
        i = 0;
        while (i < this.inputSpecs1.length) {
            inp = this.inputSpecs1[i];
            logger.debug((Object)("inp: " + inp));
            fullName = inp.split("\\.");
            this.fullNameVector1.addElement(fullName);
            ++i;
        }
        String[] tmp = new String[]{"structure.unit_cell"};
        this.tfcell[0] = new TableForInputInterface(tmp, this.inputInterface, null, this, 0);
        this.tfcell[1] = new TableForInputInterface(tmp, this.inputInterface, null, this, 1);
        this.tfcell[0].revalidate();
        this.tfcell[1].revalidate();
        this.tfcell[0].repaint();
        this.tfcell[1].repaint();
        this.scr = new JScrollPane[2];
        this.pane = new JPanel[2];
        int i2 = 0;
        while (i2 < 2) {
            this.tblmod_cell[i2] = this.tfcell[i2].getModel();
            ++i2;
        }
        p_cell_all.add(this.p_cell);
        p_cell_all.setBorder(new TitledBorder("cellvector"));
        this.add(p_cell_all);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    private void updateTableCell() {
        if (this.p_cell == null) {
            return;
        }
        this.p_cell.removeAll();
        this.p_cell.add(this.tfcell[this.icellscheme].getPanel());
        this.updateInputInterface();
        this.revalidate();
    }

    private void updateInputInterface() {
        InputInterfacePrimitiveEntry entry;
        String ident;
        String[] fullName;
        int i = 0;
        while (i < this.fullNameVector0.size()) {
            this.inputInterface.selectRoot();
            fullName = (String[])this.fullNameVector0.get(i);
            int j = 0;
            while (j < fullName.length - 1) {
                ident = fullName[j];
                if (!this.inputInterface.selectBlock(ident)) {
                    logger.debug((Object)("couldn't select block: " + ident));
                } else {
                    logger.debug((Object)("selected block: " + ident));
                }
                ++j;
            }
            entry = this.inputInterface.getPrimitiveEntry(fullName[fullName.length - 1]);
            if (this.p_cell_scheme.getSelectedIndex() == 1) {
                entry.ignoreMe(true);
            } else {
                entry.ignoreMe(false);
            }
            this.inputInterface.selectRoot();
            ++i;
        }
        i = 0;
        while (i < this.fullNameVector1.size()) {
            this.inputInterface.selectRoot();
            fullName = (String[])this.fullNameVector1.get(i);
            int j = 0;
            while (j < fullName.length - 1) {
                ident = fullName[j];
                if (!this.inputInterface.selectBlock(ident)) {
                    logger.debug((Object)("couldn't select block: " + ident));
                } else {
                    logger.debug((Object)("selected block: " + ident));
                }
                ++j;
            }
            entry = this.inputInterface.getPrimitiveEntry(fullName[fullName.length - 1]);
            if (this.p_cell_scheme.getSelectedIndex() == 0) {
                entry.ignoreMe(true);
            } else {
                entry.ignoreMe(false);
            }
            this.inputInterface.selectRoot();
            ++i;
        }
    }

    @Override
    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
    }

    @Override
    public void inputInterfaceInitializing() {
    }

    @Override
    public void inputInterfaceInitialized() {
    }

    @Override
    public void atomStateChanged(AtomEvent e) {
    }

    @Override
    public void tableRightClicked(Point point, String command) {
        if (command.equals("edit")) {
            this.bootAtomEditor(this.tfatom.rowAtPoint(point));
        } else if (command.equals("delete")) {
            ((DefaultTableModel)this.tfatom.getModel()).removeRow(this.tfatom.rowAtPoint(point));
        } else if (command.equals("select")) {
            String res = JOptionPane.showInputDialog(Desk.getDesktop(), "enter a row number", "row selection", 1);
            if (!Utils.isNumber(res)) {
                logger.error((Object)"enter a positve integer.");
                return;
            }
            this.selectAtomTableRow(point, Integer.parseInt(res));
        } else if (command.equals("new")) {
            this.bootAtomEditor(this.tfatom.rowAtPoint(point), true);
        }
    }

    private void bootAtomEditor(int row) {
        this.bootAtomEditor(row, false);
    }

    private void bootAtomEditor(int row, boolean newAtom) {
        Atom atom = this.coords.inputInterface2Atom(this.inputInterface, this.atomtag, row);
        logger.debug((Object)atom);
        AtomEditorTable editor = new AtomEditorTable(this.inputInterface.getInputInterfaceTableSpecManager().getTableSpec(this.atomtag).getTableColumns(), atom, newAtom, row, "edit attributes for this atom", new Dimension(400, 250));
        editor.addAtomListener(this);
    }

    private void selectAtomTableRow(Point point, int num) {
        int old = this.tfatom.rowAtPoint(point);
        if (num == 0) {
            num = 1;
        }
        if (num >= this.tfatom.getRowCount()) {
            logger.error((Object)"exceeded max. row number.");
            return;
        }
        this.tfatom.setRowSelectionInterval(num - 1, num - 1);
        int rowHeight = this.tfatom.getRowHeight();
        int geta = rowHeight * (this.tfatom.getSelectedRow() - old);
        Point newPoint = new Point(point.x, point.y + geta);
        this.scrPane.getViewport().setViewPosition(newPoint);
        this.revalidate();
    }

    private void convAtomCoords(AtomCoords cds) {
        int to_coordsys;
        cds.removeIgnoreOnSaveAtoms();
        int unit = this.unitchoice.getComboBox().getSelectedIndex();
        int to_unit = 0;
        if (unit == 1 || unit == 0) {
            to_unit = 9;
        } else if (unit == 2) {
            to_unit = 8;
        } else if (unit == 3) {
            to_unit = 10;
        }
        String cart = (String)this.p_coord.getComboBox().getSelectedItem();
        if (cart.equals(this.coordsys[2])) {
            to_coordsys = 6;
            logger.debug((Object)"transforming to 'cartesian' coordinates");
        } else {
            to_coordsys = 7;
            logger.debug((Object)"transforming to 'internal' coordinates");
        }
        cds.isCart(true);
        cds.setUnit(2);
        cds.convert(to_coordsys, to_unit);
    }

    @Override
    public void save(AtomCoords cds) {
        this.coordsImported(new AtomCoords[]{cds}, null, "");
    }

    @Override
    public void coordsImported(AtomCoords[] coords, String type, String fileName) {
        if (coords == null || coords.length == 0) {
            return;
        }
        coords[0].correctCellOffset();
        boolean cart = coords[0].isCart();
        Cell[] ce = coords[0].getCell();
        this.convAtomCoords(coords[0]);
        Utils.clearTableModel(this.tfatom.getModel());
        this.doCell(coords[0]);
        coords[0].atomCoords2InputInterface(this.inputInterface, this.atomtag);
        if (cart) {
            coords[0].convert(6, 8);
        } else {
            coords[0].convert(7, 8);
        }
        this.updateInputInterface();
        this.tfatom.updateAll();
        this.inputInterface.selectRoot();
    }

    private void doCell(AtomCoords cds) {
        TableModel[] cellmods = new TableModelForInputInterface[2];
        int i = 0;
        while (i < 2) {
            cellmods[i] = (TableModelForInputInterface)this.tfcell[i].getModel();
            ((TableModelForInputInterface)cellmods[i]).notifyInputInterfaceChangeListeners(false);
            ++i;
        }
        cds.updateTable(null, cellmods);
        i = 0;
        while (i < 2) {
            ((TableModelForInputInterface)cellmods[i]).notifyInputInterfaceChangeListeners(true);
            this.tfcell[i].setModel(cellmods[i]);
            this.tfcell[i].revalidate();
            this.tfcell[i].repaint();
            ++i;
        }
    }

    @Override
    public AtomCoords[] getCoordsToExport() {
        AtomCoords coord = new AtomCoords();
        coord.createCellFromTableModel(this.tblmod_cell);
        coord.inputInterface2AtomCoords(this.inputInterface, this.atomtag);
        return new AtomCoords[]{coord};
    }

    @Override
    public void coordsExported(AtomCoords[] coords, String type, String fileName) {
    }

    class AtomEditorTable
    extends AtomEditor {
        private Logger logger;

        AtomEditorTable(InputInterfaceTableColumns[] columns, Atom atom, boolean newAtom, int atomIndex, String title, Dimension dimension) {
            super(columns, atom, newAtom, atomIndex, title, dimension);
            this.logger = Logger.getLogger((String)AtomEditorTable.class.getName());
        }

        AtomEditorTable(InputInterfaceTableColumns[] columns, String title, Dimension dimension) {
            super(columns, title, dimension);
            this.logger = Logger.getLogger((String)AtomEditorTable.class.getName());
        }

        @Override
        protected void removeSelected() {
            AtomConfigPanel.this.removeSelectedAtom();
            this.dispose();
        }
    }
}

