/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.acviewer.fbz.FBZData;
import ciss.phase_viewer.acviewer.fbz.Kpoint;
import ciss.phase_viewer.acviewer.fbz.KpointGenerator;
import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class PhononPanel
extends ProjectManipulator {
    private Logger logger = Logger.getLogger((String)PhononPanel.class.getName());
    private String phbandcontrol = "phbandcontrol";
    private String projdir;
    private ChoicePanelPhase cppsw_phonon;

    public PhononPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)new SubPanel(this.projectInfo.getInputInterface()), "North");
        this.projdir = this.projectInfo.getProjectDirectory();
    }

    @Override
    public void initializeProject() {
    }

    class SubPanel
    extends PhaseInputItems
    implements KpointGenerator {
        SubPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        @Override
        public void createGUI() {
            String tag_phonon = "Phonon.";
            this.setLayout(new BoxLayout(this, 1));
            JPanel gammaPoint = new JPanel();
            gammaPoint.setBorder(new TitledBorder("Gamma point"));
            gammaPoint.setLayout(new BoxLayout(gammaPoint, 1));
            String[] point_group = new String[]{ChoicePanelPhase.NO_SELECTION, "Oh", "O", "Td", "Th", "T", "D4h", "D4", "D2d", "C4v", "C4h", "S4", "C4", "D2h", "D2", "C2v", "D6h", "D6", "D3h", "C6v", "C6h", "C3h", "C6", "D3d", "D3", "C3v", "S6", "C3", "C2h", "Cs", "C2", "Ci", "C1"};
            String[] sw_phonon = new String[]{String.valueOf(tag_phonon) + "sw_phonon"};
            PhononPanel.this.cppsw_phonon = new ChoicePanelPhase(sw_phonon, this.inputInterface, "phonon", this.ON_OFF, this.ON_OFF_DUPLI, this);
            PhononPanel.this.cppsw_phonon.getComboBox().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (PhononPanel.this.cppsw_phonon.getComboBox().getSelectedIndex() == 1) {
                        SubPanel.this.inputInterface.getInputInterfacePrimitiveEntry("Phonon.sw_vibrational_modes").setValue("on");
                    } else {
                        SubPanel.this.inputInterface.getInputInterfacePrimitiveEntry("Phonon.sw_vibrational_modes").setValue("off");
                    }
                }
            });
            PhononPanel.this.cppsw_phonon.getComboBox().setSelectedIndex(PhononPanel.this.cppsw_phonon.getComboBox().getSelectedIndex());
            String[] tag_point_group = new String[]{String.valueOf(tag_phonon) + "point_group"};
            ChoicePanelPhase cpppoint_group = new ChoicePanelPhase(tag_point_group, this.inputInterface, "point group", point_group, this);
            String[] sw_calc_force = new String[]{String.valueOf(tag_phonon) + "sw_calc_force"};
            ChoicePanelPhase cppsw_calc_force = new ChoicePanelPhase(sw_calc_force, this.inputInterface, "calculate force", this.ON_OFF, this.ON_OFF_DUPLI, this);
            JPanel p1 = new JPanel();
            p1.setLayout(new BoxLayout(p1, 0));
            p1.add(PhononPanel.this.cppsw_phonon);
            p1.add(cpppoint_group);
            p1.add(cppsw_calc_force);
            String[] displacement = new String[]{String.valueOf(tag_phonon) + "displacement"};
            InputPanelPhase ippdisplacement = new InputPanelPhase(displacement, this.inputInterface, "displacement", 0, 7, this);
            String[] norder = new String[]{String.valueOf(tag_phonon) + "norder"};
            InputPanelPhase ippnorder = new InputPanelPhase(norder, this.inputInterface, "norder", 0, 7, this);
            String[] sw_polynomial_fit = new String[]{String.valueOf(tag_phonon) + "sw_polynomial_fit"};
            ChoicePanelPhase cppsw_polynomial_fit = new ChoicePanelPhase(sw_polynomial_fit, this.inputInterface, "polynomial fit", this.ON_OFF, this.ON_OFF_DUPLI, this);
            JPanel ptmp = new JPanel();
            ptmp.setLayout(new GridLayout());
            ptmp.add(cppsw_polynomial_fit);
            JPanel p2 = new JPanel();
            p2.setLayout(new GridLayout(1, 3));
            p2.add(ippdisplacement);
            p2.add(ippnorder);
            p2.add(ptmp);
            int[] nArray = new int[2];
            nArray[1] = 2;
            int[] disable = nArray;
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, cpppoint_group);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, cppsw_calc_force);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, ippdisplacement);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, ippnorder);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, cppsw_polynomial_fit);
            gammaPoint.add(p1);
            gammaPoint.add(p2);
            JPanel phononDispersion = new JPanel();
            phononDispersion.setBorder(new TitledBorder("phonon dispersion"));
            phononDispersion.setLayout(new BoxLayout(phononDispersion, 1));
            JPanel firstRow = new JPanel();
            firstRow.setLayout(new BoxLayout(firstRow, 0));
            JPanel type = new JPanel();
            String[] sw_ph_type = new String[]{String.valueOf(tag_phonon) + "method", String.valueOf(tag_phonon) + "calc_type"};
            String[] ph_choice = new String[]{this.NO_SELECTION, "band", "dos"};
            ChoicePanelPhase cppsw_ph_type = new ChoicePanelPhase(sw_ph_type, this.inputInterface, "method", ph_choice, this);
            type.add(cppsw_ph_type);
            JPanel pslsize = new JPanel();
            pslsize.setBorder(new TitledBorder("size of superlattice"));
            pslsize.setLayout(new BoxLayout(pslsize, 0));
            String[] slsizex = new String[]{String.valueOf(tag_phonon) + "lattice.l1"};
            String[] slsizey = new String[]{String.valueOf(tag_phonon) + "lattice.l2"};
            String[] slsizez = new String[]{String.valueOf(tag_phonon) + "lattice.l3"};
            InputPanelPhase ippslsizex = new InputPanelPhase(slsizex, this.inputInterface, "l1", 0, 5, this);
            InputPanelPhase ippslsizey = new InputPanelPhase(slsizey, this.inputInterface, "l2", 0, 5, this);
            InputPanelPhase ippslsizez = new InputPanelPhase(slsizez, this.inputInterface, "l3", 0, 5, this);
            pslsize.add(ippslsizex);
            pslsize.add(ippslsizey);
            pslsize.add(ippslsizez);
            firstRow.add(type);
            firstRow.add(pslsize);
            JPanel secondRow = new JPanel();
            secondRow.setLayout(new BoxLayout(secondRow, 0));
            JPanel pband = new JPanel();
            pband.setBorder(new TitledBorder("phonon band"));
            JButton fbzbutton = new JButton("boot FBZ viewer");
            pband.add(fbzbutton);
            JPanel pdos = new JPanel();
            pdos.setBorder(new TitledBorder("phonon DOS"));
            pdos.setLayout(new BoxLayout(pdos, 0));
            String[] specde = new String[]{String.valueOf(tag_phonon) + "dos.deltaE"};
            InputPanelPhase ippde = new InputPanelPhase(specde, this.inputInterface, "dE", 4, 5, this);
            JPanel pde = new JPanel();
            pde.add(ippde);
            JPanel mesh = new JPanel();
            mesh.setLayout(new BoxLayout(mesh, 0));
            mesh.setBorder(new TitledBorder("mesh"));
            String[] specnx = new String[]{String.valueOf(tag_phonon) + "dos.mesh.nx"};
            String[] specny = new String[]{String.valueOf(tag_phonon) + "dos.mesh.ny"};
            String[] specnz = new String[]{String.valueOf(tag_phonon) + "dos.mesh.nz"};
            InputPanelPhase ippnx = new InputPanelPhase(specnx, this.inputInterface, "nx", 0, 5, this);
            InputPanelPhase ippny = new InputPanelPhase(specny, this.inputInterface, "ny", 0, 5, this);
            InputPanelPhase ippnz = new InputPanelPhase(specnz, this.inputInterface, "nz", 0, 5, this);
            mesh.add(ippnx);
            mesh.add(ippny);
            mesh.add(ippnz);
            pdos.add(pde);
            pdos.add(mesh);
            secondRow.add(pband);
            secondRow.add(pdos);
            phononDispersion.add(firstRow);
            phononDispersion.add(secondRow);
            this.add(gammaPoint);
            fbzbutton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SubPanel.this.bootFBZViewer();
                }
            });
            int[] disable_dispersion = new int[1];
            int[] nArray2 = new int[2];
            nArray2[1] = 2;
            int[] disable_band = nArray2;
            int[] nArray3 = new int[2];
            nArray3[1] = 1;
            int[] disable_dos = nArray3;
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, cppsw_ph_type);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, ippslsizex);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, ippslsizex);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, ippslsizey);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, ippslsizez);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, fbzbutton);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, ippde);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, ippnx);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, ippny);
            PhononPanel.this.cppsw_phonon.registerDisabableGUI(disable, ippnz);
            cppsw_ph_type.registerDisabableGUI(disable_dispersion, ippslsizex);
            cppsw_ph_type.registerDisabableGUI(disable_dispersion, ippslsizey);
            cppsw_ph_type.registerDisabableGUI(disable_dispersion, ippslsizez);
            cppsw_ph_type.registerDisabableGUI(disable_dispersion, fbzbutton);
            cppsw_ph_type.registerDisabableGUI(disable_dispersion, ippde);
            cppsw_ph_type.registerDisabableGUI(disable_dispersion, ippnx);
            cppsw_ph_type.registerDisabableGUI(disable_dispersion, ippny);
            cppsw_ph_type.registerDisabableGUI(disable_dispersion, ippnz);
            cppsw_ph_type.registerDisabableGUI(disable_band, fbzbutton);
            cppsw_ph_type.registerDisabableGUI(disable_dos, ippde);
            cppsw_ph_type.registerDisabableGUI(disable_dos, ippnx);
            cppsw_ph_type.registerDisabableGUI(disable_dos, ippny);
            cppsw_ph_type.registerDisabableGUI(disable_dos, ippnz);
        }

        @Override
        public void generateKpoints(Kpoint[] kpoints, double dk) {
            PhononPanel.this.logger.debug((Object)"generating kpoints");
            if (kpoints != null) {
                int i = 0;
                while (i < kpoints.length) {
                    PhononPanel.this.logger.debug((Object)("kpoint no. " + i + ": " + kpoints[i]));
                    ++i;
                }
            }
            Vector<Kpoint> vec = new Vector<Kpoint>();
            int i = 0;
            while (i < kpoints.length) {
                if (vec.indexOf(kpoints[i]) < 0) {
                    vec.addElement(kpoints[i]);
                }
                ++i;
            }
            InputInterfaceTable special_points = this.inputInterface.getInputInterfaceTable("phonon.special_points");
            special_points.setTableIdentifiers(new String[]{"no", "k1", "k2", "k3"});
            special_points.initializeData();
            int i2 = 0;
            while (i2 < vec.size()) {
                Kpoint kp = (Kpoint)vec.get(i2);
                PhononPanel.this.logger.debug((Object)("adding kpoint: " + kp));
                double[] kpoin = kp.getDouble();
                String[] data = new String[]{String.valueOf(i2 + 1), String.valueOf(kpoin[0]), String.valueOf(kpoin[1]), String.valueOf(kpoin[2])};
                special_points.insertTableDataRow(data, i2);
                ++i2;
            }
            this.inputInterface.selectRoot();
            PrintWriter writer = Utils.getPrintWriter(String.valueOf(PhononPanel.this.projdir) + System.getProperty("file.separator") + PhononPanel.this.phbandcontrol);
            InputInterfaceTable symmetry_lines = this.inputInterface.getInputInterfaceTable("phonon.symmetry_lines");
            symmetry_lines.setTableIdentifiers(new String[]{"k1", "k2", "num_division"});
            symmetry_lines.initializeData();
            int sum = 1;
            int i3 = 0;
            while (i3 < kpoints.length - 1) {
                int k1 = vec.indexOf(kpoints[i3]) + 1;
                int k2 = vec.indexOf(kpoints[i3 + 1]) + 1;
                double distance = kpoints[i3].getDistanceFrom(kpoints[i3 + 1]);
                int div = 5;
                try {
                    div = (int)(0.5 * distance / dk);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (div == 0) {
                    div = 1;
                }
                int tmpsum = sum + div;
                String s1 = kpoints[i3].getSymbol();
                String s2 = kpoints[i3 + 1].getSymbol();
                if (writer != null) {
                    writer.println(String.valueOf(sum) + " " + tmpsum + " " + s1 + " " + s2);
                }
                sum = tmpsum;
                symmetry_lines.insertTableDataRow(new String[]{String.valueOf(k1), String.valueOf(k2), String.valueOf(div)}, i3);
                ++i3;
            }
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            this.inputInterface.selectRoot();
        }

        @Override
        public void saveInput(Kpoint[] kpoints, double deltak) {
            PhononPanel.this.logger.debug((Object)"saving input");
            int i = 0;
            while (i < kpoints.length) {
                PhononPanel.this.logger.debug((Object)("kpoint no. " + i + ": " + kpoints[i]));
                ++i;
            }
        }

        private void bootFBZViewer() {
            double[][] reclat = PhaseUtils.getReciprocalLatticeFrom(this.inputInterface);
            FBZData data = new FBZData();
            data.reciprocalLattice = reclat;
            data.baseDir = PhononPanel.this.projdir;
            data.kpointGenerator = this;
            new FBZ(data);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Kpoint[] getKpointsFrom(String file) {
            PhononPanel.this.logger.debug((Object)"reading kpoints from file");
            Kpoint[] ret = null;
            try {
                InputInterfaceTable speacial_points = this.inputInterface.getInputInterfaceTable("phonon.special_points");
                Vector data = speacial_points.getTableData();
                if (data == null) return null;
                if (data.size() == 0) {
                    return null;
                }
                Kpoint[] kps = new Kpoint[data.size()];
                HashMap<String, Kpoint> map = new HashMap<String, Kpoint>();
                int i = 0;
                block9: while (true) {
                    if (i >= data.size()) {
                        try {
                            BufferedReader rd;
                            InputInterfaceTable symmetry_lines = this.inputInterface.getInputInterfaceTable("phonon.symmetry_lines");
                            Vector symline = symmetry_lines.getTableData();
                            if (symline == null) return null;
                            if (symline.size() == 0) {
                                return null;
                            }
                            ret = new Kpoint[symline.size() + 1];
                            String[] firstData = (String[])symline.get(0);
                            ret[0] = (Kpoint)map.get(firstData[0]);
                            PhononPanel.this.logger.debug((Object)("first k-point: " + ret[0]));
                            int i2 = 0;
                            block10: while (true) {
                                if (i2 >= symline.size()) {
                                    File controlfile = new File(String.valueOf(PhononPanel.this.projdir) + System.getProperty("file.separator") + PhononPanel.this.phbandcontrol);
                                    if (!controlfile.exists()) break block9;
                                    rd = Utils.getReader(controlfile.getAbsolutePath());
                                    String line = "";
                                    try {
                                        int count = 0;
                                        block11: while ((line = rd.readLine()) != null) {
                                            String[] dat = line.trim().split("\\s+");
                                            String str = "";
                                            int i22 = 0;
                                            while (true) {
                                                if (i22 >= dat.length) {
                                                    PhononPanel.this.logger.debug((Object)("str: " + str));
                                                    if (dat.length < 4) continue block11;
                                                    String ident = dat[2];
                                                    ret[count].setSymbol(ident);
                                                    if (++count != symline.size()) continue block11;
                                                    ret[count].setSymbol(dat[3]);
                                                    break block10;
                                                }
                                                str = String.valueOf(str) + dat[i22] + " ";
                                                ++i22;
                                            }
                                        }
                                        break;
                                    }
                                    catch (IOException ioe) {
                                        ioe.printStackTrace();
                                        break;
                                    }
                                }
                                String[] strdata = (String[])symline.get(i2);
                                String id2 = strdata[1];
                                ret[i2 + 1] = (Kpoint)map.get(id2);
                                PhononPanel.this.logger.debug((Object)("sym. line: " + strdata[0] + " " + strdata[1] + " " + strdata[2]));
                                PhononPanel.this.logger.debug((Object)("map.get(id2): " + ret[i2 + 1]));
                                ++i2;
                            }
                            try {
                                rd.close();
                            }
                            catch (IOException iOException) {}
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                        }
                        break;
                    }
                    String[] strdata = (String[])data.get(i);
                    String ident = strdata[0];
                    float k1 = Float.parseFloat(strdata[1]);
                    float k2 = Float.parseFloat(strdata[2]);
                    float k3 = Float.parseFloat(strdata[3]);
                    kps[i] = new Kpoint(new float[]{k1, k2, k3});
                    map.put(ident, kps[i]);
                    PhononPanel.this.logger.debug((Object)("read kpoint: " + kps[i]));
                    ++i;
                }
                PhononPanel.this.logger.debug((Object)"final kpoints: ");
                i = 0;
                while (true) {
                    if (i >= ret.length) {
                        return ret;
                    }
                    PhononPanel.this.logger.debug((Object)("no. " + i + " : " + ret[i]));
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return ret;
            }
            catch (ArrayIndexOutOfBoundsException aobe) {
                aobe.printStackTrace();
            }
            return ret;
        }
    }
}

