/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import ciss.phase_viewer.common.TemplateCopier;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileChangeEvent;
import ciss.phase_viewer.file.FileChangeListener;
import ciss.phase_viewer.file.FileNameEditPanel;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.ElemPanel;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class GeneralPanel
extends ProjectManipulator
implements FileChangeListener {
    private Logger logger = Logger.getLogger((String)GeneralPanel.class.getName());
    private GlobalProperties pm = PropertiesManager.getGlobalProperties(0);
    private JPanel AccuracyPanel;
    private JPanel ControlPanel;
    private JPanel PostProcessPanel;
    private JPanel SolverPanel;
    private JPanel StructurePanel;
    private JButton editFileNamesData;
    private JButton editFileNamesDataEditor;
    private JTextField inputFileName;
    private JEditorPane jEditorPane1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JButton templateCopy;
    private JButton viewByEditor;

    public GeneralPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public void init() {
        this.initComponents();
        ProjectBrowserUtils.setHtmlToEditorPane(this.jEditorPane1, this.getClass().getResource("/ciss/phase_viewer/plugins/projectmanipulator/phase/preparationpanel/basic.html"));
        this.logger.debug((Object)("projectInfo: " + this.projectInfo));
        ChaseFile[] finp = this.projectInfo.getChaseFileManager().getFiles("F_INP");
        finp[0].addFileChangeListener(this);
        this.inputFileName.setHorizontalAlignment(0);
        this.inputFileName.setBackground(Color.WHITE);
        this.inputFileName.setText(finp[0].getFileName());
    }

    @Override
    public void fileChanged(ChaseFileChangeEvent e) {
        ChaseFile newchfile = e.getFile();
        this.inputFileName.setText(newchfile.getFileName());
        this.projectInfo.getInputInterface().saveTo(new File(String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + newchfile.getFileName()));
    }

    @Override
    public void initializeProject() {
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel4 = new JPanel();
        this.editFileNamesData = new JButton();
        this.editFileNamesDataEditor = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.inputFileName = new JTextField(10);
        this.templateCopy = new JButton();
        this.viewByEditor = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jPanel3.setBorder(new TitledBorder("input file"));
        this.inputFileName.setEditable(false);
        this.inputFileName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPanel.this.inputFileNameActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.inputFileName);
        this.templateCopy.setText("template");
        this.templateCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPanel.this.templateCopyActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.templateCopy);
        this.viewByEditor.setText("editor");
        this.viewByEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPanel.this.viewByEditorActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jPanel3);
        this.jPanel4.setBorder(new TitledBorder("edit file names"));
        this.editFileNamesData.setText("edit file names");
        this.editFileNamesData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPanel.this.editFileNamesDataActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.editFileNamesData);
        this.editFileNamesDataEditor.setText("edit file names using editor");
        this.editFileNamesDataEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPanel.this.editFileNamesDataEditorActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.editFileNamesDataEditor);
        this.jPanel6.setLayout(new BoxLayout(this.jPanel6, 0));
        this.jPanel6.add(this.jPanel4);
        this.jPanel1.add(this.jPanel6);
        JComponent ePanel = (JComponent)this.projectInfo.getGUI(ElemPanel.class);
        JPanel ppPanel = new JPanel();
        ppPanel.setLayout(new GridLayout());
        ppPanel.setBorder(new TitledBorder("pseudopotential file(s)"));
        ppPanel.add(ePanel);
        this.jPanel1.add(ppPanel);
        this.setLayout(new GridLayout());
        this.add(this.jPanel1);
    }

    private void viewByEditorActionPerformed(ActionEvent evt) {
        String nfinp = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.projectInfo.getChaseFileManager().getFile("F_INP").getFileName();
        ProjectBrowserUtils.bootTextViewer(nfinp);
    }

    private void editFileNamesDataEditorActionPerformed(ActionEvent evt) {
        String fnames = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.projectInfo.getChaseFileManager().getFile("FFILENAMES").getFileName();
        ProjectBrowserUtils.bootTextViewer(fnames);
    }

    private void inputFileNameActionPerformed(ActionEvent evt) {
    }

    private void editFileNamesDataActionPerformed(ActionEvent evt) {
        FileNameEditPanel editPanel = new FileNameEditPanel(this.projectInfo.getChaseFileManager());
    }

    private void templateCopyActionPerformed(ActionEvent evt) {
        this.bootTemplateCopierInpFile();
    }

    private void bootTemplateCopierInpFile() {
        String nfinp = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.projectInfo.getChaseFileManager().getFile("F_INP").getFileName();
        String definp = String.valueOf(System.getProperty("pviewer.home")) + System.getProperty("file.separator") + this.pm.getProperty("inpdir");
        TemplateCopier copier = new TemplateCopier(this, nfinp);
        copier.setTemplatePath(definp);
        if (!copier.copyTemplate()) {
            this.logger.info((Object)"operation canceled/failed.");
            return;
        }
    }
}

