/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.CheckPanelPhase;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

class AccuracyPanelPanel
extends PhaseInputItems {
    private InputPanelPhase numbands;

    AccuracyPanelPanel(InputInterface inputInterface) {
        super(inputInterface);
    }

    @Override
    public void createGUI() {
        this.add(this.createAccuracyPanel());
    }

    private JPanel createAccuracyPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setSize(500, 250);
        JPanel p_cutoff = new JPanel();
        p_cutoff.setLayout(new GridLayout(1, 2, 1, 1));
        String accuracy = "accuracy.";
        String[] specWF = new String[]{String.valueOf(accuracy) + "cutoff_wf", String.valueOf(accuracy) + "cke_wf", String.valueOf(accuracy) + "cke_wavefunctions", String.valueOf(accuracy) + "cutoff_energy_for_wavefunctions"};
        String[] specCD = new String[]{String.valueOf(accuracy) + "cutoff_cd", String.valueOf(accuracy) + "cke_cd", String.valueOf(accuracy) + "cutoff_energy_for_chargedensity", String.valueOf(accuracy) + "cke_chargedensity"};
        InputPanelPhase wf = new InputPanelPhase(specWF, this.inputInterface, "wave function", 4, 7, this);
        InputPanelPhase cd = new InputPanelPhase(specCD, this.inputInterface, "charge density", 4, 7, this);
        p_cutoff.setBorder(new TitledBorder("Cut-off"));
        p_cutoff.add(wf);
        p_cutoff.add(cd);
        p.add(p_cutoff);
        JPanel p_numband = new JPanel();
        p_numband.setLayout(new GridLayout(1, 2, 1, 1));
        String[] specNumBnd = new String[]{String.valueOf(accuracy) + "num_bands"};
        this.numbands = new InputPanelPhase(specNumBnd, this.inputInterface, "num. bands", 0, 7, this);
        String[] specXC = new String[]{String.valueOf(accuracy) + "xctype"};
        String[] xcChoice = new String[]{this.NO_SELECTION, "ldapw91", "ggapbe"};
        ChoicePanelPhase xc = new ChoicePanelPhase(specXC, this.inputInterface, "XC type", xcChoice, this);
        JButton checknumbands = new JButton("check");
        JPanel pband = new JPanel();
        pband.setLayout(new BoxLayout(pband, 0));
        pband.add(this.numbands);
        pband.add(checknumbands);
        p_numband.add(pband);
        p_cutoff.add(p_numband);
        JPanel ppaw = new JPanel();
        ppaw.setLayout(new BoxLayout(ppaw, 0));
        ppaw.setBorder(new TitledBorder("PAW"));
        CheckPanelPhase cppPAW = new CheckPanelPhase(new String[]{String.valueOf(accuracy) + "paw"}, this.inputInterface, "use the PAW method when possible", this, false);
        JPanel pppaw = new JPanel();
        pppaw.add(cppPAW);
        ppaw.add(pppaw);
        p.add(ppaw);
        JPanel p_ksample = new JPanel();
        p_ksample.setLayout(new BoxLayout(p_ksample, 1));
        p_ksample.setBorder(new TitledBorder("method"));
        String ksamp = String.valueOf(accuracy) + "ksampling.";
        String[] specMethod = new String[]{String.valueOf(ksamp) + "method"};
        String[] methodChoice = new String[]{this.NO_SELECTION, "monk", "mesh", "file", "gamma"};
        JPanel pmethod = new JPanel();
        ChoicePanelPhase method = new ChoicePanelPhase(specMethod, this.inputInterface, null, methodChoice, this);
        JPanel pmet = new JPanel();
        pmet.setLayout(new GridLayout(3, 1));
        pmet.add(new JPanel());
        pmet.add(method);
        pmet.add(new JPanel());
        p_ksample.add(pmet);
        JPanel ptable = new JPanel();
        ptable.setLayout(new BoxLayout(ptable, 1));
        String[] kmeshSpec = new String[]{String.valueOf(ksamp) + "mesh"};
        TableForInputInterface kmeshTable = new TableForInputInterface(kmeshSpec, this.inputInterface, null, this);
        kmeshTable.getModel().addTableModelListener(this);
        JScrollPane scrPaneKmesh = new JScrollPane();
        scrPaneKmesh.getViewport().setView(kmeshTable.getPanel());
        ptable.add(kmeshTable.getPanel());
        int icol = kmeshTable.getModel().getColumnCount();
        int[] intarray = new int[]{3, 4, 5};
        int j = 0;
        while (j < icol) {
            DefaultCellEditor editor = (DefaultCellEditor)kmeshTable.getColumnModel().getColumn(j).getCellEditor();
            method.registerDisabableGUI(intarray, (JComponent)editor.getComponent());
            ++j;
        }
        String[] ksampIdent = new String[]{String.valueOf(ksamp) + "kshift"};
        TableForInputInterface kshiftTable = new TableForInputInterface(ksampIdent, this.inputInterface, null, this);
        JScrollPane scrPaneKshift = new JScrollPane();
        scrPaneKshift.getViewport().setView(kshiftTable.getPanel());
        ptable.add(kshiftTable.getPanel());
        icol = kshiftTable.getModel().getColumnCount();
        int[] intshift = new int[]{2, 3, 4, 5};
        int j2 = 0;
        while (j2 < icol) {
            DefaultCellEditor editor = (DefaultCellEditor)kshiftTable.getColumnModel().getColumn(j2).getCellEditor();
            method.registerDisabableGUI(intshift, (JComponent)editor.getComponent());
            ++j2;
        }
        JPanel p_ksample_all = new JPanel();
        p_ksample_all.setBorder(new TitledBorder("K point sampling"));
        p_ksample_all.setLayout(new BoxLayout(p_ksample_all, 0));
        p_ksample_all.add(p_ksample);
        p_ksample_all.add(ptable);
        p.add(p_ksample_all);
        JPanel p_smear = new JPanel();
        p_smear.setLayout(new GridLayout(1, 2, 1, 1));
        String[] specSmear = new String[]{String.valueOf(accuracy) + "smearing.method"};
        String[] smearChoice = new String[]{this.NO_SELECTION, "parabolic", "cold", "tetrahedron"};
        Vector<String[]> smearDupli = new Vector<String[]>();
        smearDupli.add(new String[]{"3", "tetrahedral"});
        ChoicePanelPhase smear = new ChoicePanelPhase(specSmear, this.inputInterface, "Method", smearChoice, smearDupli, this);
        p_smear.add(smear);
        String[] specWidth = new String[]{String.valueOf(accuracy) + "smearing.width"};
        InputPanelPhase width = new InputPanelPhase(specWidth, this.inputInterface, "width", 4, 5, this);
        p_smear.add(width);
        smear.registerDisabableGUI(new int[]{3}, width);
        p_smear.setBorder(new TitledBorder("Smearing"));
        p.add(p_smear);
        JPanel p_conv = new JPanel();
        p_conv.setLayout(new GridLayout(1, 3));
        String scfconv = String.valueOf(accuracy) + "scf_convergence.";
        String[] specConvDe = new String[]{String.valueOf(scfconv) + "delta_total_energy"};
        InputPanelPhase scfde = new InputPanelPhase(specConvDe, this.inputInterface, "dE", 4, 5, this);
        p_conv.add(scfde);
        String[] specSuc = new String[]{String.valueOf(scfconv) + "succession"};
        InputPanelPhase scfsuc = new InputPanelPhase(specSuc, this.inputInterface, "succession", 0, 5, this);
        p_conv.add(scfsuc);
        String[] specForceConv = new String[]{String.valueOf(accuracy) + "force_convergence.max_force"};
        InputPanelPhase forcConv = new InputPanelPhase(specForceConv, this.inputInterface, "force", 5, 5, this);
        p_conv.add(forcConv);
        p_conv.setBorder(new TitledBorder("Convergence"));
        p.add(p_conv);
        JPanel p_init = new JPanel();
        p_init.setLayout(new GridLayout(1, 2, 1, 1));
        String[] initWFSpec = new String[]{String.valueOf(accuracy) + "initial_wavefunctions"};
        String[] initWFChoice = new String[]{this.NO_SELECTION, "Matrix_diagon", "Random_numbers", "atomic_orbitals", "file"};
        ChoicePanelPhase initWF = new ChoicePanelPhase(initWFSpec, this.inputInterface, "wave function", initWFChoice, this);
        String[] matdiagonCutoffSpec = new String[]{String.valueOf(accuracy) + "matrix_diagon.cutoff_wf"};
        InputPanelPhase matdiagon = new InputPanelPhase(matdiagonCutoffSpec, this.inputInterface, "cutoff (matrix diagon)", 4, 5, this);
        p_init.add(initWF);
        p_init.add(matdiagon);
        int[] nArray = new int[2];
        nArray[1] = 2;
        initWF.registerDisabableGUI(nArray, matdiagon);
        String[] initCDSpec = new String[]{String.valueOf(accuracy) + "initial_charge_density"};
        String[] initCDChoice = new String[]{"Gauss", "atomic_charge_density", "file"};
        ChoicePanelPhase initCD = new ChoicePanelPhase(initCDSpec, this.inputInterface, "charge density", initCDChoice, this);
        p_init.add(initCD);
        p_init.setBorder(new TitledBorder("Initial"));
        p.add(p_init);
        checknumbands.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AccuracyPanelPanel.this.checkNumBands();
            }
        });
        return p;
    }

    private void checkNumBands() {
        int currnumbands = -1;
        try {
            currnumbands = Integer.parseInt(this.numbands.getValue().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int defnumb = PhaseUtils.checkNumBands(this, currnumbands, this.inputInterface);
        if (defnumb > 0) {
            this.numbands.getTextField().setText(String.valueOf(defnumb));
        }
    }
}

