/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.inputwizard;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.input.InputWizard;
import ciss.phase_viewer.input.InputWizardController;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class PostProcWiz
implements InputWizard {
    private Logger logger = Logger.getLogger((String)PostProcWiz.class.getName());
    private JPanel panel;
    private InputInterface input;
    private AtomCoords coords;

    @Override
    public String process() {
        InputInterfacePrimitiveEntry pcharge;
        InputInterfacePrimitiveEntry charge;
        InputInterfacePrimitiveEntry dosEntry = this.input.getInputInterfacePrimitiveEntry("postprocessing.dos.sw_dos");
        InputInterfacePrimitiveEntry dosMethod = this.input.getInputInterfacePrimitiveEntry("postprocessing.dos.method");
        if (dosEntry.getValue().equalsIgnoreCase("on") && dosMethod.getValue().equalsIgnoreCase("tetrahedral")) {
            this.input.getInputInterfacePrimitiveEntry("accuracy.ksampling.method").setValue("mesh");
            this.input.getInputInterfacePrimitiveEntry("accuracy.smearing.method").setValue("tetrahedron");
        }
        if (this.input.getInputInterfacePrimitiveEntry("postprocessing.ldos.sw_aldos").getValue().equalsIgnoreCase("on")) {
            InputInterfaceTable table = this.input.getInputInterfaceTable("structure.atom_list.atoms");
            int index = table.getIndexFor("aldos");
            Vector atoms = table.getTableData();
            int i = 0;
            while (i < atoms.size()) {
                ((String[])atoms.get((int)i))[index] = "1";
                ++i;
            }
        }
        if (this.input.getInputInterfacePrimitiveEntry("postprocessing.ldos.sw_layerdos").getValue().equalsIgnoreCase("on")) {
            this.input.getInputInterfacePrimitiveEntry("postprocessing.ldos.layerdos.slicing_way").setValue("regular_intervals");
            this.input.getInputInterfacePrimitiveEntry("postprocessing.ldos.layerdos.deltaz").setValue("0.5");
        }
        if ((charge = this.input.getInputInterfacePrimitiveEntry("postprocessing.charge.sw_charge_rspace")).getValue().equalsIgnoreCase("on")) {
            this.input.getInputInterfacePrimitiveEntry("postprocessing.charge.filetype").setValue("cube");
            InputInterfacePrimitiveEntry title = this.input.getInputInterfacePrimitiveEntry("postprocessing.charge.title");
            title.setDoubleQuoted(true);
            title.setValue("charge density calculated by PHASE");
        }
        if ((pcharge = this.input.getInputInterfacePrimitiveEntry("postprocessing.charge.partial_charge.sw_partial_charge")).getValue().equalsIgnoreCase("on")) {
            InputInterfacePrimitiveEntry delta = this.input.getInputInterfacePrimitiveEntry("postprocessing.charge.partial_charge.Erange_delta");
            delta.setValue("0.05");
            delta.setUnit("eV");
            this.input.getInputInterfacePrimitiveEntry("postprocessing.charge.partial_charge.partial_charge_filetype").setValue("individual");
        }
        if (((SubPanel)this.panel).wfEnabled()) {
            this.input.getInputInterfacePrimitiveEntry("postprocessing.stm.sw_stm").setValue("on");
            if (PhaseUtils.hasUSPP(this.coords)) {
                this.input.getInputInterfacePrimitiveEntry("postprocessing.stm.sw_deficit_charge").setValue("on");
            }
        }
        return "configured postprocessing";
    }

    @Override
    public void setInput(Input input) {
        this.input = (InputInterface)input;
    }

    @Override
    public boolean hasPrevious() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public boolean hasFinished() {
        return true;
    }

    @Override
    public String getName() {
        return "post processing";
    }

    @Override
    public JPanel getGUI() {
        if (this.panel == null) {
            this.createGUI();
        }
        return this.panel;
    }

    private void createGUI() {
        this.panel = new SubPanel(this.input);
    }

    @Override
    public String getDescription() {
        return "edit configurations for post processing.";
    }

    @Override
    public void setProperties(HashMap properties) {
        this.coords = (AtomCoords)properties.get("atomcoords");
    }

    @Override
    public void setParent(InputWizardController parent) {
    }

    class SubPanel
    extends PhaseInputItems {
        private JCheckBox wfCheckBox;

        SubPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        @Override
        public void createGUI() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel p1 = new JPanel();
            p1.setLayout(new BoxLayout(p1, 0));
            p1.setBorder(new TitledBorder("DOS"));
            JPanel pdostot = new JPanel();
            String[] dosspec = new String[]{"postprocessing.dos.sw_dos"};
            ChoicePanelPhase cppdossw = new ChoicePanelPhase(dosspec, this.inputInterface, "total dos", this.ON_OFF, this);
            String[] method = new String[]{"postprocessing.dos.method"};
            ChoicePanelPhase cppdosm = new ChoicePanelPhase(method, this.inputInterface, "method", new String[]{"gaussian", "tetrahedral"}, this);
            pdostot.setLayout(new BoxLayout(pdostot, 0));
            JPanel pdossw = new JPanel();
            pdossw.add(cppdossw);
            JPanel pdosm = new JPanel();
            pdosm.add(cppdosm);
            pdostot.add(pdossw);
            pdostot.add(pdosm);
            String[] aldos = new String[]{"postprocessing.ldos.sw_aldos"};
            ChoicePanelPhase cppaldossw = new ChoicePanelPhase(aldos, this.inputInterface, "aldos", this.ON_OFF, this);
            JPanel paldos = new JPanel();
            paldos.add(cppaldossw);
            p1.add(pdostot);
            p1.add(paldos);
            JPanel playerdos = new JPanel();
            String[] layerdos = new String[]{"postprocessing.ldos.sw_layerdos"};
            ChoicePanelPhase cpplayerdossw = new ChoicePanelPhase(layerdos, this.inputInterface, "layerdos", this.ON_OFF, this);
            String[] normal = new String[]{"postprocessing.ldos.layerdos.normal_axis"};
            String[] nchoice = new String[]{"1", "2", "3"};
            ChoicePanelPhase cppnchoice = new ChoicePanelPhase(normal, this.inputInterface, "axis", nchoice, this);
            cppnchoice.getComboBox().setSelectedIndex(2);
            playerdos.add(cpplayerdossw);
            playerdos.add(cppnchoice);
            p1.add(playerdos);
            String[] pdos = new String[]{"postprocessing.pdos.sw_pdos"};
            ChoicePanelPhase cpppdos = new ChoicePanelPhase(pdos, this.inputInterface, "pdos", this.ON_OFF, this);
            JPanel ppdos = new JPanel();
            ppdos.add(cpppdos);
            int[] nArray = new int[2];
            nArray[1] = 2;
            int[] disab = nArray;
            cppdossw.registerDisabableGUI(disab, cppdosm);
            cppdossw.registerDisabableGUI(disab, cppaldossw);
            cppdossw.registerDisabableGUI(disab, cpplayerdossw);
            cpplayerdossw.registerDisabableGUI(disab, cppnchoice);
            cppdossw.registerDisabableGUI(disab, cpppdos);
            JPanel p2 = new JPanel();
            p2.setLayout(new BoxLayout(p2, 0));
            p2.setBorder(new TitledBorder("charge"));
            String[] charge = new String[]{"postprocessing.charge.sw_charge_rspace"};
            String[] charge_title = new String[]{"postprocessing.charge.title"};
            String[] pcharge = new String[]{"postprocessing.charge.partial_charge.sw_partial_charge"};
            String[] emin = new String[]{"postprocessing.charge.partial_charge.Erange_min"};
            String[] emax = new String[]{"postprocessing.charge.partial_charge.Erange_max"};
            ChoicePanelPhase cppcharge = new ChoicePanelPhase(charge, this.inputInterface, "charge", this.ON_OFF, this);
            ChoicePanelPhase cpppcharge = new ChoicePanelPhase(pcharge, this.inputInterface, "pcharge", this.ON_OFF, this);
            InputPanelPhase ippemin = new InputPanelPhase(emin, this.inputInterface, "min", 4, 5, this);
            ippemin.getTextField().setText("-0.5");
            ippemin.getComboBox().setSelectedItem("eV");
            InputPanelPhase ippemax = new InputPanelPhase(emax, this.inputInterface, "max", 4, 5, this);
            ippemax.getTextField().setText("0.5");
            ippemax.getComboBox().setSelectedItem("eV");
            p2.add(cppcharge);
            p2.add(cpppcharge);
            p2.add(ippemin);
            p2.add(ippemax);
            cppcharge.registerDisabableGUI(disab, cpppcharge);
            cpppcharge.registerDisabableGUI(disab, ippemin);
            cpppcharge.registerDisabableGUI(disab, ippemax);
            JPanel pwf = new JPanel();
            pwf.setBorder(new TitledBorder("work function"));
            this.wfCheckBox = new JCheckBox("generate output for work function analysis");
            pwf.add(this.wfCheckBox);
            this.add(p1);
            this.add(p2);
            this.add(pwf);
        }

        boolean wfEnabled() {
            return this.wfCheckBox.isSelected();
        }
    }
}

