/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.ekcal.resultsviewerpanel;

import Jama.Matrix;
import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.acviewer.fbz.FBZData;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzAttributes;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.tools.BandPlPanel;
import ciss.phase_viewer.primitiveguis.ComboButton;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class BandPanel
extends ProjectManipulator
implements OutputParserListener,
MouseListener,
KeyListener {
    private Logger logger = Logger.getLogger((String)BandPanel.class.getName());
    private OutputParser parser;
    private boolean spin = false;
    private JList bandList;
    private DefaultListModel bandListModel;
    private JList bandListDown;
    private DefaultListModel bandListModelDown;
    private JButton viewbtn;
    private OutputData[] eigenvalues;
    private float fermi;
    private float meaninglessValue = VolumetricData.meaninglessValue;

    public BandPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        this.setLayout(new BoxLayout(this, 1));
    }

    @Override
    public void recreate() {
        this.projectInfo.getOutputInterface().initCache();
        this.init();
        this.revalidate();
    }

    @Override
    public void parseFinished() {
        this.removeAll();
        JPanel pbtn = new JPanel();
        pbtn.setLayout(new BoxLayout(pbtn, 0));
        JPanel button = null;
        if (new Boolean(this.parser.getGenericData("banddata")[0]).booleanValue()) {
            button = new JPanel();
            button.setBorder(new TitledBorder("band.pl"));
            button.setLayout(new FlowLayout());
            JButton btndospl = new JButton("run band.pl");
            button.add(btndospl);
            ComboButton cbband = new ComboButton(this.projectInfo.getProjectDirectory(), "band_structure.eps");
            button.add(cbband);
            btndospl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BandPanel.this.bootBandPlPanel();
                }
            });
        }
        File fsfile = new File(String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "fs.data");
        JPanel pbi = null;
        if (fsfile.exists()) {
            JScrollPane sp;
            this.viewbtn = new JButton("view");
            this.viewbtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BandPanel.this.bootViewer();
                }
            });
            this.eigenvalues = this.parser.getOutputData();
            if (this.parser.getOutputData().length > 1) {
                this.spin = true;
            }
            this.fermi = Float.parseFloat(this.parser.getGenericData("fermi")[0]);
            this.bandListModel = new DefaultListModel();
            this.bandList = this.createBandList(0, this.bandListModel);
            if (this.spin) {
                this.bandListModelDown = new DefaultListModel();
                this.bandListDown = this.createBandList(1, this.bandListModelDown);
            }
            pbi = new JPanel();
            pbi.setBorder(new TitledBorder("reciprocal space"));
            pbi.setLayout(new BoxLayout(pbi, 0));
            if (!this.spin) {
                sp = new JScrollPane(this.bandList);
                sp.setPreferredSize(new Dimension(200, 150));
                pbi.add(sp);
            } else {
                sp = new JScrollPane(this.bandList);
                JScrollPane spd = new JScrollPane(this.bandListDown);
                sp.setPreferredSize(new Dimension(200, 150));
                spd.setPreferredSize(new Dimension(200, 150));
                JTabbedPane tp = new JTabbedPane();
                tp.add("up", sp);
                tp.add("down", spd);
                pbi.add(tp);
            }
            pbi.add(this.viewbtn);
        }
        if (button != null) {
            pbtn.add(button);
        }
        if (pbi != null) {
            pbtn.add(pbi);
        }
        this.add(pbtn);
        JPanel dataPanel = this.projectInfo.getOutputInterface().getDataPanel("F_ENERG");
        this.add(dataPanel);
        this.revalidate();
    }

    private JList createBandList(int ind, DefaultListModel bandListModel) {
        JList bandList = new JList(bandListModel);
        bandList.addKeyListener(this);
        bandList.addMouseListener(this);
        String[][] d2d = this.eigenvalues[ind].getData2D();
        int numbands = d2d[0].length - 5;
        boolean[] crossesFermi = new boolean[numbands];
        float[] min = new float[numbands];
        float[] max = new float[numbands];
        this.logger.debug((Object)("fermi energy: " + this.fermi));
        int bandindex = 0;
        while (bandindex < numbands) {
            float minval = 1000000.0f;
            float maxval = -1000000.0f;
            boolean hasValSmallerThanFermi = false;
            boolean hasValLargerThanFermi = false;
            boolean cf = false;
            int i = 0;
            while (i < d2d.length) {
                float dat = Float.parseFloat(d2d[i][5 + bandindex]);
                if (dat > this.fermi) {
                    hasValLargerThanFermi = true;
                }
                if (dat < this.fermi) {
                    hasValSmallerThanFermi = true;
                }
                if (hasValSmallerThanFermi && hasValLargerThanFermi) {
                    cf = true;
                }
                if (dat < minval) {
                    minval = dat;
                }
                if (dat > maxval) {
                    maxval = dat;
                }
                ++i;
            }
            crossesFermi[bandindex] = cf;
            min[bandindex] = minval;
            max[bandindex] = maxval;
            this.logger.debug((Object)("band no. " + bandindex + " crosses fermi: " + crossesFermi[bandindex]));
            ++bandindex;
        }
        bandList.setCellRenderer(new BandCellRenderer(crossesFermi));
        DecimalFormat form = new DecimalFormat("0.000");
        int i = 5;
        while (i < d2d[0].length) {
            bandListModel.addElement("    " + String.valueOf(i - 4) + "    (min: " + form.format(min[i - 5]) + "  max: " + form.format(max[i - 5]) + ")");
            ++i;
        }
        return bandList;
    }

    private void bootViewer() {
        int[][] bindeces;
        boolean[] foo;
        int ntot;
        float[][] delta;
        int[] ndiv;
        VolumetricData[] vdata;
        double[][] reclat;
        BufferedReader reader;
        block25: {
            String fsfile = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "fs.data";
            reader = null;
            reclat = null;
            vdata = null;
            reader = new BufferedReader(new FileReader(fsfile));
            String line = "";
            String[] b1 = reader.readLine().trim().split("\\s+");
            String[] b2 = reader.readLine().trim().split("\\s+");
            String[] b3 = reader.readLine().trim().split("\\s+");
            ndiv = new int[]{Integer.parseInt(b1[0]), Integer.parseInt(b2[0]), Integer.parseInt(b3[0])};
            delta = new float[3][3];
            int i = 0;
            while (i < 3) {
                delta[0][i] = Float.parseFloat(b1[i + 1]);
                delta[1][i] = Float.parseFloat(b2[i + 1]);
                delta[2][i] = Float.parseFloat(b3[i + 1]);
                ++i;
            }
            reclat = new double[3][3];
            i = 0;
            while (i < 3) {
                reclat[i][0] = (double)delta[i][0] * (double)(ndiv[i] - 1);
                reclat[i][1] = (double)delta[i][1] * (double)(ndiv[i] - 1);
                reclat[i][2] = (double)delta[i][2] * (double)(ndiv[i] - 1);
                this.logger.debug((Object)("rec. lat: " + reclat[i][0] + ", " + reclat[i][1] + ", " + reclat[i][2]));
                ++i;
            }
            ntot = ndiv[0] * ndiv[1] * ndiv[2];
            foo = new boolean[ntot];
            int ii = 0;
            while ((line = reader.readLine()) != null) {
                String[] ar = line.trim().split("\\s+");
                foo[ii] = new Boolean(ar[3]);
                ++ii;
            }
            ii = 0;
            bindeces = null;
            if (this.spin) {
                bindeces = new int[][]{this.bandList.getSelectedIndices(), this.bandListDown.getSelectedIndices()};
                vdata = new VolumetricData[bindeces[0].length + bindeces[1].length];
            } else {
                bindeces = new int[][]{this.bandList.getSelectedIndices()};
                vdata = new VolumetricData[bindeces[0].length];
            }
            if (vdata.length != 0) break block25;
            this.logger.info((Object)"select band indices.");
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            try {
                int iband = 0;
                int iind = 0;
                while (iind < bindeces.length) {
                    int[] bandIndeces = bindeces[iind];
                    this.logger.debug((Object)("iind: " + iind));
                    int ba = 0;
                    while (ba < bandIndeces.length) {
                        int bandIndex = bandIndeces[ba];
                        String[][] data = this.parser.getOutputData()[iind].getData2D();
                        float[] eigenValues = new float[data.length];
                        int i = 0;
                        while (i < data.length) {
                            String[] datum = data[i];
                            eigenValues[i] = Float.parseFloat(datum[5 + bandIndex]);
                            ++i;
                        }
                        float[] eigen = new float[ntot];
                        int count = 0;
                        int eigCount = 0;
                        int i2 = 0;
                        while (i2 < ntot) {
                            if (foo[i2]) {
                                eigen[count] = eigenValues[eigCount];
                                ++count;
                                ++eigCount;
                            } else {
                                eigen[count] = this.meaninglessValue;
                                ++count;
                            }
                            ++i2;
                        }
                        float[] ori = new float[3];
                        int i3 = 0;
                        while (i3 < 3) {
                            ori[i3] = (float)(reclat[0][i3] * 0.5) + (float)(reclat[1][i3] * 0.5) + (float)(reclat[2][i3] * 0.5);
                            ++i3;
                        }
                        vdata[iband] = new VolumetricData(eigen, ndiv, delta, ori);
                        vdata[iband].setInterpolationScheme(VolumetricData.LINEAR);
                        ++iband;
                        ++ba;
                    }
                    ++iind;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FBZData dat = new FBZData();
        dat.reciprocalLattice = reclat;
        dat.baseDir = this.projectInfo.getProjectDirectory();
        dat.fermiEnergy = this.fermi;
        dat.eigenValues = vdata;
        FBZ fbz = new FBZ(dat);
        WignerSeitzAttributes wsattrs = fbz.getFBZ().getAttributes();
    }

    private int[] getKpointCoefficient(float[][] reclat, float[] kpts) {
        double[][] tmprec = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                tmprec[i][j] = reclat[j][i];
                ++j;
            }
            ++i;
        }
        Matrix B = new Matrix(tmprec);
        double[][] tmpmat = new double[3][1];
        tmpmat[0][0] = kpts[0];
        tmpmat[1][0] = kpts[1];
        tmpmat[2][0] = kpts[2];
        Matrix K = new Matrix(tmpmat);
        Matrix S = B.solve(K);
        int x = Math.round((float)S.get(0, 0));
        int y = Math.round((float)S.get(1, 0));
        int z = Math.round((float)S.get(2, 0));
        return new int[]{x, y, z};
    }

    @Override
    public void initializeProject() {
    }

    @Override
    public void init() {
        this.removeAll();
        String fname = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.projectInfo.getChaseFileManager().getFile("F_ENERG").getFileName();
        if (!new File(fname).exists()) {
            this.add(new NoFilePanel("F_ENERG"));
            return;
        }
        this.add(new LoadingFilePanel("F_ENERG"));
        if (this.parser == null) {
            this.parser = this.projectInfo.getOutputInterface().getParser("F_ENERG", this);
        }
        this.parser.setParsed(false);
        this.parser.doParse();
    }

    private JPanel createBandPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel panelmode = new JPanel();
        panelmode.setLayout(new BoxLayout(panelmode, 0));
        String[] modes = new String[]{"total", "atom", "layer"};
        JComboBox<String> checkMode = new JComboBox<String>(modes);
        InputPanel width = new InputPanel("width", 0, 5);
        JCheckBox checkFermi = new JCheckBox("with_fermi");
        JCheckBox checkColor = new JCheckBox("");
        return panel;
    }

    private void bootBandPlPanel() {
        String dirString = this.projectInfo.getProjectDirectory();
        String banddata = this.projectInfo.getChaseFileManager().getFile("F_ENERG").getFileName();
        BandPlPanel bpp = new BandPlPanel("run band.pl", dirString, banddata);
        bpp.setVisible(true);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.bootViewer();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.bootViewer();
        }
    }

    class BandCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private int dataIndex = 0;
        private boolean[] crossesFermi;

        BandCellRenderer() {
            this.setOpaque(true);
        }

        BandCellRenderer(boolean[] crossesFermi) {
            this.crossesFermi = crossesFermi;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.crossesFermi[index]) {
                this.setForeground(Color.red);
            } else {
                this.setForeground(Color.black);
            }
            this.setText(value.toString());
            this.setBackground(isSelected ? Color.blue : Color.white);
            return this;
        }
    }
}

