/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.ekcal.inputcheck;

import ciss.phase_viewer.input.PhaseInputChecker;
import ciss.phase_viewer.plugins.projectmanipulator.ekcal.inputcheck.ChargeChecker;
import org.apache.log4j.Logger;

public class EkConvChecker
extends PhaseInputChecker {
    private Logger logger = Logger.getLogger((String)ChargeChecker.class.getName());
    private double defaultDelta = 1.0E-5;

    @Override
    public boolean isFixable() {
        return true;
    }

    @Override
    public String getName() {
        return "ek_convergence";
    }

    @Override
    public String getDescription() {
        return "check the 'ek_convergence' block.";
    }

    @Override
    public String getCandidate() {
        String ret = "";
        if (this.state != 0) {
            ret = "will set delta_eigenvalue to 1.0e-5 hartree";
        }
        return ret;
    }

    @Override
    public boolean fixInput() {
        this.fixPrimitiveEntry("accuracy.ek_convergence", "delta_eigenvalue", "1e-5", "Hartree");
        return true;
    }

    @Override
    public int doCheck() {
        String delta_eigen = this.inputInterface.getInputInterfacePrimitiveEntry("accuracy.ek_convergence.delta_eigenvalue").getValue();
        double del = 0.0;
        this.state = 0;
        this.message = "";
        try {
            del = Double.parseDouble(delta_eigen);
            if (del < 0.0) {
                this.state = -2;
                this.message = "delta_eigenvalue is negative";
            } else if (del < 1.0E-8) {
                this.message = "delta_eigenvalue is probably too small;" + this.LS;
                this.message = String.valueOf(this.message) + "your calculation may not converge";
                this.state = -1;
            }
        }
        catch (NumberFormatException e) {
            this.message = "delta_eigenvalue is probably too small;" + this.LS;
            this.message = String.valueOf(this.message) + "your calculation will probably not converge";
            this.state = -1;
        }
        return this.state;
    }
}

