/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.graph.plotattributes;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.FontChooser;
import ciss.phase_viewer.common.ImageFilter;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesEditor;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesSubEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.Format;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYImageAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;

public class Annotations
extends PlotAttributesSubEditor {
    private Logger logger = Logger.getLogger((String)Annotations.class.getName());
    private XYPlot xyplot;
    private JPanel me;
    private double avx;
    private double avy;
    private Format form = ConstParameters.formater_smaller_digits;
    private JTextField tftextannotation;
    private JTextField tftextannotationposx;
    private JTextField tftextannotationposy;
    private JTextField tftextannotationrotation;
    private JButton btntextannotation;
    private JComboBox combotextannotation;
    private String imageFileName;
    private JButton btnimageselect;
    private JTextField tfimagescale;
    private JTextField tfimageposx;
    private JTextField tfimageposy;
    private JCheckBox cbptan;
    private JButton btnptanlabelfont;
    private JTextField tfptanposx;
    private JTextField tfptanposy;
    private JTextField tfptanrotate;
    private JTextField tfptanbase;
    private JTextField tfptanlabel;
    private JTextField tfptanlabeloffset;

    public Annotations(PlotAttributesEditor parent) {
        super(parent);
    }

    @Override
    protected void init() {
        this.me = this;
        if (this.parent == null) {
            this.logger.debug((Object)"'parent' is null.");
            return;
        }
        Plot plot = this.parent.getSelectedPlot();
        if (plot == null) {
            this.logger.debug((Object)"'plot' is null.");
            return;
        }
        if (!(plot instanceof XYPlot)) {
            return;
        }
        this.xyplot = (XYPlot)plot;
    }

    @Override
    public boolean updateChart() {
        String text = this.tftextannotation.getText();
        double textposx = 0.0;
        double textposy = 0.0;
        double textrot = 0.0;
        try {
            textposx = Double.parseDouble(this.tftextannotationposx.getText().trim());
            textposy = Double.parseDouble(this.tftextannotationposy.getText().trim());
            textrot = Double.parseDouble(this.tftextannotationrotation.getText().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        XYTextAnnotation textAnnotation = new XYTextAnnotation(text, textposx, textposy);
        textAnnotation.setFont(this.btntextannotation.getFont());
        textAnnotation.setRotationAngle(Math.PI * textrot / 180.0);
        if (this.combotextannotation.getSelectedIndex() != 1) {
            this.xyplot.clearAnnotations();
        }
        if (this.combotextannotation.getSelectedIndex() != 2) {
            this.xyplot.addAnnotation((XYAnnotation)textAnnotation);
        }
        if (this.imageFileName != null) {
            File f = new File(this.imageFileName);
            double imageScale = 1.0;
            double imposx = 0.0;
            double imposy = 0.0;
            try {
                imageScale = Double.valueOf(this.tfimagescale.getText());
                imposx = Double.valueOf(this.tfimageposx.getText());
                imposy = Double.valueOf(this.tfimageposy.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            int image_width = (int)((double)this.parent.getGraphPanel().getSize().width * imageScale);
            try {
                BufferedImage image = ImageIO.read(f);
                XYImageAnnotation imageAnnotation = new XYImageAnnotation(imposx, imposy, image.getScaledInstance(image_width, -100, 4));
                this.xyplot.addAnnotation((XYAnnotation)imageAnnotation);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.logger.error((Object)"failed to put image annotation");
            }
        }
        if (this.cbptan.isSelected()) {
            String pttext = this.tfptanlabel.getText();
            double ptx = 0.0;
            double pty = 0.0;
            double ptrot = 0.0;
            double ptbase = 0.0;
            double ptoffset = 0.0;
            try {
                ptx = Double.parseDouble(this.tfptanposx.getText());
                pty = Double.parseDouble(this.tfptanposy.getText());
                ptrot = Double.parseDouble(this.tfptanrotate.getText());
                ptbase = Double.parseDouble(this.tfptanbase.getText());
                ptoffset = Double.parseDouble(this.tfptanlabeloffset.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            XYPointerAnnotation pointerAnnotation = new XYPointerAnnotation(pttext, ptx, pty, Math.PI * ptrot / 180.0);
            pointerAnnotation.setBaseRadius(ptbase);
            pointerAnnotation.setLabelOffset(ptoffset);
            pointerAnnotation.setFont(this.btnptanlabelfont.getFont());
            this.xyplot.addAnnotation((XYAnnotation)pointerAnnotation);
        }
        return true;
    }

    @Override
    protected void initGUI() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        p.add((Component)this.createText(), constraints);
        constraints.gridy = 1;
        p.add((Component)this.createImage(), constraints);
        constraints.gridy = 2;
        p.add((Component)this.createArrow(), constraints);
        this.add((Component)p, "North");
    }

    private JPanel createText() {
        String[] strtextannotation = new String[]{"new", "add", "clear all"};
        JPanel ptextan = new JPanel();
        ptextan.setLayout(new BoxLayout(ptextan, 1));
        ptextan.setBorder(new TitledBorder("text annotation"));
        JPanel pcomboandpos = new JPanel();
        pcomboandpos.setLayout(new BoxLayout(pcomboandpos, 0));
        JPanel pcombo = new JPanel();
        this.combotextannotation = new JComboBox<String>(strtextannotation);
        JPanel pcombotext = new JPanel();
        pcombotext.setBorder(new TitledBorder("mode"));
        pcombotext.add(this.combotextannotation);
        pcombo.add(pcombotext);
        pcomboandpos.add(pcombo);
        JPanel tfpos = new JPanel();
        JPanel tfx = new JPanel();
        JPanel tfy = new JPanel();
        JPanel tfrot = new JPanel();
        tfx.setBorder(new TitledBorder("position (x)"));
        tfy.setBorder(new TitledBorder("position (y)"));
        tfrot.setBorder(new TitledBorder("rot (degrees)"));
        this.tftextannotationposx = new JTextField(7);
        this.tftextannotationposy = new JTextField(7);
        this.tftextannotationrotation = new JTextField(7);
        tfx.add(this.tftextannotationposx);
        tfy.add(this.tftextannotationposy);
        tfrot.add(this.tftextannotationrotation);
        tfpos.add(tfx);
        tfpos.add(tfy);
        tfpos.add(tfrot);
        pcomboandpos.add(tfpos);
        this.avx = (this.xyplot.getDomainAxis().getLowerBound() + this.xyplot.getDomainAxis().getUpperBound()) / 2.0;
        this.avy = (this.xyplot.getRangeAxis().getLowerBound() + this.xyplot.getRangeAxis().getUpperBound()) / 2.0;
        this.tftextannotationposx.setText(this.form.format(new Double(this.avx)));
        this.tftextannotationposy.setText(this.form.format(new Double(this.avy)));
        this.tftextannotationrotation.setText("0.0");
        ptextan.add(pcomboandpos);
        this.tftextannotation = new JTextField(15);
        JPanel ptftext = new JPanel();
        ptftext.setBorder(new TitledBorder("annotation text"));
        ptftext.setLayout(new BoxLayout(ptftext, 0));
        this.btntextannotation = new JButton("select font");
        ptftext.add(this.tftextannotation);
        ptftext.add(this.btntextannotation);
        ptextan.add(ptftext);
        this.btntextannotation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font font = FontChooser.chooseFont(Annotations.this.btntextannotation.getFont(), Annotations.this.me);
                Annotations.this.btntextannotation.setFont(font);
            }
        });
        return ptextan;
    }

    private JPanel createImage() {
        JPanel pimagean = new JPanel();
        pimagean.setBorder(new TitledBorder("image annotation"));
        pimagean.setLayout(new BoxLayout(pimagean, 0));
        this.btnimageselect = new JButton("choose image file");
        JPanel pimagepos = new JPanel();
        pimagepos.setLayout(new BoxLayout(pimagepos, 0));
        this.tfimagescale = new JTextField(7);
        this.tfimagescale.setText("1.0");
        JPanel pimscale = new JPanel();
        pimscale.setBorder(new TitledBorder("scale"));
        pimscale.add(this.tfimagescale);
        this.tfimageposx = new JTextField(7);
        JPanel pimposx = new JPanel();
        pimposx.setBorder(new TitledBorder("position(x)"));
        pimposx.add(this.tfimageposx);
        this.tfimageposx.setText(this.form.format(new Double(this.avx)));
        this.tfimageposy = new JTextField(7);
        JPanel pimposy = new JPanel();
        pimposy.setBorder(new TitledBorder("position(y)"));
        pimposy.add(this.tfimageposy);
        this.tfimageposy.setText(this.form.format(new Double(this.avy)));
        pimagepos.add(pimscale);
        pimagepos.add(pimposx);
        pimagepos.add(pimposy);
        pimagean.add(this.btnimageselect);
        pimagean.add(pimagepos);
        this.btnimageselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChaseFileChooser fdlg = new ChaseFileChooser("media");
                fdlg.setDialogType(2);
                fdlg.setDialogTitle("select image");
                fdlg.setFileSelectionMode(0);
                fdlg.addChoosableFileFilter(new ImageFilter());
                if (fdlg.showDialog(Annotations.this.me, "open") != 0) {
                    Annotations.this.imageFileName = null;
                } else {
                    Annotations.this.imageFileName = fdlg.getSelectedFile().getAbsolutePath();
                    File file = new File(Annotations.this.imageFileName);
                    Annotations.this.btnimageselect.setText(file.getName());
                }
            }
        });
        return pimagean;
    }

    private JPanel createArrow() {
        this.cbptan = new JCheckBox("display");
        JPanel parrowattributes = new JPanel();
        parrowattributes.setLayout(new BoxLayout(parrowattributes, 0));
        this.tfptanposx = new JTextField(5);
        JPanel ptfptanposx = new JPanel();
        ptfptanposx.setBorder(new TitledBorder("position(x)"));
        ptfptanposx.add(this.tfptanposx);
        this.tfptanposx.setText(this.form.format(new Double(this.avx)));
        this.tfptanposy = new JTextField(5);
        JPanel ptfptanposy = new JPanel();
        ptfptanposy.setBorder(new TitledBorder("position(y)"));
        ptfptanposy.add(this.tfptanposy);
        this.tfptanposy.setText(this.form.format(new Double(this.avy)));
        this.tfptanrotate = new JTextField(5);
        JPanel ptfptanrotate = new JPanel();
        ptfptanrotate.setBorder(new TitledBorder("rotate(deg.)"));
        ptfptanrotate.add(this.tfptanrotate);
        this.tfptanrotate.setText("0.0");
        this.tfptanbase = new JTextField(5);
        JPanel ptfptanbase = new JPanel();
        ptfptanbase.setBorder(new TitledBorder("base"));
        ptfptanbase.add(this.tfptanbase);
        this.tfptanbase.setText("50.0");
        parrowattributes.add(ptfptanposx);
        parrowattributes.add(ptfptanposy);
        parrowattributes.add(ptfptanrotate);
        parrowattributes.add(ptfptanbase);
        JPanel parrow = new JPanel();
        parrow.setLayout(new BoxLayout(parrow, 0));
        parrow.add(this.cbptan);
        parrow.add(parrowattributes);
        JPanel pptan = new JPanel();
        pptan.add(parrow);
        JPanel parrowlabel = new JPanel();
        parrowlabel.setLayout(new BoxLayout(parrowlabel, 0));
        this.tfptanlabel = new JTextField(7);
        JPanel ptfptanlabel = new JPanel();
        ptfptanlabel.setBorder(new TitledBorder("label text"));
        ptfptanlabel.add(this.tfptanlabel);
        this.btnptanlabelfont = new JButton("select font");
        JPanel pbtnptanlabelfont = new JPanel();
        pbtnptanlabelfont.setBorder(new TitledBorder("label font"));
        pbtnptanlabelfont.add(this.btnptanlabelfont);
        this.tfptanlabeloffset = new JTextField(5);
        JPanel ptfptanlabeloffset = new JPanel();
        ptfptanlabeloffset.setBorder(new TitledBorder("label offset"));
        ptfptanlabeloffset.add(this.tfptanlabeloffset);
        this.tfptanlabeloffset.setText("10.0");
        parrowlabel.add(ptfptanlabel);
        parrowlabel.add(pbtnptanlabelfont);
        parrowlabel.add(ptfptanlabeloffset);
        pptan.setBorder(new TitledBorder("arrow annotation"));
        pptan.setLayout(new BoxLayout(pptan, 1));
        pptan.add(parrowlabel);
        this.btnptanlabelfont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font font = FontChooser.chooseFont(Annotations.this.btnptanlabelfont.getFont(), Annotations.this.me);
                Annotations.this.btnptanlabelfont.setFont(font);
            }
        });
        return pptan;
    }

    @Override
    public void plotChanged(Plot plot) {
        this.updateChart();
        this.init();
        this.initGUI();
        this.revalidate();
    }
}

