/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.mainpanel;

import ciss.phase_viewer.mainpanel.ChaseDesktop;
import ciss.phase_viewer.mainpanel.ChaseFrame;
import ciss.phase_viewer.mainpanel.ComponentListenerFrameChase;
import ciss.phase_viewer.mainpanel.Desktop4Frame;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class FrameChase
extends JFrame
implements ChaseFrame {
    private int mode = 0;
    private Dimension size;
    private FrameChase This;
    private boolean register = true;

    public FrameChase(String title, int mode, Dimension size) {
        super(title);
        this.mode = mode;
        this.size = size;
        this.This = this;
        this.initFrame();
    }

    public FrameChase(String title, Dimension size) {
        super(title);
        this.size = size;
        this.This = this;
        this.initFrame();
    }

    public FrameChase(String title, Dimension size, boolean register) {
        super(title);
        this.size = size;
        this.This = this;
        this.register = register;
        this.initFrame();
    }

    private void initFrame() {
        if (this.register) {
            Desktop4Frame.getDesktop().add(this);
        }
        Desktop4Frame.getDesktop().initialLocation(this, this.mode);
        int x = this.size.width;
        int y = this.size.height;
        GlobalProperties props = PropertiesManager.getGlobalProperties(6);
        String ident = FrameChase.class.getName();
        String title = this.getTitle();
        String winx = String.valueOf(ident) + "." + title + ".window_size_x";
        String winy = String.valueOf(ident) + "." + title + ".window_size_y";
        try {
            x = Integer.parseInt(props.getProperty(winx));
            y = Integer.parseInt(props.getProperty(winy));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSize(x, y);
        this.addComponentListener(new ComponentListenerFrameChase(this));
        this.addWindowListener(new WindowAdapterThis());
    }

    @Override
    public void dispose() {
        Desktop4Frame.getDesktop().remove(this);
        super.dispose();
    }

    @Override
    public ChaseDesktop getDesktop() {
        return Desktop4Frame.getDesktop();
    }

    @Override
    public void selected() {
    }

    @Override
    public void selected(boolean init) {
    }

    @Override
    public void unselect() {
    }

    @Override
    public boolean isHeavyWeight() {
        return true;
    }

    @Override
    public void saveState() {
        String ident = FrameChase.class.getName();
        String title = this.getTitle();
        String winx = String.valueOf(ident) + "." + title + ".window_size_x";
        String winy = String.valueOf(ident) + "." + title + ".window_size_y";
        GlobalProperties props = PropertiesManager.getGlobalProperties(6);
        props.setProperty(winx, String.valueOf(this.getSize().width));
        props.setProperty(winy, String.valueOf(this.getSize().height));
        props.storeProperty();
    }

    class WindowAdapterThis
    extends WindowAdapter {
        WindowAdapterThis() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            Desktop4Frame.getDesktop().remove(FrameChase.this.This);
        }
    }
}

